/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.capabilities.ancient;

import com.infamous.dungeons_mobs.capabilities.ancient.Ancient;
import com.infamous.dungeons_mobs.capabilities.ancient.AncientHelper;
import net.minecraft.client.model.EntityModel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_libraries")
public class AncientSizeEvents {
    @SubscribeEvent
    public static void onEntityEventSize(EntityEvent.Size event) {
        Entity entity = event.getEntity();
        Ancient cap = AncientHelper.getAncientCapability(entity);
        if (cap.isAncient()) {
            float totalWidth = event.getNewSize().f_20377_ * 1.2f;
            float totalHeight = event.getNewSize().f_20378_ * 1.2f;
            event.setNewEyeHeight(event.getNewEyeHeight() * 1.2f);
            event.setNewSize(EntityDimensions.m_20398_((float)totalWidth, (float)totalHeight));
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onRenderLivingEventPre(RenderLivingEvent.Pre<LivingEntity, EntityModel<LivingEntity>> event) {
        LivingEntity entity = event.getEntity();
        Ancient cap = AncientHelper.getAncientCapability((Entity)entity);
        if (cap.isAncient()) {
            event.getPoseStack().m_85836_();
            event.getPoseStack().m_85841_(1.1f, 1.1f, 1.1f);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onRenderLivingEventPost(RenderLivingEvent.Post<LivingEntity, EntityModel<LivingEntity>> event) {
        LivingEntity entity = event.getEntity();
        Ancient cap = AncientHelper.getAncientCapability((Entity)entity);
        if (cap.isAncient()) {
            event.getPoseStack().m_85849_();
        }
    }
}

