/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.capabilities.convertible;

import com.infamous.dungeons_mobs.DungeonsMobs;
import com.infamous.dungeons_mobs.capabilities.ModCapabilities;
import com.infamous.dungeons_mobs.capabilities.convertible.Convertible;
import com.infamous.dungeons_mobs.entities.water.SunkenSkeletonEntity;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.tags.EntityTags;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class ConvertibleHelper {
    public static Convertible getConvertibleCapability(Entity entity) {
        return (Convertible)entity.getCapability(ModCapabilities.CONVERTIBLE_CAPABILITY).orElse((Object)new Convertible());
    }

    public static void onDrownedAndConvertedTo(Mob original, Mob convertedTo) {
        if (original instanceof AbstractSkeleton && convertedTo instanceof SunkenSkeletonEntity) {
            if (!original.m_20067_()) {
                original.f_19853_.m_5898_(null, 1040, original.m_20183_(), 0);
            }
            DungeonsMobs.LOGGER.info("Converted {} to {}", (Object)original, (Object)convertedTo);
        }
        if (original instanceof Zombie && convertedTo instanceof Zombie) {
            Zombie originalZombie = (Zombie)original;
            Zombie convertedToZombie = (Zombie)convertedTo;
            ConvertibleHelper.handleZombieAttributes(convertedToZombie);
            ConvertibleHelper.setZombieCanBreakDoors(originalZombie, convertedToZombie);
        }
        ForgeEventFactory.onLivingConvert((LivingEntity)original, (LivingEntity)convertedTo);
    }

    private static void setZombieCanBreakDoors(Zombie originalZombie, Zombie convertedToZombie) {
        Method supportsBreakDoorGoalMethod = ObfuscationReflectionHelper.findMethod(Zombie.class, (String)"func_204900_dz", (Class[])new Class[0]);
        try {
            convertedToZombie.m_34336_((Boolean)supportsBreakDoorGoalMethod.invoke((Object)convertedToZombie, new Object[0]) != false && originalZombie.m_34330_());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private static void handleZombieAttributes(Zombie convertedToZombie) {
        Method handleAttributesMethod = ObfuscationReflectionHelper.findMethod(Zombie.class, (String)"func_207304_a", (Class[])new Class[]{Float.class});
        try {
            handleAttributesMethod.invoke((Object)convertedToZombie, Float.valueOf(convertedToZombie.f_19853_.m_6436_(convertedToZombie.m_20183_()).m_19057_()));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static EntityType<? extends Mob> getDrowningConvertTo(Mob mob) {
        EntityType convertToType = mob.m_6095_();
        if (mob instanceof AbstractSkeleton) {
            convertToType = (EntityType)ModEntityTypes.SUNKEN_SKELETON.get();
        }
        return convertToType;
    }

    public static boolean convertsInWater(Mob mobEntity) {
        return mobEntity.m_6095_().m_204039_(EntityTags.CONVERTS_IN_WATER);
    }
}

