/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.models.blaze;

import com.infamous.dungeons_mobs.entities.blaze.WildfireEntity;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.molang.MolangParser;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;
import software.bernie.geckolib3.resource.GeckoLibCache;

public class WildfireModel
extends AnimatedGeoModel {
    public ResourceLocation getAnimationResource(Object entity) {
        return new ResourceLocation("dungeons_mobs", "animations/wildfire.animation.json");
    }

    public ResourceLocation getModelResource(Object entity) {
        return new ResourceLocation("dungeons_mobs", "geo/wildfire.geo.json");
    }

    public ResourceLocation getTextureResource(Object entity) {
        return new ResourceLocation("dungeons_mobs", "textures/entity/blaze/wildfire.png");
    }

    public void setCustomAnimations(IAnimatable entity, int uniqueID, AnimationEvent customPredicate) {
        super.setCustomAnimations(entity, uniqueID, customPredicate);
        LivingEntity entityIn = (LivingEntity)entity;
        IBone head = this.getAnimationProcessor().getBone("head");
        IBone shield1 = this.getAnimationProcessor().getBone("shield1");
        IBone shield2 = this.getAnimationProcessor().getBone("shield2");
        IBone shield3 = this.getAnimationProcessor().getBone("shield3");
        IBone shield4 = this.getAnimationProcessor().getBone("shield4");
        WildfireEntity wildfire = (WildfireEntity)entity;
        if (wildfire.getShields() >= 4) {
            shield1.setHidden(false);
            shield2.setHidden(false);
            shield3.setHidden(false);
            shield4.setHidden(false);
        } else if (wildfire.getShields() == 3) {
            shield1.setHidden(true);
            shield2.setHidden(false);
            shield3.setHidden(false);
            shield4.setHidden(false);
        } else if (wildfire.getShields() == 2) {
            shield1.setHidden(true);
            shield2.setHidden(true);
            shield3.setHidden(false);
            shield4.setHidden(false);
        } else if (wildfire.getShields() == 1) {
            shield1.setHidden(true);
            shield2.setHidden(true);
            shield3.setHidden(true);
            shield4.setHidden(false);
        } else if (wildfire.getShields() <= 0) {
            shield1.setHidden(true);
            shield2.setHidden(true);
            shield3.setHidden(true);
            shield4.setHidden(true);
        }
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        if (extraData.headPitch != 0.0f || extraData.netHeadYaw != 0.0f) {
            head.setRotationX(head.getRotationX() + extraData.headPitch * ((float)Math.PI / 180));
            head.setRotationY(head.getRotationY() + extraData.netHeadYaw * ((float)Math.PI / 180));
        }
    }

    public void setMolangQueries(IAnimatable animatable, double currentTick) {
        super.setMolangQueries(animatable, currentTick);
        MolangParser parser = GeckoLibCache.getInstance().parser;
        LivingEntity livingEntity = (LivingEntity)animatable;
        Vec3 velocity = livingEntity.m_20184_();
        float groundSpeed = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
        parser.setValue("query.ground_speed", () -> groundSpeed * 30.0f);
    }
}

