/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.models.golem;

import com.infamous.dungeons_mobs.entities.golem.SquallGolemEntity;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

public class SquallGolemModel
extends AnimatedGeoModel {
    public ResourceLocation getAnimationResource(Object entity) {
        return new ResourceLocation("dungeons_mobs", "animations/squall_golem.animation.json");
    }

    public ResourceLocation getModelResource(Object entity) {
        return new ResourceLocation("dungeons_mobs", "geo/squall_golem.geo.json");
    }

    public ResourceLocation getTextureResource(Object entity) {
        return new ResourceLocation("dungeons_mobs", "textures/entity/golem/squall_golem.png");
    }

    public void setCustomAnimations(IAnimatable entity, int uniqueID, AnimationEvent customPredicate) {
        super.setCustomAnimations(entity, uniqueID, customPredicate);
        SquallGolemEntity entityIn = (SquallGolemEntity)entity;
        IBone head = this.getAnimationProcessor().getBone("head");
        IBone eye = this.getAnimationProcessor().getBone("head2");
        IBone eyeBrow = this.getAnimationProcessor().getBone("head3");
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        if (extraData.headPitch != 0.0f || extraData.netHeadYaw != 0.0f) {
            eye.setPositionX((float)Math.max(Math.min((double)(extraData.netHeadYaw / 80.0f) + Math.sin((double)eye.getPositionX() * Math.PI / 180.0), 1.0), -1.0));
            head.setRotationX(head.getRotationX() + extraData.headPitch * ((float)Math.PI / 180));
            head.setRotationZ(head.getRotationZ() + extraData.netHeadYaw * ((float)Math.PI / 180));
            eye.setPositionY(Math.max(Math.min(extraData.headPitch / 80.0f, 0.15f), -0.2f));
            eyeBrow.setPositionY(Math.max(Math.min(extraData.headPitch / 80.0f, 0.15f), -0.2f));
        }
    }
}

