/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.models.illager;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.infamous.dungeons_mobs.entities.illagers.IllagerArmsUtil;
import com.infamous.dungeons_mobs.entities.illagers.MountaineerEntity;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.UseAnim;

public class IllagerBipedModel<T extends AbstractIllager>
extends HumanoidModel<T> {
    public ModelPart nose;
    public ModelPart jacket;
    public ModelPart arms;

    public IllagerBipedModel(ModelPart part) {
        super(part);
        this.nose = this.f_102808_.m_171324_("nose");
        this.jacket = this.f_102810_.m_171324_("jacket");
        this.arms = part.m_171324_("arms");
        this.f_102809_.f_104207_ = false;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = HumanoidModel.m_170681_((CubeDeformation)CubeDeformation.f_171458_, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition partdefinition1 = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition1.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 12.0f, 8.0f, new CubeDeformation(0.45f)), PartPose.f_171404_);
        partdefinition1.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171481_(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171481_(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        body.m_171599_("jacket", CubeListBuilder.m_171558_().m_171514_(0, 38).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 18.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition partdefinition2 = partdefinition.m_171599_("arms", CubeListBuilder.m_171558_().m_171514_(44, 22).m_171481_(-8.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f).m_171514_(40, 38).m_171481_(-4.0f, 2.0f, -2.0f, 8.0f, 4.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)-1.0f, (float)-0.75f, (float)0.0f, (float)0.0f));
        partdefinition2.m_171599_("left_shoulder", CubeListBuilder.m_171558_().m_171514_(44, 22).m_171480_().m_171481_(4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f), PartPose.f_171404_);
        partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.0f));
        partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171480_().m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.0f));
        partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171481_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171480_().m_171481_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    protected Iterable<ModelPart> m_5608_() {
        return Iterables.concat((Iterable)super.m_5608_(), (Iterable)ImmutableList.of((Object)this.arms, (Object)this.jacket));
    }

    public void prepareMobModel(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.f_102816_ = HumanoidModel.ArmPose.EMPTY;
        this.f_102815_ = HumanoidModel.ArmPose.EMPTY;
        if (entityIn.m_5737_() == HumanoidArm.RIGHT) {
            this.giveModelRightArmPoses(InteractionHand.MAIN_HAND, entityIn);
            this.giveModelLeftArmPoses(InteractionHand.OFF_HAND, entityIn);
        } else {
            this.giveModelRightArmPoses(InteractionHand.OFF_HAND, entityIn);
            this.giveModelLeftArmPoses(InteractionHand.MAIN_HAND, entityIn);
        }
        super.m_6839_(entityIn, limbSwing, limbSwingAmount, partialTick);
    }

    private void giveModelRightArmPoses(InteractionHand hand, T entityIn) {
        ItemStack itemstack = entityIn.m_21120_(hand);
        UseAnim useaction = itemstack.m_41780_();
        if (entityIn.m_6768_() != AbstractIllager.IllagerArmPose.CROSSED || !IllagerArmsUtil.armorHasCrossedArms(entityIn, entityIn.m_6844_(EquipmentSlot.CHEST))) {
            switch (useaction) {
                case BLOCK: {
                    if (entityIn.m_21254_()) {
                        this.f_102816_ = HumanoidModel.ArmPose.BLOCK;
                        break;
                    }
                    this.f_102816_ = HumanoidModel.ArmPose.ITEM;
                    break;
                }
                case CROSSBOW: {
                    this.f_102816_ = HumanoidModel.ArmPose.CROSSBOW_HOLD;
                    if (!entityIn.m_6117_()) break;
                    this.f_102816_ = HumanoidModel.ArmPose.CROSSBOW_CHARGE;
                    break;
                }
                case BOW: {
                    this.f_102816_ = HumanoidModel.ArmPose.BOW_AND_ARROW;
                    break;
                }
                case SPEAR: {
                    this.f_102815_ = HumanoidModel.ArmPose.THROW_SPEAR;
                    break;
                }
                default: {
                    this.f_102816_ = HumanoidModel.ArmPose.EMPTY;
                    if (itemstack.m_41619_()) break;
                    this.f_102816_ = HumanoidModel.ArmPose.ITEM;
                }
            }
        }
    }

    private void giveModelLeftArmPoses(InteractionHand hand, T entityIn) {
        ItemStack itemstack = entityIn.m_21120_(hand);
        UseAnim useaction = itemstack.m_41780_();
        if (entityIn.m_6768_() != AbstractIllager.IllagerArmPose.CROSSED || !IllagerArmsUtil.armorHasCrossedArms(entityIn, entityIn.m_6844_(EquipmentSlot.CHEST))) {
            switch (useaction) {
                case BLOCK: {
                    if (entityIn.m_21254_()) {
                        this.f_102815_ = HumanoidModel.ArmPose.BLOCK;
                        break;
                    }
                    this.f_102815_ = HumanoidModel.ArmPose.ITEM;
                    break;
                }
                case CROSSBOW: {
                    this.f_102815_ = HumanoidModel.ArmPose.CROSSBOW_HOLD;
                    if (!entityIn.m_6117_()) break;
                    this.f_102815_ = HumanoidModel.ArmPose.CROSSBOW_CHARGE;
                    break;
                }
                case BOW: {
                    this.f_102815_ = HumanoidModel.ArmPose.BOW_AND_ARROW;
                    break;
                }
                case SPEAR: {
                    this.f_102815_ = HumanoidModel.ArmPose.THROW_SPEAR;
                    break;
                }
                default: {
                    this.f_102815_ = HumanoidModel.ArmPose.EMPTY;
                    if (itemstack.m_41619_()) break;
                    this.f_102815_ = HumanoidModel.ArmPose.ITEM;
                }
            }
        }
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean flag;
        super.m_6973_(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        AbstractIllager.IllagerArmPose armpose = entityIn.m_6768_();
        this.arms.f_104201_ = 3.0f;
        this.arms.f_104202_ = -1.0f;
        this.arms.f_104203_ = -0.75f;
        this.jacket.m_104315_(this.f_102810_);
        boolean isWearingChestplateOrLeggings = entityIn.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof ArmorItem || entityIn.m_6844_(EquipmentSlot.LEGS).m_41720_() instanceof ArmorItem;
        this.jacket.f_104207_ = !isWearingChestplateOrLeggings;
        this.arms.f_104207_ = flag = armpose == AbstractIllager.IllagerArmPose.CROSSED && IllagerArmsUtil.armorHasCrossedArms(entityIn, entityIn.m_6844_(EquipmentSlot.CHEST));
        this.f_102812_.f_104207_ = !flag;
        this.f_102811_.f_104207_ = !flag;
        float f = 1.0f;
        if (flag) {
            f = (float)entityIn.m_20184_().m_82556_();
            f /= 0.2f;
            f = f * f * f;
        }
        if (f < 1.0f) {
            f = 1.0f;
        }
        if (flag) {
            this.f_102812_.f_104201_ = 3.0f;
            this.f_102812_.f_104202_ = -1.0f;
            this.f_102812_.f_104203_ = -0.75f;
            this.f_102811_.f_104201_ = 3.0f;
            this.f_102811_.f_104202_ = -1.0f;
            this.f_102811_.f_104203_ = -0.75f;
        }
        if (this.f_102609_) {
            this.f_102811_.f_104203_ = -0.62831855f;
            this.f_102811_.f_104204_ = 0.0f;
            this.f_102811_.f_104205_ = 0.0f;
            this.f_102812_.f_104203_ = -0.62831855f;
            this.f_102812_.f_104204_ = 0.0f;
            this.f_102812_.f_104205_ = 0.0f;
            this.f_102814_.f_104203_ = -1.4137167f;
            this.f_102814_.f_104204_ = 0.31415927f;
            this.f_102814_.f_104205_ = 0.07853982f;
            this.f_102813_.f_104203_ = -1.4137167f;
            this.f_102813_.f_104204_ = -0.31415927f;
            this.f_102813_.f_104205_ = -0.07853982f;
        } else {
            this.f_102814_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
            this.f_102814_.f_104204_ = 0.0f;
            this.f_102814_.f_104205_ = 0.0f;
            this.f_102813_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
            this.f_102813_.f_104204_ = 0.0f;
            this.f_102813_.f_104205_ = 0.0f;
        }
        if (entityIn instanceof MountaineerEntity && ((MountaineerEntity)entityIn).isClimbing()) {
            this.f_102811_.f_104203_ = -1.8849558f + Mth.m_14031_((float)(ageInTicks * 0.35f)) * 0.5f;
            this.f_102812_.f_104203_ = -1.8849558f - Mth.m_14031_((float)(ageInTicks * 0.35f)) * 0.5f;
        } else {
            switch (armpose) {
                case ATTACKING: {
                    if (entityIn.m_21205_().m_41619_() || entityIn.m_21205_().m_41720_() instanceof ProjectileWeaponItem || entityIn.m_21254_()) break;
                    AnimationUtils.m_102091_((ModelPart)this.f_102811_, (ModelPart)this.f_102812_, entityIn, (float)this.f_102608_, (float)ageInTicks);
                    break;
                }
                case CELEBRATING: {
                    this.f_102811_.f_104202_ = 0.0f;
                    this.f_102811_.f_104200_ = -5.0f;
                    this.f_102811_.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.05f;
                    this.f_102811_.f_104205_ = 2.670354f;
                    this.f_102811_.f_104204_ = 0.0f;
                    this.f_102812_.f_104202_ = 0.0f;
                    this.f_102812_.f_104200_ = 5.0f;
                    this.f_102812_.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.05f;
                    this.f_102812_.f_104205_ = -2.3561945f;
                    this.f_102812_.f_104204_ = 0.0f;
                    break;
                }
                case SPELLCASTING: {
                    this.f_102811_.f_104202_ = 0.0f;
                    this.f_102811_.f_104200_ = -5.0f;
                    this.f_102812_.f_104202_ = 0.0f;
                    this.f_102812_.f_104200_ = 5.0f;
                    this.f_102811_.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
                    this.f_102812_.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
                    this.f_102811_.f_104205_ = 2.3561945f;
                    this.f_102812_.f_104205_ = -2.3561945f;
                    this.f_102811_.f_104204_ = 0.0f;
                    this.f_102812_.f_104204_ = 0.0f;
                    break;
                }
            }
        }
    }

    public void copyPropertiesTo(IllagerBipedModel<T> p_217148_1_) {
        super.m_102872_(p_217148_1_);
        p_217148_1_.arms.m_104315_(this.arms);
        p_217148_1_.jacket.m_104315_(this.jacket);
    }
}

