/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.renderer.layers;

import com.infamous.dungeons_mobs.client.models.FungusSackModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class FungusSackLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation SACK_LOCATION = new ResourceLocation("dungeons_mobs", "textures/entity/fungus_sack.png");
    private final FungusSackModel<T> fungusSackModel;

    public FungusSackLayer(RenderLayerParent<T, M> entityRenderer, FungusSackModel<T> fungusSackModel) {
        super(entityRenderer);
        this.fungusSackModel = fungusSackModel;
    }

    public void render(PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int p_225628_3_, T wearer, float p_225628_5_, float p_225628_6_, float p_225628_7_, float p_225628_8_, float p_225628_9_, float p_225628_10_) {
        ItemStack itemstack = this.getSackItem(wearer);
        if (this.shouldRender(itemstack, wearer)) {
            ResourceLocation resourcelocation = this.getSackTexture(itemstack, wearer);
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, 0.0, 0.0);
            this.m_117386_().m_102624_(this.fungusSackModel);
            this.fungusSackModel.setupAnim(wearer, p_225628_5_, p_225628_6_, p_225628_8_, p_225628_9_, p_225628_10_);
            VertexConsumer ivertexbuilder = ItemRenderer.m_115184_((MultiBufferSource)renderTypeBuffer, (RenderType)RenderType.m_110431_((ResourceLocation)resourcelocation), (boolean)false, (boolean)false);
            this.fungusSackModel.m_7695_(matrixStack, ivertexbuilder, p_225628_3_, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.m_85849_();
        }
    }

    private ItemStack getSackItem(T wearer) {
        return ItemStack.f_41583_;
    }

    public boolean shouldRender(ItemStack stack, T entity) {
        return true;
    }

    public ResourceLocation getSackTexture(ItemStack stack, T entity) {
        return SACK_LOCATION;
    }
}

