/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.renderer.layers;

import com.infamous.dungeons_mobs.client.models.illager.IllagerBipedModel;
import com.infamous.dungeons_mobs.entities.illagers.IllagerArmsUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class IllagerBipedArmorLayer<T extends AbstractIllager, M extends IllagerBipedModel<T>, A extends HumanoidModel<T>>
extends HumanoidArmorLayer<T, M, A> {
    private final A armorModel;
    private final IllagerBipedModel<T> crossedArmsArmorModel;

    public IllagerBipedArmorLayer(RenderLayerParent<T, M> p_i50936_1_, A p_i50936_2_, A p_i50936_3_, IllagerBipedModel<T> crossedArmsArmorModel) {
        super(p_i50936_1_, p_i50936_2_, p_i50936_3_);
        this.armorModel = p_i50936_3_;
        this.crossedArmsArmorModel = crossedArmsArmorModel;
    }

    public void render(PoseStack p_225628_1_, MultiBufferSource p_225628_2_, int p_225628_3_, T p_225628_4_, float p_225628_5_, float p_225628_6_, float p_225628_7_, float p_225628_8_, float p_225628_9_, float p_225628_10_) {
        super.m_6494_(p_225628_1_, p_225628_2_, p_225628_3_, p_225628_4_, p_225628_5_, p_225628_6_, p_225628_7_, p_225628_8_, p_225628_9_, p_225628_10_);
        this.renderArmorPiece(p_225628_1_, p_225628_2_, p_225628_4_, EquipmentSlot.CHEST, p_225628_3_, this.crossedArmsArmorModel);
    }

    private void renderArmorPiece(PoseStack p_241739_1_, MultiBufferSource p_241739_2_, T p_241739_3_, EquipmentSlot p_241739_4_, int p_241739_5_, IllagerBipedModel<T> crossedArmsModel) {
        ArmorItem armoritem;
        ItemStack itemstack = p_241739_3_.m_6844_(p_241739_4_);
        if (itemstack.m_41720_() instanceof ArmorItem && (armoritem = (ArmorItem)itemstack.m_41720_()).m_40402_() == p_241739_4_) {
            ((IllagerBipedModel)this.m_117386_()).copyPropertiesTo(crossedArmsModel);
            ResourceLocation crossedTexture = this.getArmorResource((Entity)p_241739_3_, itemstack, p_241739_4_, "crossed");
            boolean armsCanBeCrossed = IllagerArmsUtil.resourceExists(crossedTexture);
            this.setPartVisibilityCrossedArms(crossedArmsModel, p_241739_4_, armsCanBeCrossed);
            if (!armsCanBeCrossed) {
                return;
            }
            boolean flag1 = itemstack.m_41790_();
            if (armoritem instanceof DyeableLeatherItem) {
                int i = ((DyeableLeatherItem)armoritem).m_41121_(itemstack);
                float f = (float)(i >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(i & 0xFF) / 255.0f;
                this.renderModel(p_241739_1_, p_241739_2_, p_241739_5_, flag1, crossedArmsModel, f, f1, f2, crossedTexture);
                this.renderModel(p_241739_1_, p_241739_2_, p_241739_5_, flag1, crossedArmsModel, 1.0f, 1.0f, 1.0f, this.getArmorResource((Entity)p_241739_3_, itemstack, p_241739_4_, "crossed_overlay"));
            } else {
                this.renderModel(p_241739_1_, p_241739_2_, p_241739_5_, flag1, crossedArmsModel, 1.0f, 1.0f, 1.0f, crossedTexture);
            }
        }
    }

    private void renderModel(PoseStack p_241738_1_, MultiBufferSource p_241738_2_, int p_241738_3_, boolean p_241738_5_, IllagerBipedModel<T> p_241738_6_, float p_241738_8_, float p_241738_9_, float p_241738_10_, ResourceLocation armorResource) {
        VertexConsumer ivertexbuilder = ItemRenderer.m_115184_((MultiBufferSource)p_241738_2_, (RenderType)RenderType.m_110431_((ResourceLocation)armorResource), (boolean)false, (boolean)p_241738_5_);
        p_241738_6_.m_7695_(p_241738_1_, ivertexbuilder, p_241738_3_, OverlayTexture.f_118083_, p_241738_8_, p_241738_9_, p_241738_10_, 1.0f);
    }

    protected void m_117125_(A entityModel, EquipmentSlot p_188359_2_) {
        super.m_117125_(entityModel, p_188359_2_);
        if (p_188359_2_ == EquipmentSlot.CHEST) {
            ((HumanoidModel)entityModel).f_102811_.f_104207_ = true;
            ((HumanoidModel)entityModel).f_102812_.f_104207_ = true;
        }
    }

    private void setPartVisibilityCrossedArms(IllagerBipedModel<T> illagerEntityModel, EquipmentSlot p_188359_2_, boolean armsCanBeCrossed) {
        illagerEntityModel.m_8009_(false);
        illagerEntityModel.jacket.f_104207_ = false;
        illagerEntityModel.arms.f_104207_ = false;
        if (p_188359_2_ == EquipmentSlot.CHEST) {
            illagerEntityModel.jacket.f_104207_ = true;
            if (((IllagerBipedModel)this.m_117386_()).arms.f_104207_ && armsCanBeCrossed) {
                illagerEntityModel.arms.f_104207_ = true;
                illagerEntityModel.f_102811_.f_104207_ = false;
                illagerEntityModel.f_102812_.f_104207_ = false;
            } else {
                illagerEntityModel.arms.f_104207_ = false;
                illagerEntityModel.f_102811_.f_104207_ = false;
                illagerEntityModel.f_102812_.f_104207_ = false;
            }
        }
    }
}

