/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.renderer.piglin;

import com.infamous.dungeons_mobs.client.models.FungusSackModel;
import com.infamous.dungeons_mobs.client.models.geom.ModModelLayers;
import com.infamous.dungeons_mobs.client.renderer.layers.FungusSackLayer;
import com.infamous.dungeons_mobs.interfaces.ISmartCrossbowUser;
import com.infamous.dungeons_mobs.mod.ModItems;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.PiglinRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;

public class CustomPiglinRenderer
extends PiglinRenderer {
    public static final Map<EntityType<?>, Map<String, ResourceLocation>> RESOURCE_LOCATION_MAP = new HashMap();

    public CustomPiglinRenderer(EntityRendererProvider.Context rendererContext, ModelLayerLocation p_174345_, ModelLayerLocation p_174346_, ModelLayerLocation p_174347_, boolean isZombified, boolean isFungusThrower) {
        super(rendererContext, p_174345_, p_174346_, p_174347_, isZombified);
        if (isFungusThrower) {
            this.m_115326_(new FungusSackLayer(this, new FungusSackModel(rendererContext.m_174023_(ModModelLayers.FUNGUS_SACK))));
        }
    }

    protected void scale(Mob mobEntity, PoseStack matrixStack, float v) {
        super.m_7546_((LivingEntity)mobEntity, matrixStack, v);
    }

    public ResourceLocation m_5478_(Mob mobEntity) {
        boolean isVanillaMob;
        boolean bl = isVanillaMob = mobEntity.m_6095_() == EntityType.f_20511_ || mobEntity.m_6095_() == EntityType.f_20531_;
        if (isVanillaMob && mobEntity instanceof ISmartCrossbowUser && !((ISmartCrossbowUser)mobEntity).isCrossbowUser()) {
            return super.m_5478_(mobEntity);
        }
        String skinVariantName = this.getSkinVariantName(mobEntity);
        return RESOURCE_LOCATION_MAP.computeIfAbsent(mobEntity.m_6095_(), type -> new HashMap()).computeIfAbsent(skinVariantName, s -> new ResourceLocation("dungeons_mobs", this.getPath(skinVariantName)));
    }

    private String getPath(String skinVariantName) {
        return "textures/entity/piglin/" + skinVariantName + ".png";
    }

    private String getSkinVariantName(Mob mobEntity) {
        String skinVariantName = ForgeRegistries.ENTITY_TYPES.getKey((Object)mobEntity.m_6095_()).m_135815_();
        skinVariantName = this.maybeAddArmorPrefix(mobEntity, skinVariantName);
        skinVariantName = this.maybeAddHunterSuffix(mobEntity, skinVariantName);
        return skinVariantName;
    }

    private String maybeAddArmorPrefix(Mob mobEntity, String in) {
        Item helmetItem = mobEntity.m_6844_(EquipmentSlot.HEAD).m_41720_();
        if (helmetItem.equals(ModItems.GOLD_PIGLIN_HELMET.get()) || helmetItem.equals(ModItems.CRACKED_GOLD_PIGLIN_HELMET.get())) {
            return "gold_armored_" + in;
        }
        if (helmetItem.equals(ModItems.NETHERITE_PIGLIN_HELMET.get()) || helmetItem.equals(ModItems.CRACKED_NETHERITE_PIGLIN_HELMET.get())) {
            return "netherite_armored_" + in;
        }
        return in;
    }

    private String maybeAddHunterSuffix(Mob mobEntity, String in) {
        if (mobEntity instanceof ISmartCrossbowUser && ((ISmartCrossbowUser)mobEntity).isCrossbowUser()) {
            return in + "_hunter";
        }
        return in;
    }
}

