/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.renderer.undead;

import com.infamous.dungeons_mobs.client.models.undead.SkeletonVanguardModel;
import com.infamous.dungeons_mobs.entities.undead.SkeletonVanguardEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.item.GeoArmorItem;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.ExtendedGeoEntityRenderer;
import software.bernie.geckolib3.renderers.geo.GeoArmorRenderer;

public class SkeletonVanguardRenderer
extends ExtendedGeoEntityRenderer<SkeletonVanguardEntity> {
    public SkeletonVanguardRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (AnimatedGeoModel)new SkeletonVanguardModel());
    }

    protected void applyRotations(SkeletonVanguardEntity entityLiving, PoseStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        float scaleFactor = 1.0f;
        matrixStackIn.m_85841_(scaleFactor, scaleFactor, scaleFactor);
        super.applyRotations((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
    }

    public RenderType getRenderType(SkeletonVanguardEntity animatable, float partialTicks, PoseStack stack, MultiBufferSource renderTypeBuffer, VertexConsumer vertexBuilder, int packedLightIn, ResourceLocation textureLocation) {
        return RenderType.m_110473_((ResourceLocation)this.getTextureLocation((LivingEntity)animatable));
    }

    public void renderRecursively(GeoBone bone, PoseStack stack, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.isArmorBone(bone)) {
            bone.setCubesHidden(true);
        }
        super.renderRecursively(bone, stack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    protected boolean isArmorBone(GeoBone bone) {
        return bone.getName().startsWith("armor");
    }

    @Nullable
    protected ResourceLocation getTextureForBone(String s, SkeletonVanguardEntity windcallerEntity) {
        return null;
    }

    protected ItemStack getHeldItemForBone(String boneName, SkeletonVanguardEntity currentEntity) {
        switch (boneName) {
            case "bipedHandLeft": {
                return currentEntity.m_21526_() ? this.mainHand : this.offHand;
            }
            case "bipedHandRight": {
                return currentEntity.m_21526_() ? this.offHand : this.mainHand;
            }
        }
        return null;
    }

    protected ItemTransforms.TransformType getCameraTransformForItemAtBone(ItemStack boneItem, String boneName) {
        switch (boneName) {
            case "bipedHandLeft": {
                return ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND;
            }
            case "bipedHandRight": {
                return ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND;
            }
        }
        return ItemTransforms.TransformType.NONE;
    }

    protected void preRenderItem(PoseStack stack, ItemStack item, String boneName, SkeletonVanguardEntity currentEntity, IBone bone) {
        if (item == this.mainHand) {
            stack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
            if (item.m_41720_() instanceof ShieldItem) {
                stack.m_85837_(0.0, 0.125, -0.25);
            }
        } else if (item == this.offHand) {
            stack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
            if (item.m_41720_() instanceof ShieldItem) {
                stack.m_85837_(0.0, 0.125, 0.25);
                stack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
            }
        }
    }

    protected void postRenderItem(PoseStack matrixStack, ItemStack item, String boneName, SkeletonVanguardEntity currentEntity, IBone bone) {
    }

    protected BlockState getHeldBlockForBone(String boneName, SkeletonVanguardEntity currentEntity) {
        return null;
    }

    protected void preRenderBlock(PoseStack matrixStack, BlockState block, String boneName, SkeletonVanguardEntity currentEntity) {
    }

    protected void postRenderBlock(PoseStack matrixStack, BlockState block, String boneName, SkeletonVanguardEntity currentEntity) {
    }

    @Nullable
    protected ItemStack getArmorForBone(String boneName, SkeletonVanguardEntity currentEntity) {
        return switch (boneName) {
            case "armorBipedLeftFoot", "armorBipedRightFoot" -> currentEntity.m_6844_(EquipmentSlot.FEET);
            case "armorBipedLeftLeg", "armorBipedRightLeg" -> currentEntity.m_6844_(EquipmentSlot.LEGS);
            case "armorBipedBody", "armorBipedRightArm", "armorBipedLeftArm" -> currentEntity.m_6844_(EquipmentSlot.CHEST);
            case "armorBipedHead" -> currentEntity.m_6844_(EquipmentSlot.HEAD);
            default -> null;
        };
    }

    protected EquipmentSlot getEquipmentSlotForArmorBone(String boneName, SkeletonVanguardEntity currentEntity) {
        return switch (boneName) {
            case "armorBipedLeftFoot", "armorBipedRightFoot" -> EquipmentSlot.FEET;
            case "armorBipedLeftLeg", "armorBipedRightLeg" -> EquipmentSlot.LEGS;
            case "armorBipedRightHand" -> {
                if (!currentEntity.m_21526_()) {
                    yield EquipmentSlot.MAINHAND;
                }
                yield EquipmentSlot.OFFHAND;
            }
            case "armorBipedLeftHand" -> {
                if (currentEntity.m_21526_()) {
                    yield EquipmentSlot.MAINHAND;
                }
                yield EquipmentSlot.OFFHAND;
            }
            case "armorBipedRightArm", "armorBipedLeftArm", "armorBipedBody" -> EquipmentSlot.CHEST;
            case "armorBipedHead" -> EquipmentSlot.HEAD;
            default -> null;
        };
    }

    protected ModelPart getArmorPartForBone(String name, HumanoidModel<?> armorBipedModel) {
        return switch (name) {
            case "armorBipedLeftFoot", "armorBipedLeftLeg" -> armorBipedModel.f_102814_;
            case "armorBipedRightFoot", "armorBipedRightLeg" -> armorBipedModel.f_102813_;
            case "armorBipedRightArm" -> armorBipedModel.f_102811_;
            case "armorBipedLeftArm" -> armorBipedModel.f_102812_;
            case "armorBipedBody" -> armorBipedModel.f_102810_;
            case "armorBipedHead" -> armorBipedModel.f_102808_;
            default -> null;
        };
    }

    protected void setLimbBoneVisible(GeoArmorRenderer<? extends GeoArmorItem> armorRenderer, ModelPart limb, HumanoidModel<?> armorModel, EquipmentSlot slot) {
        if (limb == armorModel.f_102808_ || limb == armorModel.f_102809_) {
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.headBone).setHidden(false);
        } else if (limb == armorModel.f_102810_) {
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.bodyBone).setHidden(false);
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.leftArmBone).setHidden(true);
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.rightArmBone).setHidden(true);
        } else if (limb == armorModel.f_102812_) {
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.bodyBone).setHidden(true);
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.leftArmBone).setHidden(false);
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.rightArmBone).setHidden(true);
        } else if (limb == armorModel.f_102814_) {
            armorRenderer.getGeoModelProvider().getBone(slot == EquipmentSlot.FEET ? armorRenderer.leftBootBone : armorRenderer.leftLegBone).setHidden(false);
            armorRenderer.getGeoModelProvider().getBone(slot == EquipmentSlot.FEET ? armorRenderer.leftLegBone : armorRenderer.leftBootBone).setHidden(true);
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.rightBootBone).setHidden(true);
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.rightLegBone).setHidden(true);
        } else if (limb == armorModel.f_102811_) {
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.bodyBone).setHidden(true);
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.leftArmBone).setHidden(true);
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.rightArmBone).setHidden(false);
        } else if (limb == armorModel.f_102813_) {
            armorRenderer.getGeoModelProvider().getBone(slot == EquipmentSlot.FEET ? armorRenderer.rightBootBone : armorRenderer.rightLegBone).setHidden(false);
            armorRenderer.getGeoModelProvider().getBone(slot == EquipmentSlot.FEET ? armorRenderer.rightLegBone : armorRenderer.rightBootBone).setHidden(true);
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.leftBootBone).setHidden(true);
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.leftLegBone).setHidden(true);
        }
    }
}

