/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.data;

import baguchan.enchantwithmob.EnchantWithMob;
import baguchan.enchantwithmob.capability.MobEnchantCapability;
import baguchan.enchantwithmob.registry.MobEnchants;
import com.infamous.dungeons_libraries.data.util.MergeableCodecDataManager;
import com.infamous.dungeons_mobs.data.MobAncientData;
import com.infamous.dungeons_mobs.data.MobEnchantmentAncientData;
import com.infamous.dungeons_mobs.data.UniqueAncientData;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="dungeons_mobs", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AncientDataHelper {
    public static final MergeableCodecDataManager<MobAncientData, MobAncientData> MOB_ANCIENT_DATA = new MergeableCodecDataManager("ancient/mob_ancient_data", MobAncientData.CODEC, AncientDataHelper::mobMerger);
    public static final MergeableCodecDataManager<MobEnchantmentAncientData, MobEnchantmentAncientData> MOB_ENCHANTMENT_ANCIENT_DATA = new MergeableCodecDataManager("ancient/mob_enchantment_ancient_data", MobEnchantmentAncientData.CODEC, AncientDataHelper::mobEnchantmentMerger);

    public static MobAncientData mobMerger(List<MobAncientData> raws) {
        ObjectArrayList adjectives = new ObjectArrayList();
        ObjectArrayList nouns = new ObjectArrayList();
        ObjectArrayList minions = new ObjectArrayList();
        ObjectArrayList uniques = new ObjectArrayList();
        raws.forEach(arg_0 -> AncientDataHelper.lambda$mobMerger$0((List)adjectives, (List)nouns, (List)minions, (List)uniques, arg_0));
        return new MobAncientData((List<String>)adjectives, (List<String>)nouns, (List<ResourceLocation>)minions, (List<UniqueAncientData>)uniques);
    }

    public static MobEnchantmentAncientData mobEnchantmentMerger(List<MobEnchantmentAncientData> raws) {
        ObjectArrayList adjectives = new ObjectArrayList();
        ObjectArrayList nouns = new ObjectArrayList();
        raws.forEach(arg_0 -> AncientDataHelper.lambda$mobEnchantmentMerger$1((List)adjectives, (List)nouns, arg_0));
        return new MobEnchantmentAncientData((List<String>)adjectives, (List<String>)nouns);
    }

    public static MobAncientData getMobAncientData(ResourceLocation mobResourceLocation) {
        return MOB_ANCIENT_DATA.getData().getOrDefault(mobResourceLocation, MobAncientData.DEFAULT);
    }

    public static MobEnchantmentAncientData getMobEnchantmentAncientData(ResourceLocation mobEnchantmentResourceLocation) {
        return MOB_ENCHANTMENT_ANCIENT_DATA.getData().getOrDefault(mobEnchantmentResourceLocation, MobEnchantmentAncientData.DEFAULT);
    }

    public static String getAncientName(LivingEntity entity) {
        HashSet<String> adjectives = new HashSet<String>();
        HashSet<String> nouns = new HashSet<String>();
        MobEnchantCapability enchantCap = (MobEnchantCapability)entity.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).orElse((Object)new MobEnchantCapability());
        enchantCap.getMobEnchants().forEach(mobEnchantment -> {
            MobEnchantmentAncientData mobEnchantmentAncientData = AncientDataHelper.getMobEnchantmentAncientData(MobEnchants.MOB_ENCHANT_REGISTRY.getKey((Object)mobEnchantment.getMobEnchant()));
            adjectives.addAll(mobEnchantmentAncientData.getAdjectives());
            nouns.addAll(mobEnchantmentAncientData.getNouns());
        });
        MobAncientData mobAncientData = AncientDataHelper.getMobAncientData(ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()));
        adjectives.addAll(mobAncientData.getAdjectives());
        nouns.addAll(mobAncientData.getNouns());
        return (String)new ObjectArrayList(adjectives).get(entity.m_217043_().m_188503_(adjectives.size())) + " " + (String)new ObjectArrayList(nouns).get(entity.m_217043_().m_188503_(nouns.size()));
    }

    @SubscribeEvent
    public static void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener(MOB_ANCIENT_DATA);
    }

    private static /* synthetic */ void lambda$mobEnchantmentMerger$1(List adjectives, List nouns, MobEnchantmentAncientData raw) {
        adjectives.addAll(raw.getAdjectives());
        nouns.addAll(raw.getNouns());
    }

    private static /* synthetic */ void lambda$mobMerger$0(List adjectives, List nouns, List minions, List uniques, MobAncientData raw) {
        adjectives.addAll(raw.getAdjectives());
        nouns.addAll(raw.getNouns());
        minions.addAll(raw.getMinions());
        uniques.addAll(raw.getUniques());
    }
}

