/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities;

import com.infamous.dungeons_mobs.config.DungeonsMobsConfig;
import com.infamous.dungeons_mobs.mod.ModEffects;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_mobs")
public class EntityEvents {
    @SubscribeEvent
    public static void changeAttributes(EntityJoinLevelEvent event) {
        Entity entity;
        if (event.getEntity().m_6095_().equals(EntityType.f_20458_) && (entity = event.getEntity()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (((Boolean)DungeonsMobsConfig.COMMON.ENABLE_STRONGER_HUSKS.get()).booleanValue()) {
                AttributeInstance attribute = livingEntity.m_21051_(Attributes.f_22284_);
                if (attribute != null) {
                    attribute.m_22100_(10.0);
                }
                if ((attribute = livingEntity.m_21051_(Attributes.f_22279_)) != null) {
                    attribute.m_22100_(0.17);
                }
                if ((attribute = livingEntity.m_21051_(Attributes.f_22278_)) != null) {
                    attribute.m_22100_(0.6);
                }
            }
        }
    }

    @SubscribeEvent
    public static void preventKnockback(LivingKnockBackEvent event) {
        LivingEntity owner = event.getEntity();
        if (owner.m_21023_((MobEffect)ModEffects.ENSNARED.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void preventBlockBreaking(BlockEvent.BreakEvent event) {
        Player owner = event.getPlayer();
        if (owner.m_21023_((MobEffect)ModEffects.ENSNARED.get()) && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void preventBlockPlacement(BlockEvent.EntityPlaceEvent event) {
        Entity owner = event.getEntity();
        if (owner instanceof LivingEntity && ((LivingEntity)owner).m_21023_((MobEffect)ModEffects.ENSNARED.get()) && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void preventBlockInteraction(BlockEvent.BlockToolModificationEvent event) {
        Player owner = event.getPlayer();
        if (owner.m_21023_((MobEffect)ModEffects.ENSNARED.get()) && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void preventItemUseCustom(LivingEntityUseItemEvent event) {
        LivingEntity owner = event.getEntity();
        if (owner.m_21023_((MobEffect)ModEffects.ENSNARED.get()) && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void preventEntityAttack(AttackEntityEvent event) {
        Player owner = event.getEntity();
        if (owner.m_21023_((MobEffect)ModEffects.ENSNARED.get()) && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void preventBucketFill(FillBucketEvent event) {
        Player owner = event.getEntity();
        if (owner.m_21023_((MobEffect)ModEffects.ENSNARED.get()) && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void preventEmptyInteraction(PlayerInteractEvent.RightClickEmpty event) {
        Player owner = event.getEntity();
        if (owner.m_21023_((MobEffect)ModEffects.ENSNARED.get()) && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void preventEmptyInteraction(PlayerInteractEvent.LeftClickEmpty event) {
        Player owner = event.getEntity();
        if (owner.m_21023_((MobEffect)ModEffects.ENSNARED.get()) && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void preventItemUse(PlayerInteractEvent.RightClickItem event) {
        Player owner = event.getEntity();
        if (owner.m_21023_((MobEffect)ModEffects.ENSNARED.get()) && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void preventBlockInteraction(PlayerInteractEvent.RightClickBlock event) {
        Player owner = event.getEntity();
        if (owner.m_21023_((MobEffect)ModEffects.ENSNARED.get()) && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void preventBlockInteraction(PlayerInteractEvent.LeftClickBlock event) {
        Player owner = event.getEntity();
        if (owner.m_21023_((MobEffect)ModEffects.ENSNARED.get()) && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void addEndermanSpawns(LevelEvent.PotentialSpawns event) {
        int reduce;
        Level level;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level && (level = (Level)levelAccessor).m_204156_().m_203565_(BuiltinDimensionTypes.f_223540_) && (reduce = event.getSpawnerDataList().stream().filter(spawnerData -> spawnerData.f_48404_.equals(EntityType.f_20566_)).map(spawnerData -> spawnerData.m_142631_().m_146281_()).reduce(Integer::sum).orElse(100).intValue()) < 100) {
            event.addSpawnerData(new MobSpawnSettings.SpawnerData(EntityType.f_20566_, 100 - reduce, 4, 4));
        }
    }
}

