/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.creepers;

import com.infamous.dungeons_mobs.client.particle.ModParticleTypes;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.event.ForgeEventFactory;

public class IcyCreeperEntity
extends Creeper {
    private int oldSwell;
    private int swell;
    private final int maxSwell = 30;
    private final int explosionRadius = 3;

    public IcyCreeperEntity(Level worldIn) {
        super((EntityType)ModEntityTypes.ICY_CREEPER.get(), worldIn);
    }

    public static boolean canIcyCreeperSpawn(EntityType<IcyCreeperEntity> entityType, ServerLevelAccessor iWorld, MobSpawnType spawnReason, BlockPos blockPos, RandomSource rand) {
        return IcyCreeperEntity.m_219013_(entityType, (ServerLevelAccessor)iWorld, (MobSpawnType)spawnReason, (BlockPos)blockPos, (RandomSource)rand) && (spawnReason == MobSpawnType.SPAWNER || iWorld.m_45527_(blockPos));
    }

    public void m_8107_() {
        if (this.f_19853_.f_46443_) {
            this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.SNOWFLAKE.get(), this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
        }
        super.m_8107_();
    }

    public IcyCreeperEntity(EntityType<? extends Creeper> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Creeper.m_32318_();
    }

    public void m_8119_() {
        if (this.m_6084_()) {
            int i;
            this.oldSwell = this.swell;
            if (this.m_32311_()) {
                this.m_32283_(1);
            }
            if ((i = this.m_32310_()) > 0 && this.swell == 0) {
                this.m_5496_(SoundEvents.f_11837_, 1.0f, 0.25f);
            }
            this.swell += i;
            if (this.swell < 0) {
                this.swell = 0;
            }
            if (this.swell >= this.maxSwell) {
                this.swell = this.maxSwell;
                this.explodeCreeper();
            }
        }
        super.m_8119_();
    }

    private void explodeCreeper() {
        double d2;
        double d1;
        int i;
        if (!this.f_19853_.f_46443_) {
            Explosion.BlockInteraction explosion$mode = ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this) ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE;
            float f = this.m_7090_() ? 2.0f : 1.0f;
            this.f_20890_ = true;
            double d = this.m_20185_();
            double d3 = this.m_20186_();
            double d4 = this.m_20189_();
            Objects.requireNonNull(this);
            this.f_19853_.m_46511_((Entity)this, d, d3, d4, 3.0f * f, explosion$mode);
            this.m_5496_((SoundEvent)ModSoundEvents.ICY_CREEPER_EXPLODE.get(), 2.0f, 1.0f);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            this.spawnLingeringCloud();
        }
        for (i = 0; i < 75; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.3;
            d1 = this.f_19796_.m_188583_() * 0.2;
            d2 = this.f_19796_.m_188583_() * 0.3;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_(), this.m_20189_(), d0, d1, d2);
        }
        for (i = 0; i < 50; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.6;
            d1 = this.f_19796_.m_188583_() * 0.3;
            d2 = this.f_19796_.m_188583_() * 0.6;
            this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.SNOWFLAKE.get(), this.m_20185_(), this.m_20186_(), this.m_20189_(), d0, d1, d2);
        }
    }

    private void spawnLingeringCloud() {
        Collection collection = this.m_21220_();
        if (!collection.isEmpty()) {
            AreaEffectCloud areaeffectcloudentity = new AreaEffectCloud(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
            areaeffectcloudentity.m_19712_(2.5f);
            areaeffectcloudentity.m_19732_(-0.5f);
            areaeffectcloudentity.m_19740_(10);
            areaeffectcloudentity.m_19734_(areaeffectcloudentity.m_19748_() / 2);
            areaeffectcloudentity.m_19738_(-areaeffectcloudentity.m_19743_() / (float)areaeffectcloudentity.m_19748_());
            for (MobEffectInstance effectinstance : collection) {
                areaeffectcloudentity.m_19716_(new MobEffectInstance(effectinstance));
            }
            this.f_19853_.m_7967_((Entity)areaeffectcloudentity);
        }
    }
}

