/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.ender;

import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import software.bernie.geckolib3.core.IAnimatable;

public abstract class AbstractEnderlingEntity
extends Monster
implements IAnimatable {
    public static final EntityDataAccessor<Integer> ATTACKING = SynchedEntityData.m_135353_(AbstractEnderlingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> RUNNING = SynchedEntityData.m_135353_(AbstractEnderlingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_STARED_AT = SynchedEntityData.m_135353_(AbstractEnderlingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final TargetingConditions followPredicate = TargetingConditions.m_148352_().m_26883_(50.0).m_26893_();

    protected AbstractEnderlingEntity(EntityType<? extends AbstractEnderlingEntity> p_i48553_1_, Level p_i48553_2_) {
        super(p_i48553_1_, p_i48553_2_);
        this.f_19793_ = 1.0f;
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 7.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    public void m_6710_(@Nullable LivingEntity p_70624_1_) {
        if (p_70624_1_ == null) {
            this.f_19804_.m_135381_(DATA_STARED_AT, (Object)false);
        }
        super.m_6710_(p_70624_1_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)0);
        this.f_19804_.m_135372_(RUNNING, (Object)0);
        this.f_19804_.m_135372_(DATA_STARED_AT, (Object)false);
    }

    public boolean hasBeenStaredAt() {
        return (Boolean)this.f_19804_.m_135370_(DATA_STARED_AT);
    }

    public void setBeingStaredAt() {
        this.f_19804_.m_135381_(DATA_STARED_AT, (Object)true);
    }

    private boolean isLookingAtMe(Player p_70821_1_) {
        ItemStack itemstack = (ItemStack)p_70821_1_.m_150109_().f_35975_.get(3);
        if (itemstack.m_41720_() == Blocks.f_50143_.m_5456_()) {
            return false;
        }
        Vec3 vector3d = p_70821_1_.m_20252_(1.0f).m_82541_();
        Vec3 vector3d1 = new Vec3(this.m_20185_() - p_70821_1_.m_20185_(), this.m_20188_() - p_70821_1_.m_20188_(), this.m_20189_() - p_70821_1_.m_20189_());
        double d0 = vector3d1.m_82553_();
        double d1 = vector3d.m_82526_(vector3d1 = vector3d1.m_82541_());
        return d1 > 1.0 - 0.025 / d0 && p_70821_1_.m_142582_((Entity)this);
    }

    public boolean m_5545_(LevelAccessor p_213380_1_, MobSpawnType p_213380_2_) {
        return (p_213380_2_ != MobSpawnType.NATURAL || !this.f_19853_.m_204166_(this.m_20183_()).m_203565_(Biomes.f_48210_)) && AbstractEnderlingEntity.m_217057_((EntityType)this.m_6095_(), (LevelAccessor)p_213380_1_, (MobSpawnType)p_213380_2_, (BlockPos)this.m_20183_(), (RandomSource)this.f_19796_);
    }

    public void m_6075_() {
        super.m_6075_();
        if (this.isAttacking() > 0) {
            this.setAttacking(this.isAttacking() - 1);
        }
        if (this.isRunning() > 0) {
            this.setRunning(this.isRunning() - 1);
        }
    }

    public int isAttacking() {
        return (Integer)this.f_19804_.m_135370_(ATTACKING);
    }

    public void setAttacking(int p_189794_1_) {
        this.f_19804_.m_135381_(ATTACKING, (Object)p_189794_1_);
    }

    public int isRunning() {
        return (Integer)this.f_19804_.m_135370_(RUNNING);
    }

    public void setRunning(int p_189794_1_) {
        this.f_19804_.m_135381_(RUNNING, (Object)p_189794_1_);
    }

    public void m_8107_() {
        if (this.f_19853_.f_46443_) {
            for (int i = 0; i < 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
            }
        }
        this.f_20899_ = false;
        super.m_8107_();
    }

    public boolean m_6126_() {
        return true;
    }

    protected void m_8024_() {
        float f;
        if (this.shouldTeleportInDay() && this.f_19853_.m_46461_() && this.f_19796_.m_188503_(600) == 0 && (f = this.m_213856_()) > 0.5f && this.f_19853_.m_45527_(this.m_20183_()) && this.f_19796_.m_188501_() * 30.0f < (f - 0.4f) * 2.0f) {
            this.m_6710_(null);
            this.teleport();
        }
        super.m_8024_();
    }

    public boolean shouldTeleportInDay() {
        return false;
    }

    protected boolean teleport() {
        if (!this.f_19853_.m_5776_() && this.m_6084_()) {
            double d0 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
            double d1 = this.m_20186_() + (double)(this.f_19796_.m_188503_(64) - 32);
            double d2 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
            return this.teleport(d0, d1, d2);
        }
        return false;
    }

    private boolean teleportTowards(Entity p_70816_1_) {
        Vec3 vector3d = new Vec3(this.m_20185_() - p_70816_1_.m_20185_(), this.m_20227_(0.5) - p_70816_1_.m_20188_(), this.m_20189_() - p_70816_1_.m_20189_());
        vector3d = vector3d.m_82541_();
        double d0 = 16.0;
        double d1 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vector3d.f_82479_ * 16.0;
        double d2 = this.m_20186_() + (double)(this.f_19796_.m_188503_(16) - 8) - vector3d.f_82480_ * 16.0;
        double d3 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vector3d.f_82481_ * 16.0;
        return this.teleport(d1, d2, d3);
    }

    protected boolean teleport(double p_70825_1_, double p_70825_3_, double p_70825_5_) {
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos(p_70825_1_, p_70825_3_, p_70825_5_);
        while (blockpos$mutable.m_123342_() > 0 && !this.f_19853_.m_8055_((BlockPos)blockpos$mutable).m_60767_().m_76334_()) {
            blockpos$mutable.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = this.f_19853_.m_8055_((BlockPos)blockpos$mutable);
        boolean flag = blockstate.m_60767_().m_76334_();
        boolean flag1 = blockstate.m_60819_().m_205070_(FluidTags.f_13131_);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)p_70825_1_, (double)p_70825_3_, (double)p_70825_5_);
            if (event.isCanceled()) {
                return false;
            }
            boolean flag2 = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (!this.m_20067_()) {
                this.f_19853_.m_6263_(null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
                this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            }
            return flag2;
        }
        return false;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11899_;
    }

    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return SoundEvents.f_11849_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11900_;
    }

    public boolean m_6469_(DamageSource p_70097_1_, float p_70097_2_) {
        if (this.m_6673_(p_70097_1_)) {
            return false;
        }
        boolean flag = super.m_6469_(p_70097_1_, p_70097_2_);
        if (!this.f_19853_.m_5776_() && !(p_70097_1_.m_7639_() instanceof LivingEntity) && this.f_19796_.m_188503_(2) == 0) {
            this.teleport();
        }
        return flag;
    }

    static class FindPlayerGoal
    extends NearestAttackableTargetGoal<Player> {
        private final AbstractEnderlingEntity enderman;
        private Player pendingTarget;
        private int aggroTime;
        private int teleportTime;
        private final TargetingConditions startAggroTargetConditions;
        private final TargetingConditions continueAggroTargetConditions = TargetingConditions.m_148352_();

        public FindPlayerGoal(AbstractEnderlingEntity p_i241912_1_, @Nullable Predicate<LivingEntity> p_i241912_2_) {
            super((Mob)p_i241912_1_, Player.class, 10, false, false, p_i241912_2_);
            this.enderman = p_i241912_1_;
            this.startAggroTargetConditions = TargetingConditions.m_148352_().m_26883_(this.m_7623_()).m_26888_(p_220790_1_ -> p_i241912_1_.isLookingAtMe((Player)p_220790_1_));
        }

        public boolean m_8036_() {
            this.pendingTarget = this.enderman.f_19853_.m_45946_(this.startAggroTargetConditions, (LivingEntity)this.enderman);
            return this.pendingTarget != null;
        }

        public void m_8056_() {
            this.aggroTime = 5;
            this.teleportTime = 0;
            this.enderman.setBeingStaredAt();
        }

        public void m_8041_() {
            this.pendingTarget = null;
            super.m_8041_();
        }

        public boolean m_8045_() {
            if (this.pendingTarget != null) {
                if (!this.enderman.isLookingAtMe(this.pendingTarget)) {
                    return false;
                }
                this.enderman.m_21391_((Entity)this.pendingTarget, 10.0f, 10.0f);
                return true;
            }
            return this.f_26050_ != null && this.continueAggroTargetConditions.m_26885_((LivingEntity)this.enderman, this.f_26050_) || super.m_8045_();
        }

        public void m_8037_() {
            if (this.enderman.m_5448_() == null) {
                super.m_26070_(null);
            }
            if (this.pendingTarget != null) {
                if (--this.aggroTime <= 0) {
                    this.f_26050_ = this.pendingTarget;
                    this.pendingTarget = null;
                    super.m_8056_();
                }
            } else {
                if (this.f_26050_ != null && !this.enderman.m_20159_()) {
                    if (this.enderman.isLookingAtMe((Player)this.f_26050_)) {
                        if (this.f_26050_.m_20280_((Entity)this.enderman) < 16.0) {
                            this.enderman.teleport();
                        }
                        this.teleportTime = 0;
                    } else if (this.f_26050_.m_20280_((Entity)this.enderman) > 256.0 && this.teleportTime++ >= 30 && this.enderman.teleportTowards((Entity)this.f_26050_)) {
                        this.teleportTime = 0;
                    }
                }
                super.m_8037_();
            }
        }
    }

    public class EnderlingTargetGoal<T extends LivingEntity>
    extends TargetGoal {
        protected final Class<T> targetType;
        protected final int randomInterval;
        protected LivingEntity target;
        protected TargetingConditions targetConditions;

        public EnderlingTargetGoal(Mob p_i50313_1_, Class<T> p_i50313_2_, boolean p_i50313_3_) {
            this(p_i50313_1_, p_i50313_2_, p_i50313_3_, false);
        }

        public EnderlingTargetGoal(Mob p_i50314_1_, Class<T> p_i50314_2_, boolean p_i50314_3_, boolean p_i50314_4_) {
            this(p_i50314_1_, p_i50314_2_, 10, p_i50314_3_, p_i50314_4_, null);
        }

        public EnderlingTargetGoal(Mob p_i50315_1_, Class<T> p_i50315_2_, int p_i50315_3_, boolean p_i50315_4_, @Nullable boolean p_i50315_5_, Predicate<LivingEntity> p_i50315_6_) {
            super(p_i50315_1_, p_i50315_4_, p_i50315_5_);
            this.targetType = p_i50315_2_;
            this.randomInterval = p_i50315_3_;
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
            this.targetConditions = TargetingConditions.m_148352_().m_26883_(this.m_7623_()).m_26888_(p_i50315_6_);
        }

        public boolean m_8036_() {
            if (this.randomInterval > 0 && this.f_26135_.m_217043_().m_188503_(this.randomInterval) != 0) {
                return false;
            }
            this.findTarget();
            return this.target != null;
        }

        protected AABB getTargetSearchArea(double p_188511_1_) {
            return this.f_26135_.m_20191_().m_82377_(p_188511_1_, 4.0, p_188511_1_);
        }

        protected void findTarget() {
            this.target = this.targetType != Player.class && this.targetType != ServerPlayer.class ? this.f_26135_.f_19853_.m_45963_(this.targetType, this.targetConditions, (LivingEntity)this.f_26135_, this.f_26135_.m_20185_(), this.f_26135_.m_20188_(), this.f_26135_.m_20189_(), this.getTargetSearchArea(this.m_7623_())) : this.f_26135_.f_19853_.m_45949_(this.targetConditions, (LivingEntity)this.f_26135_, this.f_26135_.m_20185_(), this.f_26135_.m_20188_(), this.f_26135_.m_20189_());
        }

        public void m_8056_() {
            this.f_26135_.m_6710_(this.target);
            super.m_8056_();
        }

        public void setTarget(@Nullable LivingEntity p_234054_1_) {
            this.target = p_234054_1_;
        }
    }

    class AttackGoal
    extends MeleeAttackGoal {
        public final TargetingConditions slimePredicate;

        public AttackGoal(double speed) {
            super((PathfinderMob)AbstractEnderlingEntity.this, speed, true);
            this.slimePredicate = TargetingConditions.m_148352_().m_26883_(20.0).m_26893_();
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }

        protected double m_6639_(LivingEntity p_179512_1_) {
            return this.f_25540_.m_20205_() * 3.0f * this.f_25540_.m_20205_() * 3.0f + p_179512_1_.m_20205_();
        }

        public void m_8037_() {
            super.m_8037_();
            AbstractEnderlingEntity.this.setRunning(10);
        }

        protected void m_6739_(LivingEntity p_190102_1_, double p_190102_2_) {
            double d0 = this.m_6639_(p_190102_1_);
            if (p_190102_2_ <= d0 && this.m_25564_()) {
                this.m_25563_();
                this.f_25540_.m_7327_((Entity)p_190102_1_);
            } else if (p_190102_2_ <= d0 * 1.5) {
                if (this.m_25564_()) {
                    this.m_25563_();
                }
                if (this.m_25565_() <= 30) {
                    AbstractEnderlingEntity.this.setAttacking(30);
                }
            } else {
                this.m_25563_();
            }
        }
    }
}

