/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.ender;

import com.infamous.dungeons_mobs.entities.ender.AbstractEnderlingEntity;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class EndersentEntity
extends AbstractEnderlingEntity
implements IAnimatable {
    public static final EntityDataAccessor<Integer> TELEPORTING = SynchedEntityData.m_135353_(EndersentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS).m_7006_(true).m_7005_(true);
    AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public EndersentEntity(EntityType<? extends EndersentEntity> p_i50210_1_, Level p_i50210_2_) {
        super(p_i50210_1_, p_i50210_2_);
        this.f_21364_ = 50;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22278_, 0.85).m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22281_, 14.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new AttackGoal(1.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{AbstractEnderlingEntity.class}).m_26044_(new Class[0]).m_26146_(500));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(500));
        this.f_21346_.m_25352_(1, (Goal)new AbstractEnderlingEntity.FindPlayerGoal(this, null));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TELEPORTING, (Object)0);
    }

    public int isTeleporting() {
        return (Integer)this.f_19804_.m_135370_(TELEPORTING);
    }

    public void setTeleporting(int p_189794_1_) {
        if (p_189794_1_ == 15) {
            if (this.m_5448_() != null) {
                this.m_6034_(this.m_5448_().m_20185_() - 5.0 + (double)this.f_19796_.m_188503_(10), this.m_5448_().m_20186_(), this.m_5448_().m_20189_() - 5.0 + (double)this.f_19796_.m_188503_(10));
                this.f_19853_.m_6263_(null, this.f_19854_, this.f_19855_, this.f_19856_, (SoundEvent)ModSoundEvents.ENDERSENT_TELEPORT.get(), this.m_5720_(), 1.0f, 1.0f);
                this.m_5496_((SoundEvent)ModSoundEvents.ENDERSENT_TELEPORT.get(), 1.0f, 1.0f);
            } else {
                this.m_6034_(this.m_20185_() - 20.0 + (double)this.f_19796_.m_188503_(40), this.m_20186_(), this.m_20189_() - 20.0 + (double)this.f_19796_.m_188503_(40));
                this.f_19853_.m_6263_(null, this.f_19854_, this.f_19855_, this.f_19856_, (SoundEvent)ModSoundEvents.ENDERSENT_TELEPORT.get(), this.m_5720_(), 1.0f, 1.0f);
                this.m_5496_((SoundEvent)ModSoundEvents.ENDERSENT_TELEPORT.get(), 1.0f, 1.0f);
            }
        }
        this.f_19804_.m_135381_(TELEPORTING, (Object)p_189794_1_);
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 100) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            for (int i = 0; i < 20; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), d0, d1, d2);
            }
        }
    }

    public void m_7378_(CompoundTag p_70037_1_) {
        super.m_7378_(p_70037_1_);
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
    }

    public void m_6593_(@Nullable Component p_200203_1_) {
        super.m_6593_(p_200203_1_);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    @Override
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.ENDERSENT_IDLE.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return (SoundEvent)ModSoundEvents.ENDERSENT_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.ENDERSENT_DEATH.get();
    }

    public boolean m_7327_(Entity p_70652_1_) {
        this.m_5496_((SoundEvent)ModSoundEvents.ENDERSENT_ATTACK.get(), 1.0f, 1.0f);
        return super.m_7327_(p_70652_1_);
    }

    protected void m_7355_(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.m_5496_(this.getStepSound(), 1.25f, 1.0f);
    }

    protected float m_6121_() {
        return 2.0f;
    }

    protected SoundEvent getStepSound() {
        return (SoundEvent)ModSoundEvents.ENDERSENT_STEP.get();
    }

    @Override
    public void m_6710_(LivingEntity p_70624_1_) {
        super.m_6710_(p_70624_1_);
    }

    @Override
    public void m_6075_() {
        super.m_6075_();
        if (this.isTeleporting() > 0) {
            this.setTeleporting(this.isTeleporting() - 1);
        }
        if (this.f_19796_.m_188503_(500) == 0 && this.m_5448_() == null) {
            this.setTeleporting(50);
        } else if (this.f_19796_.m_188503_(200) == 0 && this.m_5448_() != null) {
            this.setTeleporting(50);
        }
        if (this.isTeleporting() > 0) {
            this.m_21051_(Attributes.f_22279_).m_22100_(0.0);
        } else {
            this.m_21051_(Attributes.f_22279_).m_22100_((double)0.2f);
        }
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public void m_6457_(ServerPlayer p_184178_1_) {
        super.m_6457_(p_184178_1_);
        this.bossEvent.m_6543_(p_184178_1_);
    }

    public void m_6452_(ServerPlayer p_184203_1_) {
        super.m_6452_(p_184203_1_);
        this.bossEvent.m_6539_(p_184203_1_);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.f_20919_ > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("endersent_death", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
        } else if (this.isTeleporting() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("endersent_teleport", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
        } else if (this.isAttacking() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("endersent_attack", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("endersent_walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("endersent_idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    protected boolean teleport() {
        if (!this.f_19853_.m_5776_() && this.m_6084_()) {
            double d0 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 32.0;
            double d1 = this.m_20186_() + (double)(this.f_19796_.m_188503_(8) - 4);
            double d2 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 32.0;
            return this.teleport(d0, d1, d2);
        }
        return false;
    }

    private boolean teleportTowards(Entity p_70816_1_) {
        Vec3 vector3d = new Vec3(this.m_20185_() - p_70816_1_.m_20185_(), this.m_20227_(0.5) - p_70816_1_.m_20188_(), this.m_20189_() - p_70816_1_.m_20189_());
        vector3d = vector3d.m_82541_();
        double d0 = 16.0;
        double d1 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vector3d.f_82479_ * 16.0;
        double d2 = this.m_20186_() + (double)(this.f_19796_.m_188503_(16) - 8) - vector3d.f_82480_ * 16.0;
        double d3 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vector3d.f_82481_ * 16.0;
        return this.teleport(d1, d2, d3);
    }

    @Override
    protected boolean teleport(double p_70825_1_, double p_70825_3_, double p_70825_5_) {
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos(p_70825_1_, p_70825_3_, p_70825_5_);
        while (blockpos$mutable.m_123342_() > 0 && !this.f_19853_.m_8055_((BlockPos)blockpos$mutable).m_60767_().m_76334_()) {
            blockpos$mutable.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = this.f_19853_.m_8055_((BlockPos)blockpos$mutable);
        boolean flag = blockstate.m_60767_().m_76334_();
        boolean flag1 = blockstate.m_60819_().m_205070_(FluidTags.f_13131_);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)p_70825_1_, (double)p_70825_3_, (double)p_70825_5_);
            if (event.isCanceled()) {
                return false;
            }
            boolean flag2 = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2 && !this.m_20067_()) {
                this.f_19853_.m_6263_(null, this.f_19854_, this.f_19855_, this.f_19856_, (SoundEvent)ModSoundEvents.ENDERSENT_TELEPORT.get(), this.m_5720_(), 1.0f, 1.0f);
                this.m_5496_((SoundEvent)ModSoundEvents.ENDERSENT_TELEPORT.get(), 1.0f, 1.0f);
            }
            return flag2;
        }
        return false;
    }

    class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal(double speed) {
            super((PathfinderMob)EndersentEntity.this, speed, true);
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }

        protected double m_6639_(LivingEntity p_179512_1_) {
            return this.f_25540_.m_20205_() * 5.0f * this.f_25540_.m_20205_() * 5.0f + p_179512_1_.m_20205_();
        }

        public void m_8037_() {
            super.m_8037_();
            EndersentEntity.this.setRunning(10);
        }

        protected void m_6739_(LivingEntity p_190102_1_, double p_190102_2_) {
            double d0 = this.m_6639_(p_190102_1_);
            if (p_190102_2_ <= d0 && this.m_25564_()) {
                this.m_25563_();
                this.f_25540_.m_7327_((Entity)p_190102_1_);
            } else if (p_190102_2_ <= d0 * 1.5) {
                if (this.m_25564_()) {
                    this.m_25563_();
                }
                if (this.m_25565_() <= 30) {
                    EndersentEntity.this.setAttacking(30);
                }
            } else {
                this.m_25563_();
            }
        }
    }
}

