/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.ender;

import com.infamous.dungeons_mobs.entities.ender.AbstractEnderlingEntity;
import com.infamous.dungeons_mobs.entities.projectiles.SnarelingGlobEntity;
import com.infamous.dungeons_mobs.mod.ModEffects;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class SnarelingEntity
extends AbstractEnderlingEntity
implements IAnimatable {
    public static final EntityDataAccessor<Integer> SHOOT_TIME = SynchedEntityData.m_135353_(SnarelingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public SnarelingEntity(EntityType<? extends SnarelingEntity> p_i50210_1_, Level p_i50210_2_) {
        super(p_i50210_1_, p_i50210_2_);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, new AvoidEntityGoal((PathfinderMob)this, 3.0f, 1.0, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new AttackGoal());
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new AbstractEnderlingEntity.FindPlayerGoal(this, null));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{AbstractEnderlingEntity.class}).m_26044_(new Class[0]).m_26146_(500));
        this.f_21346_.m_25352_(1, (Goal)new AbstractEnderlingEntity.EnderlingTargetGoal<Player>((Mob)this, Player.class, true).m_26146_(500));
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    protected void m_7355_(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.m_5496_(this.getStepSound(), 0.75f, 1.0f);
    }

    protected SoundEvent getStepSound() {
        return (SoundEvent)ModSoundEvents.SNARELING_STEP.get();
    }

    @Override
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.SNARELING_IDLE.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return (SoundEvent)ModSoundEvents.SNARELING_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.SNARELING_DEATH.get();
    }

    @Override
    public void m_6075_() {
        super.m_6075_();
        if (this.m_5448_() != null && this.m_5448_().m_6084_() && this.m_20270_((Entity)this.m_5448_()) > 5.0f && this.m_5448_().m_21023_((MobEffect)ModEffects.ENSNARED.get()) && this.f_19796_.m_188503_(10) == 0) {
            this.teleport(this.m_5448_().m_20185_() - 3.0 + (double)this.f_19796_.m_188503_(6), this.m_5448_().m_20186_(), this.m_5448_().m_20189_() - 3.0 + (double)this.f_19796_.m_188503_(6));
        }
        if (this.m_5448_() != null && this.m_5448_().m_6084_() && !this.m_5448_().m_21023_((MobEffect)ModEffects.ENSNARED.get()) && this.m_142582_((Entity)this.m_5448_()) && this.getShootTime() <= 0 && this.f_19796_.m_188503_(10) == 0) {
            this.setShootTime(80);
            this.m_5496_((SoundEvent)ModSoundEvents.SNARELING_PREPARE_SHOOT.get(), 2.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        }
        if (this.getShootTime() > 0) {
            this.setShootTime(this.getShootTime() - 1);
        }
        if (!this.f_19853_.f_46443_ && this.getShootTime() == 15 && this.m_5448_() != null && this.m_5448_().m_6084_()) {
            this.performRangedAttack(this.m_5448_(), 2.0f);
        }
        if (this.isAttacking() == 29) {
            this.m_5496_((SoundEvent)ModSoundEvents.SNARELING_ATTACK.get(), 1.0f, 1.0f);
        }
        if (this.getShootTime() > 0) {
            this.m_21051_(Attributes.f_22279_).m_22100_(0.0);
        } else {
            this.m_21051_(Attributes.f_22279_).m_22100_((double)0.3f);
        }
    }

    public void performRangedAttack(LivingEntity p_82196_1_, float p_82196_2_) {
        SnarelingGlobEntity snowballentity = new SnarelingGlobEntity(this.f_19853_, (LivingEntity)this);
        double d0 = p_82196_1_.m_20188_() - 1.75;
        double d1 = p_82196_1_.m_20185_() - this.m_20185_();
        double d2 = d0 - snowballentity.m_20186_();
        double d3 = p_82196_1_.m_20189_() - this.m_20189_();
        float f = Mth.m_14116_((float)((float)(d1 * d1 + d3 * d3))) * 0.2f;
        snowballentity.m_6686_(d1, d2 + (double)f, d3, 1.6f, 2.0f);
        this.m_5496_((SoundEvent)ModSoundEvents.SNARELING_SHOOT.get(), 2.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.f_19853_.m_7967_((Entity)snowballentity);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOT_TIME, (Object)0);
    }

    public int getShootTime() {
        return (Integer)this.f_19804_.m_135370_(SHOOT_TIME);
    }

    public void setShootTime(int p_189794_1_) {
        this.f_19804_.m_135381_(SHOOT_TIME, (Object)p_189794_1_);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.getShootTime() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("snareling_shoot", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.isAttacking() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("snareling_attack", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("snareling_walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("snareling_idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public class AvoidEntityGoal<T extends LivingEntity>
    extends Goal {
        protected final PathfinderMob mob;
        private final double walkSpeedModifier;
        private final double sprintSpeedModifier;
        protected LivingEntity toAvoid;
        protected final float maxDist;
        protected Path path;
        protected final PathNavigation pathNav;
        protected final Predicate<LivingEntity> avoidPredicate;
        protected final Predicate<LivingEntity> predicateOnAvoidEntity;
        private final TargetingConditions avoidEntityTargeting;

        public AvoidEntityGoal(PathfinderMob p_i46404_1_, float p_i46404_3_, double p_i46404_4_, double p_i46404_6_) {
            this(p_i46404_1_, p_200828_0_ -> true, p_i46404_3_, p_i46404_4_, p_i46404_6_, EntitySelector.f_20406_::test);
        }

        public AvoidEntityGoal(PathfinderMob p_i48859_1_, Predicate<LivingEntity> p_i48859_3_, float p_i48859_4_, double p_i48859_5_, double p_i48859_7_, Predicate<LivingEntity> p_i48859_9_) {
            this.mob = p_i48859_1_;
            this.avoidPredicate = p_i48859_3_;
            this.maxDist = p_i48859_4_;
            this.walkSpeedModifier = p_i48859_5_;
            this.sprintSpeedModifier = p_i48859_7_;
            this.predicateOnAvoidEntity = p_i48859_9_;
            this.pathNav = p_i48859_1_.m_21573_();
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.avoidEntityTargeting = TargetingConditions.m_148352_().m_26883_((double)p_i48859_4_).m_26888_(p_i48859_9_.and(p_i48859_3_));
        }

        public AvoidEntityGoal(PathfinderMob p_i48860_1_, float p_i48860_3_, double p_i48860_4_, double p_i48860_6_, Predicate<LivingEntity> p_i48860_8_) {
            this(p_i48860_1_, p_203782_0_ -> true, p_i48860_3_, p_i48860_4_, p_i48860_6_, p_i48860_8_);
        }

        public boolean m_8036_() {
            this.toAvoid = SnarelingEntity.this.m_5448_();
            if (this.toAvoid == null || this.mob.m_20270_((Entity)this.toAvoid) > this.maxDist) {
                return false;
            }
            Vec3 vector3d = DefaultRandomPos.m_148407_((PathfinderMob)this.mob, (int)16, (int)7, (Vec3)this.toAvoid.m_20182_());
            if (vector3d == null) {
                return false;
            }
            if (this.toAvoid.m_20275_(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_) < this.toAvoid.m_20280_((Entity)this.mob)) {
                return false;
            }
            this.path = this.pathNav.m_26524_(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_, 0);
            return SnarelingEntity.this.m_5448_() != null && SnarelingEntity.this.m_5448_().m_6084_() && !SnarelingEntity.this.m_5448_().m_21023_((MobEffect)ModEffects.ENSNARED.get()) && this.path != null;
        }

        public boolean m_8045_() {
            return SnarelingEntity.this.m_5448_() != null && SnarelingEntity.this.m_5448_().m_6084_() && !SnarelingEntity.this.m_5448_().m_21023_((MobEffect)ModEffects.ENSNARED.get()) && !this.pathNav.m_26571_();
        }

        public void m_8056_() {
            this.pathNav.m_26536_(this.path, this.walkSpeedModifier);
        }

        public void m_8041_() {
            this.toAvoid = null;
        }

        public void m_8037_() {
            SnarelingEntity.this.setShootTime(0);
            if (this.mob.m_20280_((Entity)this.toAvoid) < 49.0) {
                this.mob.m_21573_().m_26517_(this.sprintSpeedModifier);
            } else {
                this.mob.m_21573_().m_26517_(this.walkSpeedModifier);
            }
        }
    }

    class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal() {
            super((PathfinderMob)SnarelingEntity.this, 1.0, true);
        }

        public boolean m_8045_() {
            return SnarelingEntity.this.getShootTime() <= 0 && super.m_8045_();
        }

        protected double m_6639_(LivingEntity p_179512_1_) {
            return this.f_25540_.m_20205_() * 3.0f * this.f_25540_.m_20205_() * 3.0f + p_179512_1_.m_20205_();
        }

        protected void m_6739_(LivingEntity p_190102_1_, double p_190102_2_) {
            double d0 = this.m_6639_(p_190102_1_);
            if (p_190102_2_ <= d0 && this.m_25564_() && SnarelingEntity.this.getShootTime() <= 0) {
                this.m_25563_();
                this.f_25540_.m_7327_((Entity)p_190102_1_);
            } else if (p_190102_2_ <= d0 * 1.5) {
                if (this.m_25564_()) {
                    this.m_25563_();
                }
                if (this.m_25565_() <= 30) {
                    SnarelingEntity.this.setAttacking(30);
                }
            } else {
                this.m_25563_();
            }
        }
    }
}

