/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.golem;

import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class SquallGolemEntity
extends Raider
implements IAnimatable {
    private int attackTimer;
    private int attackID;
    public int cd;
    public static final byte STOMP_ATTACK = 1;
    public static final byte GOLEM_ACTIVATE = 2;
    public static final byte GOLEM_DEACTIVATE = 3;
    private int timeWithoutTarget;
    private static final EntityDataAccessor<Boolean> ACTIVATE = SynchedEntityData.m_135353_(SquallGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> MELEEATTACKING = SynchedEntityData.m_135353_(SquallGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public SquallGolemEntity(Level world) {
        super((EntityType)ModEntityTypes.SQUALL_GOLEM.get(), world);
    }

    public SquallGolemEntity(EntityType<? extends Raider> type, Level world) {
        super(type, world);
        this.f_21364_ = 20;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 90.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22281_, 15.0).m_22268_(Attributes.f_22282_, 1.25);
    }

    public boolean m_6094_() {
        return false;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 10.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        Vec3 velocity = this.m_20184_();
        float groundSpeed = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
        if (this.attackID == 2) {
            event.getController().setAnimationSpeed(1.0);
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.squall_golem.activate", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            return PlayState.CONTINUE;
        }
        if (this.attackID == 3) {
            event.getController().setAnimationSpeed(1.0);
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.squall_golem.deactivate", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            return PlayState.CONTINUE;
        }
        if (!this.getActivate()) {
            event.getController().setAnimationSpeed(1.0);
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.squall_golem.deactivated", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isMeleeAttacking() && this.m_6084_()) {
            event.getController().setAnimationSpeed(1.0);
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.squall_golem.attack", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            return PlayState.CONTINUE;
        }
        if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimationSpeed((double)(groundSpeed * 25.0f));
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.squall_golem.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimationSpeed(1.0);
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.squall_golem.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(4, (Goal)new AttackGoal());
        this.f_21345_.m_25352_(0, (Goal)new MeleeGoal());
        this.f_21345_.m_25352_(1, (Goal)new DoNothingGoal());
        this.f_21345_.m_25352_(0, (Goal)new Deactivate());
        this.f_21345_.m_25352_(0, (Goal)new Activate());
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ACTIVATE, (Object)false);
        this.f_19804_.m_135372_(MELEEATTACKING, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("activate", this.getActivate());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setActivate(compound.m_128471_("activate"));
    }

    public void setActivate(boolean isActivate) {
        this.f_19804_.m_135381_(ACTIVATE, (Object)isActivate);
    }

    public boolean getActivate() {
        return (Boolean)this.f_19804_.m_135370_(ACTIVATE);
    }

    public boolean isMeleeAttacking() {
        return (Boolean)this.f_19804_.m_135370_(MELEEATTACKING);
    }

    public void setMeleeAttacking(boolean attacking) {
        this.f_19804_.m_135381_(MELEEATTACKING, (Object)attacking);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.attackID != 0) {
            ++this.attackTimer;
        }
        this.m_20334_(this.m_20184_().f_82479_, this.m_20184_().f_82480_ - 2.5, this.m_20184_().f_82481_);
        this.handleLeafCollision();
        this.handleSteppingOnBlocks();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.attackID == 1 && this.attackTimer == 30) {
            this.Attackparticle(40, 0.5f, 2.6f, 0.5f);
            this.Attackparticle(40, 0.5f, 2.4f, -1.0f);
        }
        LivingEntity target = this.m_5448_();
        if (!this.f_19853_.f_46443_) {
            ++this.timeWithoutTarget;
            if (target != null) {
                this.timeWithoutTarget = 0;
                if (!this.getActivate()) {
                    this.setActivate(true);
                    this.attackID = 2;
                }
            }
            if (this.m_37885_() != null && this.m_37885_().m_37782_()) {
                this.timeWithoutTarget = 0;
                if (!this.getActivate()) {
                    this.setActivate(true);
                    this.attackID = 2;
                }
            }
            if (this.timeWithoutTarget > 200 && this.getActivate() && target == null) {
                this.timeWithoutTarget = 0;
                this.setActivate(false);
                this.attackID = 3;
            }
        }
        if (this.cd > 0) {
            --this.cd;
        }
    }

    private void Attackparticle(int paticle, float circle, float vec, float math) {
        if (this.f_19853_.f_46443_) {
            for (int i1 = 0; i1 < paticle; ++i1) {
                double DeltaMovementX = this.m_217043_().m_188583_() * 0.07;
                double DeltaMovementY = this.m_217043_().m_188583_() * 0.07;
                double DeltaMovementZ = this.m_217043_().m_188583_() * 0.07;
                float angle = (float)Math.PI / 180 * this.f_20883_ + (float)i1;
                float f = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                float f1 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                double extraX = circle * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.3f;
                double extraZ = circle * Mth.m_14089_((float)angle);
                double theta = (double)this.f_20883_ * (Math.PI / 180);
                double vecX = Math.cos(theta += 1.5707963267948966);
                double vecZ = Math.sin(theta);
                int hitX = Mth.m_14107_((double)(this.m_20185_() + (double)vec * vecX + extraX));
                int hitY = Mth.m_14107_((double)this.m_20186_());
                int hitZ = Mth.m_14107_((double)(this.m_20189_() + (double)vec * vecZ + extraZ));
                BlockPos hit = new BlockPos(hitX, hitY, hitZ);
                BlockState block = this.f_19853_.m_8055_(hit.m_7495_());
                this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block), this.m_20185_() + (double)vec * vecX + extraX + (double)(f * math), this.m_20186_() + extraY, this.m_20189_() + (double)vec * vecZ + extraZ + (double)(f1 * math), DeltaMovementX, DeltaMovementY, DeltaMovementZ);
            }
        }
    }

    private void handleSteppingOnBlocks() {
        int k;
        int j;
        int i;
        BlockPos pos;
        BlockState blockstate;
        if (this.m_20184_().m_165925_() > 2.500000277905201E-7 && this.f_19796_.m_188503_(5) == 0 && !(blockstate = this.f_19853_.m_8055_(pos = new BlockPos(i = Mth.m_14107_((double)this.m_20185_()), j = Mth.m_14107_((double)(this.m_20186_() - (double)0.2f)), k = Mth.m_14107_((double)this.m_20189_())))).m_60795_()) {
            this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate).setPos(pos), this.m_20185_() + ((double)this.f_19796_.m_188501_() - 0.5) * (double)this.m_20205_(), this.m_20186_() + 0.1, this.m_20189_() + ((double)this.f_19796_.m_188501_() - 0.5) * (double)this.m_20205_(), 4.0 * ((double)this.f_19796_.m_188501_() - 0.5), 0.5, ((double)this.f_19796_.m_188501_() - 0.5) * 4.0);
        }
    }

    private void handleLeafCollision() {
        if (this.m_6084_() && this.f_19862_ && ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this)) {
            boolean destroyedLeafBlock = false;
            AABB axisalignedbb = this.m_20191_().m_82400_(0.2);
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)axisalignedbb.f_82288_), (int)Mth.m_14107_((double)axisalignedbb.f_82289_), (int)Mth.m_14107_((double)axisalignedbb.f_82290_), (int)Mth.m_14107_((double)axisalignedbb.f_82291_), (int)Mth.m_14107_((double)axisalignedbb.f_82292_), (int)Mth.m_14107_((double)axisalignedbb.f_82293_))) {
                BlockState blockstate = this.f_19853_.m_8055_(blockpos);
                Block block = blockstate.m_60734_();
                if (!(block instanceof LeavesBlock)) continue;
                destroyedLeafBlock = this.f_19853_.m_46953_(blockpos, true, (Entity)this) || destroyedLeafBlock;
            }
            if (!destroyedLeafBlock && this.f_19861_) {
                this.m_6135_();
            }
        }
    }

    protected int m_7302_(int air) {
        return air;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (((Boolean)this.f_19804_.m_135370_(ACTIVATE)).booleanValue() && this.f_20891_ > 5) {
            return (SoundEvent)ModSoundEvents.SQUALL_GOLEM_IDLE.get();
        }
        return null;
    }

    public boolean m_7327_(Entity entityIn) {
        if (!this.f_19853_.f_46443_ && this.attackID == 0) {
            this.attackID = 1;
        }
        return true;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean flag = false;
        if (!this.getActivate() && source != DamageSource.f_19317_) {
            this.m_5496_(SoundEvents.f_12600_, 1.0f, 0.4f);
            if (source.m_7639_() instanceof LivingEntity && source.m_7639_().m_20147_()) {
                this.m_6710_((LivingEntity)source.m_7639_());
            }
            flag = false;
        } else {
            flag = super.m_6469_(source, amount);
        }
        return flag;
    }

    public boolean m_6914_(LevelReader worldIn) {
        BlockPos golemPos = this.m_20183_();
        BlockPos posBeneathGolem = golemPos.m_7495_();
        BlockState blockstateBeneathGolem = worldIn.m_8055_(posBeneathGolem);
        if (!blockstateBeneathGolem.m_60634_((BlockGetter)worldIn, posBeneathGolem, (Entity)this)) {
            return false;
        }
        for (int i = 1; i < 3; ++i) {
            BlockState blockstateAboveGolem;
            BlockPos posAboveGolem = golemPos.m_6630_(i);
            if (NaturalSpawner.m_47056_((BlockGetter)worldIn, (BlockPos)posAboveGolem, (BlockState)(blockstateAboveGolem = worldIn.m_8055_(posAboveGolem)), (FluidState)blockstateAboveGolem.m_60819_(), (EntityType)((EntityType)ModEntityTypes.SQUALL_GOLEM.get()))) continue;
            return false;
        }
        return NaturalSpawner.m_47056_((BlockGetter)worldIn, (BlockPos)golemPos, (BlockState)worldIn.m_8055_(golemPos), (FluidState)Fluids.f_76191_.m_76145_(), (EntityType)((EntityType)ModEntityTypes.SQUALL_GOLEM.get())) && worldIn.m_45784_((Entity)this);
    }

    private void setAttackID(int id) {
        this.attackID = id;
        this.attackTimer = 0;
        this.f_19853_.m_7605_((Entity)this, (byte)(-id));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id <= 0) {
            this.attackID = Math.abs(id);
            this.attackTimer = 0;
        } else {
            super.m_7822_(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.875f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)ModSoundEvents.SQUALL_GOLEM_WALK.get(), 1.12f, 1.0f);
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.SQUALL_GOLEM_HURT.get();
    }

    protected float m_6121_() {
        return 2.5f;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.SQUALL_GOLEM_DEATH.get();
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new Navigator((Mob)this, worldIn);
    }

    public void m_7895_(int p_213660_1_, boolean p_213660_2_) {
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)ModSoundEvents.SQUALL_GOLEM_IDLE.get();
    }

    public boolean m_7490_() {
        return false;
    }

    class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal() {
            super((PathfinderMob)SquallGolemEntity.this, 1.25, false);
        }

        protected double m_6639_(LivingEntity p_179512_1_) {
            float f = SquallGolemEntity.this.m_20205_() - 0.1f;
            return f * 1.8f * f * 1.8f + p_179512_1_.m_20205_();
        }
    }

    class MeleeGoal
    extends Goal {
        public MeleeGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return SquallGolemEntity.this.attackID == 1 && SquallGolemEntity.this.cd <= 0;
        }

        public boolean m_8045_() {
            return SquallGolemEntity.this.attackTimer < 34;
        }

        public void m_8056_() {
            if (SquallGolemEntity.this.m_5448_() != null) {
                SquallGolemEntity.this.m_21563_().m_24960_((Entity)SquallGolemEntity.this.m_5448_(), 30.0f, 30.0f);
            }
            SquallGolemEntity.this.setMeleeAttacking(true);
            SquallGolemEntity.this.setAttackID(1);
        }

        public void m_8037_() {
            SquallGolemEntity.this.m_20334_(0.0, SquallGolemEntity.this.m_20184_().f_82480_, 0.0);
            LivingEntity target = SquallGolemEntity.this.m_5448_();
            if (SquallGolemEntity.this.attackTimer < 15 && target != null) {
                SquallGolemEntity.this.m_21391_((Entity)target, 15.0f, 15.0f);
            } else {
                SquallGolemEntity.this.m_146922_(SquallGolemEntity.this.f_19859_);
            }
            if (SquallGolemEntity.this.attackTimer == 12) {
                SquallGolemEntity.this.m_5496_((SoundEvent)ModSoundEvents.SQUALL_GOLEM_ATTACK.get(), 2.0f, 1.0f);
            }
            if (SquallGolemEntity.this.attackTimer == 30) {
                this.AreaAttack(5.0f, 5.0f, 5.0f, 5.0f, 60.0f, 1.0f);
            }
        }

        private void AreaAttack(float range, float X, float Y, float Z, float arc, float damage) {
            for (LivingEntity entityHit : SquallGolemEntity.this.f_19853_.m_45976_(LivingEntity.class, SquallGolemEntity.this.m_20191_().m_82377_((double)X, (double)Y, (double)Z))) {
                float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - SquallGolemEntity.this.m_20189_(), entityHit.m_20185_() - SquallGolemEntity.this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
                float entityAttackingAngle = SquallGolemEntity.this.f_20883_ % 360.0f;
                if (entityHitAngle < 0.0f) {
                    entityHitAngle += 360.0f;
                }
                if (entityAttackingAngle < 0.0f) {
                    entityAttackingAngle += 360.0f;
                }
                float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
                float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - SquallGolemEntity.this.m_20189_()) * (entityHit.m_20189_() - SquallGolemEntity.this.m_20189_()) + (entityHit.m_20185_() - SquallGolemEntity.this.m_20185_()) * (entityHit.m_20185_() - SquallGolemEntity.this.m_20185_()));
                if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || SquallGolemEntity.this.m_7307_((Entity)entityHit) || entityHit == SquallGolemEntity.this) continue;
                entityHit.m_6469_(DamageSource.m_19370_((LivingEntity)SquallGolemEntity.this), (float)SquallGolemEntity.this.m_21133_(Attributes.f_22281_) * damage);
                SquallGolemEntity v = SquallGolemEntity.this;
                float attackKnockback = (float)SquallGolemEntity.this.m_21133_(Attributes.f_22282_);
                double ratioX = Mth.m_14031_((float)(v.m_146908_() * ((float)Math.PI / 180)));
                double ratioZ = -Mth.m_14089_((float)(v.m_146908_() * ((float)Math.PI / 180)));
                double knockbackReduction = 0.35;
                entityHit.m_6469_(DamageSource.m_19370_((LivingEntity)v), damage);
                this.forceKnockback(entityHit, attackKnockback * 0.8f, ratioX, ratioZ, knockbackReduction);
                entityHit.m_20256_(entityHit.m_20184_().m_82520_(0.0, 0.3333333, 0.0));
            }
        }

        public void m_8041_() {
            SquallGolemEntity.this.setMeleeAttacking(false);
            SquallGolemEntity.this.setAttackID(0);
            SquallGolemEntity.this.cd = 25;
        }

        private void forceKnockback(LivingEntity attackTarget, float strength, double ratioX, double ratioZ, double knockbackResistanceReduction) {
            LivingKnockBackEvent event = ForgeHooks.onLivingKnockBack((LivingEntity)attackTarget, (float)strength, (double)ratioX, (double)ratioZ);
            if (event.isCanceled()) {
                return;
            }
            strength = event.getStrength();
            ratioX = event.getRatioX();
            ratioZ = event.getRatioZ();
            if (!((strength = (float)((double)strength * (1.0 - attackTarget.m_21133_(Attributes.f_22278_) * knockbackResistanceReduction))) <= 0.0f)) {
                attackTarget.f_19812_ = true;
                Vec3 vector3d = attackTarget.m_20184_();
                Vec3 vector3d1 = new Vec3(ratioX, 0.0, ratioZ).m_82541_().m_82490_((double)strength);
                attackTarget.m_20334_(vector3d.f_82479_ / 2.0 - vector3d1.f_82479_, attackTarget.m_20096_() ? Math.min(0.4, vector3d.f_82480_ / 2.0 + (double)strength) : vector3d.f_82480_, vector3d.f_82481_ / 2.0 - vector3d1.f_82481_);
            }
        }
    }

    class DoNothingGoal
    extends Goal {
        public DoNothingGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return !SquallGolemEntity.this.getActivate();
        }

        public void m_8037_() {
            SquallGolemEntity.this.m_20334_(0.0, SquallGolemEntity.this.m_20184_().f_82480_, 0.0);
        }
    }

    class Deactivate
    extends Goal {
        public Deactivate() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return SquallGolemEntity.this.attackID == 3;
        }

        public boolean m_8045_() {
            return SquallGolemEntity.this.attackTimer < 80;
        }

        public void m_8056_() {
            SquallGolemEntity.this.setAttackID(3);
            SquallGolemEntity.this.m_5496_((SoundEvent)ModSoundEvents.SQUALL_GOLEM_OFF.get(), 1.0f, 1.0f);
        }

        public void m_8037_() {
            SquallGolemEntity.this.m_20334_(0.0, SquallGolemEntity.this.m_20184_().f_82480_, 0.0);
        }

        public void m_8041_() {
            SquallGolemEntity.this.setAttackID(0);
        }
    }

    class Activate
    extends Goal {
        public Activate() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return SquallGolemEntity.this.attackID == 2;
        }

        public boolean m_8045_() {
            return SquallGolemEntity.this.attackTimer < 60;
        }

        public void m_8056_() {
            SquallGolemEntity.this.setAttackID(2);
            SquallGolemEntity.this.m_5496_((SoundEvent)ModSoundEvents.SQUALL_GOLEM_OPEN.get(), 1.0f, 1.0f);
        }

        public void m_8037_() {
            SquallGolemEntity.this.m_20334_(0.0, SquallGolemEntity.this.m_20184_().f_82480_, 0.0);
        }

        public void m_8041_() {
            SquallGolemEntity.this.setAttackID(0);
        }
    }

    static class Navigator
    extends GroundPathNavigation {
        public Navigator(Mob mobEntity, Level world) {
            super(mobEntity, world);
        }

        protected PathFinder m_5532_(int p_179679_1_) {
            this.f_26508_ = new Processor();
            return new PathFinder(this.f_26508_, p_179679_1_);
        }
    }

    static class Processor
    extends WalkNodeEvaluator {
        private Processor() {
        }

        protected BlockPathTypes m_6603_(BlockGetter blockReader, boolean canBreakDoors, boolean canWalkThroughDoorways, BlockPos blockPos, BlockPathTypes pathNodeType) {
            return pathNodeType == BlockPathTypes.LEAVES ? BlockPathTypes.OPEN : super.m_6603_(blockReader, canBreakDoors, canWalkThroughDoorways, blockPos, pathNodeType);
        }
    }
}

