/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.illagers;

import com.infamous.dungeons_libraries.entities.SpawnArmoredMob;
import com.infamous.dungeons_libraries.items.gearconfig.ArmorSet;
import com.infamous.dungeons_mobs.entities.SpawnEquipmentHelper;
import com.infamous.dungeons_mobs.entities.illagers.IllagerArmsUtil;
import com.infamous.dungeons_mobs.entities.illagers.IllusionerCloneEntity;
import com.infamous.dungeons_mobs.entities.summonables.SummonSpotEntity;
import com.infamous.dungeons_mobs.goals.ApproachTargetGoal;
import com.infamous.dungeons_mobs.goals.LookAtTargetGoal;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModItems;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import com.infamous.dungeons_mobs.utils.ModProjectileHelper;
import com.infamous.dungeons_mobs.utils.PositionUtils;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class DungeonsIllusionerEntity
extends AbstractIllager
implements IAnimatable,
SpawnArmoredMob {
    public int shootAnimationTick;
    public int shootAnimationLength = 35;
    public int shootAnimationActionPoint = 15;
    public int blindAnimationTick;
    public int blindAnimationLength = 30;
    public int blindAnimationActionPoint = 18;
    public int vanishAnimationTick;
    public int vanishAnimationLength = 20;
    public int appearAnimationTick;
    public int appearAnimationLength = 20;
    public int appearDelay = 0;
    AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public DungeonsIllusionerEntity(Level world) {
        super((EntityType)ModEntityTypes.ILLUSIONER.get(), world);
    }

    public DungeonsIllusionerEntity(EntityType<? extends DungeonsIllusionerEntity> type, Level world) {
        super(type, world);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new RemainStationaryGoal());
        this.f_21345_.m_25352_(1, (Goal)new CreateIllusionsGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new BlindAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new ShootAttackGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new ApproachTargetGoal((PathfinderMob)this, 7.5, 1.0, true));
        this.f_21345_.m_25352_(5, (Goal)new LookAtTargetGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(600));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).m_26146_(600));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false).m_26146_(600));
    }

    public boolean shouldBeStationary() {
        return this.appearAnimationTick > 0 || this.appearDelay > 0;
    }

    public boolean m_21526_() {
        return true;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22276_, 50.0);
    }

    public void m_7822_(byte p_28844_) {
        if (p_28844_ == 4) {
            this.shootAnimationTick = this.shootAnimationLength;
        } else if (p_28844_ == 11) {
            this.blindAnimationTick = this.blindAnimationLength;
        } else if (p_28844_ == 9) {
            this.vanishAnimationTick = this.vanishAnimationLength;
        } else if (p_28844_ == 8) {
            this.appearAnimationTick = this.appearAnimationLength;
        } else if (p_28844_ == 6) {
            this.appearDelay = 11;
        } else if (p_28844_ == 7) {
            for (int i = 0; i < 20; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), d0, d1, d2);
            }
        } else {
            super.m_7822_(p_28844_);
        }
    }

    public void m_6075_() {
        super.m_6075_();
        this.tickDownAnimTimers();
        if (this.appearDelay > 0) {
            --this.appearDelay;
        }
        if (!this.f_19853_.f_46443_ && this.appearDelay == 1) {
            this.appearAnimationTick = this.appearAnimationLength;
            this.f_19853_.m_7605_((Entity)this, (byte)8);
        }
    }

    public void tickDownAnimTimers() {
        if (this.shootAnimationTick > 0) {
            --this.shootAnimationTick;
        }
        if (this.blindAnimationTick > 0) {
            --this.blindAnimationTick;
        }
        if (this.vanishAnimationTick > 0) {
            --this.vanishAnimationTick;
        }
        if (this.appearAnimationTick > 0) {
            --this.appearAnimationTick;
        }
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        String suffix = "_uncrossed";
        if (IllagerArmsUtil.armorHasCrossedArms(this, this.m_6844_(EquipmentSlot.CHEST))) {
            suffix = "";
        }
        if (this.appearAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("illusioner_appear" + suffix, (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.vanishAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("illusioner_vanish" + suffix, (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.shootAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("illusioner_shoot" + suffix, (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.blindAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("illusioner_blind" + suffix, (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("illusioner_walk" + suffix, (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.m_37888_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("illusioner_celebrate", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("illusioner_idle" + suffix, (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected void m_213945_(RandomSource random, DifficultyInstance p_180481_1_) {
        super.m_213945_(random, p_180481_1_);
        SpawnEquipmentHelper.equipArmorSet(ModItems.ILLUSIONER_ARMOR, (Mob)this);
        if (ModList.get().isLoaded("dungeons_gear")) {
            Item SHORTBOW = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("dungeons_gear", "shortbow"));
            SpawnEquipmentHelper.equipMainhand(SHORTBOW.m_7968_(), (Mob)this);
        } else {
            SpawnEquipmentHelper.equipMainhand(Items.f_42411_.m_7968_(), (Mob)this);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_213386_1_, DifficultyInstance p_213386_2_, MobSpawnType p_213386_3_, @Nullable SpawnGroupData p_213386_4_, @Nullable CompoundTag p_213386_5_) {
        SpawnGroupData iLivingEntityData = super.m_6518_(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
        this.m_213945_(this.m_217043_(), p_213386_2_);
        this.m_213946_(this.m_217043_(), p_213386_2_);
        return iLivingEntityData;
    }

    public boolean m_7307_(Entity entityIn) {
        if (super.m_7307_(entityIn)) {
            return true;
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        return false;
    }

    public void m_7895_(int p_213660_1_, boolean p_213660_2_) {
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12048_;
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.ILLUSIONER_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12051_;
    }

    public SoundEvent m_7930_() {
        return SoundEvents.f_12048_;
    }

    public boolean m_6469_(DamageSource p_70097_1_, float p_70097_2_) {
        if (p_70097_1_.m_7639_() != null && this.m_7307_(p_70097_1_.m_7639_()) && p_70097_1_ != DamageSource.f_19317_) {
            return false;
        }
        return super.m_6469_(p_70097_1_, p_70097_2_);
    }

    public void shootRocket(LivingEntity target) {
        int explosionsByDifficulty = this.f_19853_.m_6436_(this.m_20183_()).m_19048_().m_19028_();
        ItemStack fireworkRocket = ModProjectileHelper.createRocket(explosionsByDifficulty * 2, DyeColor.PINK, DyeColor.PURPLE);
        FireworkRocketEntity fireworkrocketentity = new FireworkRocketEntity(this.f_19853_, fireworkRocket, (Entity)this, this.m_20185_(), this.m_20188_() - (double)0.15f, this.m_20189_(), true);
        double xDifference = target.m_20185_() - this.m_20185_();
        double yDifference = target.m_20227_(0.3333333333333333) - fireworkrocketentity.m_20186_();
        double zDifference = target.m_20189_() - this.m_20189_();
        fireworkrocketentity.m_6686_(xDifference, yDifference, zDifference, 1.0f, (float)(18.0 - (double)this.f_19853_.m_46791_().m_19028_() * 7.5));
        this.m_5496_(SoundEvents.f_11933_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.f_19853_.m_7967_((Entity)fireworkrocketentity);
    }

    private void spawnBlindingCloud(BlockPos pos) {
        AreaEffectCloud areaeffectcloudentity = new AreaEffectCloud(this.f_19853_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        areaeffectcloudentity.m_19712_(3.0f);
        areaeffectcloudentity.m_19732_(-0.5f);
        areaeffectcloudentity.m_19740_(10);
        areaeffectcloudentity.m_19738_(-areaeffectcloudentity.m_19743_() / (float)areaeffectcloudentity.m_19748_());
        areaeffectcloudentity.m_19716_(new MobEffectInstance(MobEffects.f_19610_, 100));
        this.f_19853_.m_7967_((Entity)areaeffectcloudentity);
    }

    public ArmorSet getArmorSet() {
        return ModItems.ILLUSIONER_ARMOR;
    }

    class RemainStationaryGoal
    extends Goal {
        public RemainStationaryGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.TARGET, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return DungeonsIllusionerEntity.this.shouldBeStationary();
        }
    }

    class CreateIllusionsGoal
    extends Goal {
        public DungeonsIllusionerEntity mob;
        @Nullable
        public LivingEntity target;
        public int nextUseTime;
        private final Predicate<Entity> ILLUSIONER_CLONE = p_33346_ -> p_33346_ instanceof IllusionerCloneEntity && ((IllusionerCloneEntity)((Object)p_33346_)).getOwner() != null && ((IllusionerCloneEntity)((Object)p_33346_)).getOwner() == this.mob;

        public CreateIllusionsGoal(DungeonsIllusionerEntity mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return this.mob.shouldBeStationary();
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            int nearbyClones = this.mob.f_19853_.m_6249_((Entity)this.mob, this.mob.m_20191_().m_82400_(30.0), this.ILLUSIONER_CLONE).size();
            return this.target != null && this.mob.f_19797_ >= this.nextUseTime && this.mob.f_19796_.m_188503_(10) == 0 && this.mob.m_142582_((Entity)this.target) && nearbyClones <= 0 && this.animationsUseable();
        }

        public boolean m_8045_() {
            return this.target != null && !this.animationsUseable();
        }

        public void m_8056_() {
            this.mob.m_5496_(SoundEvents.f_12054_, 1.0f, 1.0f);
            this.mob.vanishAnimationTick = this.mob.vanishAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)9);
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            this.mob.m_21573_().m_26573_();
            if (this.target != null) {
                this.mob.m_21563_().m_24946_(this.target.m_20185_(), this.target.m_20188_(), this.target.m_20189_());
            }
            if (this.target != null && this.mob.vanishAnimationTick == 1) {
                SummonSpotEntity summonSpot = (SummonSpotEntity)((EntityType)ModEntityTypes.SUMMON_SPOT.get()).m_20615_(this.mob.f_19853_);
                summonSpot.m_20035_(this.target.m_20183_().m_7637_(-12.5 + (double)this.mob.f_19796_.m_188503_(25), 0.0, -12.5 + (double)this.mob.f_19796_.m_188503_(25)), 0.0f, 0.0f);
                ((ServerLevel)this.mob.f_19853_).m_47205_((Entity)summonSpot);
                PositionUtils.moveToCorrectHeight(summonSpot);
                this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)7);
                this.mob.m_20035_(summonSpot.m_20183_(), 0.0f, 0.0f);
                this.mob.m_5618_(this.mob.f_19796_.m_188503_(360));
                this.mob.m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3(this.mob.m_20185_(), this.mob.m_20188_(), this.mob.m_20189_()));
                this.mob.appearDelay = 11;
                this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)6);
                this.mob.m_5496_(SoundEvents.f_12052_, 1.0f, 1.0f);
                PositionUtils.moveToCorrectHeight((Entity)this.mob);
                if (this.target instanceof Mob) {
                    ((Mob)this.target).m_6710_(null);
                    this.target.m_6703_(null);
                    if (this.target instanceof NeutralMob) {
                        ((NeutralMob)this.target).m_21662_();
                        ((NeutralMob)this.target).m_6703_(null);
                        ((NeutralMob)this.target).m_6710_(null);
                        ((NeutralMob)this.target).m_6925_(null);
                    }
                }
                int clonesByDifficulty = this.mob.f_19853_.m_6436_(this.mob.m_20183_()).m_19048_().m_19028_();
                for (int i = 0; i < clonesByDifficulty * 4; ++i) {
                    SummonSpotEntity cloneSummonSpot = (SummonSpotEntity)((EntityType)ModEntityTypes.SUMMON_SPOT.get()).m_20615_(this.mob.f_19853_);
                    cloneSummonSpot.m_20035_(this.target.m_20183_().m_7637_(-12.5 + (double)this.mob.f_19796_.m_188503_(25), 0.0, -12.5 + (double)this.mob.f_19796_.m_188503_(25)), 0.0f, 0.0f);
                    cloneSummonSpot.mobSpawnRotation = this.mob.f_19796_.m_188503_(360);
                    ((ServerLevel)this.mob.f_19853_).m_47205_((Entity)cloneSummonSpot);
                    PositionUtils.moveToCorrectHeight(cloneSummonSpot);
                    IllusionerCloneEntity clone = (IllusionerCloneEntity)((EntityType)ModEntityTypes.ILLUSIONER_CLONE.get()).m_20615_(this.mob.f_19853_);
                    clone.m_6518_((ServerLevelAccessor)((ServerLevel)this.mob.f_19853_), this.mob.f_19853_.m_6436_(cloneSummonSpot.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                    clone.setOwner((Mob)this.mob);
                    clone.m_21153_(this.mob.m_21223_());
                    for (EquipmentSlot equipmentslottype : EquipmentSlot.values()) {
                        ItemStack itemstack = this.mob.m_6844_(equipmentslottype);
                        if (itemstack.m_41619_()) continue;
                        clone.m_8061_(equipmentslottype, itemstack.m_41777_());
                        clone.m_21409_(equipmentslottype, 0.0f);
                    }
                    clone.m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3(this.mob.m_20185_(), this.mob.m_20188_(), this.mob.m_20189_()));
                    clone.setDelayedAppear(true);
                    cloneSummonSpot.summonedEntity = clone;
                    cloneSummonSpot.m_5496_(SoundEvents.f_12052_, 1.0f, 1.0f);
                }
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.nextUseTime = this.mob.f_19797_ + 60;
        }

        public boolean animationsUseable() {
            return this.mob.vanishAnimationTick <= 0;
        }
    }

    class BlindAttackGoal
    extends Goal {
        public DungeonsIllusionerEntity mob;
        @Nullable
        public LivingEntity target;
        public int cooldown;

        public BlindAttackGoal(DungeonsIllusionerEntity mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return this.mob.shouldBeStationary();
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            if (this.cooldown > 0) {
                --this.cooldown;
            }
            return this.target != null && this.mob.f_19796_.m_188503_(30) == 0 && this.mob.m_20270_((Entity)this.target) <= 10.0f && this.cooldown <= 0 && this.mob.m_142582_((Entity)this.target) && this.animationsUseable();
        }

        public boolean m_8045_() {
            return this.target != null && !this.animationsUseable();
        }

        public void m_8056_() {
            this.mob.m_5496_(SoundEvents.f_12053_, 1.0f, 1.0f);
            this.mob.blindAnimationTick = this.mob.blindAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)11);
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            this.mob.m_21573_().m_26573_();
            if (this.target != null) {
                this.mob.m_21563_().m_24946_(this.target.m_20185_(), this.target.m_20188_(), this.target.m_20189_());
            }
            if (this.target != null && this.mob.blindAnimationTick == this.mob.blindAnimationActionPoint) {
                this.mob.m_5496_(SoundEvents.f_12049_, 1.0f, 1.0f);
                this.mob.spawnBlindingCloud(this.target.m_20183_());
                if (this.target instanceof Mob) {
                    ((Mob)this.target).m_6710_(null);
                    this.target.m_6703_(null);
                    if (this.target instanceof NeutralMob) {
                        ((NeutralMob)this.target).m_21662_();
                        ((NeutralMob)this.target).m_6703_(null);
                        ((NeutralMob)this.target).m_6710_(null);
                        ((NeutralMob)this.target).m_6925_(null);
                    }
                }
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.cooldown = 200 + this.mob.f_19796_.m_188503_(100);
        }

        public boolean animationsUseable() {
            return this.mob.blindAnimationTick <= 0;
        }
    }

    class ShootAttackGoal
    extends Goal {
        public DungeonsIllusionerEntity mob;
        @Nullable
        public LivingEntity target;
        public int cooldown;

        public ShootAttackGoal(DungeonsIllusionerEntity mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return this.mob.shouldBeStationary();
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            if (this.cooldown > 0) {
                --this.cooldown;
            }
            return this.target != null && (double)this.mob.m_20270_((Entity)this.target) <= 12.5 && this.cooldown <= 0 && this.mob.m_142582_((Entity)this.target) && this.animationsUseable();
        }

        public boolean m_8045_() {
            return this.target != null && !this.animationsUseable();
        }

        public void m_8056_() {
            this.mob.shootAnimationTick = this.mob.shootAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)4);
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            this.mob.m_21573_().m_26573_();
            if (this.target != null) {
                this.mob.m_21563_().m_24946_(this.target.m_20185_(), this.target.m_20188_(), this.target.m_20189_());
            }
            if (this.target != null && this.mob.shootAnimationTick == this.mob.shootAnimationActionPoint) {
                this.mob.shootRocket(this.target);
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.cooldown = 60 + this.mob.f_19796_.m_188503_(40);
        }

        public boolean animationsUseable() {
            return this.mob.shootAnimationTick <= 0;
        }
    }
}

