/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.illagers;

import com.infamous.dungeons_libraries.entities.SpawnArmoredMob;
import com.infamous.dungeons_libraries.items.gearconfig.ArmorSet;
import com.infamous.dungeons_mobs.entities.SpawnEquipmentHelper;
import com.infamous.dungeons_mobs.entities.summonables.IceCloudEntity;
import com.infamous.dungeons_mobs.goals.ApproachTargetGoal;
import com.infamous.dungeons_mobs.goals.LookAtTargetGoal;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModItems;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class IceologerEntity
extends AbstractIllager
implements IAnimatable,
SpawnArmoredMob {
    public int summonAnimationTick;
    public int summonAnimationLength = 60;
    public int summonAnimationActionPoint = 40;
    AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public IceologerEntity(Level world) {
        super((EntityType)ModEntityTypes.ICEOLOGER.get(), world);
    }

    public IceologerEntity(EntityType<? extends IceologerEntity> type, Level world) {
        super(type, world);
    }

    public boolean m_7490_() {
        return false;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new SummonIceChunkGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, AbstractVillager.class, 3.0f, 1.2, 1.15));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 3.0f, 1.2, 1.2));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, IronGolem.class, 3.0f, 1.3, 1.15));
        this.f_21345_.m_25352_(2, (Goal)new ApproachTargetGoal((PathfinderMob)this, 10.0, 1.0, true));
        this.f_21345_.m_25352_(3, (Goal)new LookAtTargetGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(600));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).m_26146_(600));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false).m_26146_(600));
    }

    public void m_7822_(byte p_28844_) {
        if (p_28844_ == 4) {
            this.summonAnimationTick = this.summonAnimationLength;
        } else {
            super.m_7822_(p_28844_);
        }
    }

    public void m_6075_() {
        super.m_6075_();
        this.tickDownAnimTimers();
    }

    public void tickDownAnimTimers() {
        if (this.summonAnimationTick > 0) {
            --this.summonAnimationTick;
        }
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.summonAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("iceologer_summon", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("iceologer_walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.m_37888_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("iceologer_celebrate", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("iceologer_idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected void m_213945_(RandomSource random, DifficultyInstance p_180481_1_) {
        super.m_213945_(random, p_180481_1_);
        SpawnEquipmentHelper.equipArmorSet(ModItems.ICEOLOGER_ARMOR, (Mob)this);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_213386_1_, DifficultyInstance p_213386_2_, MobSpawnType p_213386_3_, @Nullable SpawnGroupData p_213386_4_, @Nullable CompoundTag p_213386_5_) {
        SpawnGroupData iLivingEntityData = super.m_6518_(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
        this.m_213945_(this.m_217043_(), p_213386_2_);
        this.m_213946_(this.m_217043_(), p_213386_2_);
        return iLivingEntityData;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 18.0).m_22268_(Attributes.f_22276_, 20.0);
    }

    public boolean m_7307_(Entity entityIn) {
        if (super.m_7307_(entityIn)) {
            return true;
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        return false;
    }

    public void m_7895_(int p_213660_1_, boolean p_213660_2_) {
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.ICEOLOGER_IDLE.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.ICEOLOGER_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.ICEOLOGER_HURT.get();
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)ModSoundEvents.ICEOLOGER_ATTACK.get();
    }

    public ArmorSet getArmorSet() {
        return ModItems.ICEOLOGER_ARMOR;
    }

    class SummonIceChunkGoal
    extends Goal {
        public IceologerEntity mob;
        @Nullable
        public LivingEntity target;
        private final Predicate<Entity> ICE_CHUNK = p_33346_ -> p_33346_ instanceof IceCloudEntity && ((IceCloudEntity)p_33346_).owner != null && ((IceCloudEntity)p_33346_).owner == this.mob;

        public SummonIceChunkGoal(IceologerEntity mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            int nearbyChunks = this.mob.f_19853_.m_6249_((Entity)this.mob, this.mob.m_20191_().m_82400_(20.0), this.ICE_CHUNK).size();
            return this.target != null && this.mob.f_19796_.m_188503_(20) == 0 && this.mob.m_20270_((Entity)this.target) <= 12.0f && nearbyChunks <= 0 && this.mob.m_142582_((Entity)this.target) && this.animationsUseable();
        }

        public boolean m_8045_() {
            return this.target != null && !this.animationsUseable();
        }

        public void m_8056_() {
            this.mob.m_5496_((SoundEvent)ModSoundEvents.ICEOLOGER_ATTACK.get(), 1.0f, this.mob.m_6100_());
            this.mob.summonAnimationTick = this.mob.summonAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)4);
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            if (this.target != null) {
                this.mob.m_21563_().m_24946_(this.target.m_20185_(), this.target.m_20188_(), this.target.m_20189_());
            }
            if (this.target != null && this.mob.summonAnimationTick == this.mob.summonAnimationActionPoint) {
                IceCloudEntity.spawn((Entity)this.mob, this.target);
            }
        }

        public boolean animationsUseable() {
            return this.mob.summonAnimationTick <= 0;
        }
    }
}

