/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.illagers;

import com.google.common.collect.Maps;
import com.infamous.dungeons_libraries.entities.SpawnArmoredMob;
import com.infamous.dungeons_libraries.items.gearconfig.ArmorSet;
import com.infamous.dungeons_libraries.utils.GoalUtils;
import com.infamous.dungeons_mobs.entities.AnimatableMeleeAttackMob;
import com.infamous.dungeons_mobs.entities.SpawnEquipmentHelper;
import com.infamous.dungeons_mobs.entities.illagers.IllagerArmsUtil;
import com.infamous.dungeons_mobs.goals.ApproachTargetGoal;
import com.infamous.dungeons_mobs.goals.BasicModdedAttackGoal;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModItems;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class MountaineerEntity
extends Vindicator
implements SpawnArmoredMob,
IAnimatable,
AnimatableMeleeAttackMob {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(MountaineerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public int attackAnimationTick;
    public int attackAnimationLength = 7;
    public int attackAnimationActionPoint = 6;
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public MountaineerEntity(Level worldIn) {
        super((EntityType)ModEntityTypes.MOUNTAINEER.get(), worldIn);
    }

    public MountaineerEntity(EntityType<? extends MountaineerEntity> entityType, Level world) {
        super(entityType, world);
    }

    protected void m_8099_() {
        super.m_8099_();
        GoalUtils.removeGoal((GoalSelector)this.f_21345_, MeleeAttackGoal.class);
        this.f_21345_.m_25352_(4, new BasicModdedAttackGoal<MountaineerEntity>(this, null, 20));
        this.f_21345_.m_25352_(5, (Goal)new ApproachTargetGoal((PathfinderMob)this, 0.0, 1.0, true));
    }

    protected PathNavigation m_6037_(Level p_175447_1_) {
        return new WallClimberNavigation((Mob)this, p_175447_1_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            this.setClimbing(this.f_19862_);
        }
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    public boolean isClimbing() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean p_70839_1_) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        b0 = p_70839_1_ ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)b0);
    }

    protected float m_6121_() {
        return 0.5f;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.MOUNTAINEER_IDLE.get();
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)ModSoundEvents.MOUNTAINEER_IDLE.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.MOUNTAINEER_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return (SoundEvent)ModSoundEvents.MOUNTAINEER_HURT.get();
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22276_, 28.0).m_22268_(Attributes.f_22281_, 6.0);
    }

    protected void m_213945_(RandomSource random, DifficultyInstance difficulty) {
        SpawnEquipmentHelper.equipMainhand(((Item)ModItems.MOUNTAINEER_AXE.get()).m_7968_(), (Mob)this);
        SpawnEquipmentHelper.equipArmorSet(ModItems.MOUNTAINEER_ARMOR, (Mob)this);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_213386_1_, DifficultyInstance p_213386_2_, MobSpawnType p_213386_3_, @Nullable SpawnGroupData p_213386_4_, @Nullable CompoundTag p_213386_5_) {
        SpawnGroupData iLivingEntityData = super.m_6518_(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
        this.m_213945_(this.m_217043_(), p_213386_2_);
        this.m_213946_(this.m_217043_(), p_213386_2_);
        return iLivingEntityData;
    }

    public void m_7895_(int waveNumber, boolean bool) {
        ItemStack itemStack = new ItemStack((ItemLike)ModItems.MOUNTAINEER_AXE.get());
        Raid raid = this.m_37885_();
        int i = 1;
        if (raid != null && waveNumber > raid.m_37724_(Difficulty.NORMAL)) {
            i = 2;
        }
        boolean flag = false;
        if (raid != null) {
            boolean bl = flag = this.f_19796_.m_188501_() <= raid.m_37783_();
        }
        if (flag) {
            HashMap map = Maps.newHashMap();
            map.put(Enchantments.f_44977_, i);
            EnchantmentHelper.m_44865_((Map)map, (ItemStack)itemStack);
        }
        SpawnEquipmentHelper.equipMainhand(itemStack, (Mob)this);
    }

    public AbstractIllager.IllagerArmPose m_6768_() {
        AbstractIllager.IllagerArmPose illagerArmPose = super.m_6768_();
        if (illagerArmPose == AbstractIllager.IllagerArmPose.CROSSED) {
            return AbstractIllager.IllagerArmPose.NEUTRAL;
        }
        return illagerArmPose;
    }

    public boolean m_7490_() {
        return false;
    }

    public ArmorSet getArmorSet() {
        return ModItems.MOUNTAINEER_ARMOR;
    }

    public void m_7822_(byte p_28844_) {
        if (p_28844_ == 4) {
            this.attackAnimationTick = this.attackAnimationLength;
        } else {
            super.m_7822_(p_28844_);
        }
    }

    @Override
    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    @Override
    public void setAttackAnimationTick(int attackAnimationTick) {
        this.attackAnimationTick = attackAnimationTick;
    }

    @Override
    public int getAttackAnimationLength() {
        return this.attackAnimationLength;
    }

    @Override
    public int getAttackAnimationActionPoint() {
        return this.attackAnimationActionPoint;
    }

    public void m_6075_() {
        super.m_6075_();
        this.tickDownAnimTimers();
    }

    public void tickDownAnimTimers() {
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        String animation = "animation.vindicator";
        Object handSide = "_right";
        if (this.m_21526_()) {
            handSide = "_left";
        }
        if (this.m_21205_().m_41619_()) {
            handSide = (String)handSide + "_both";
        }
        String crossed = "";
        if (IllagerArmsUtil.armorHasCrossedArms((AbstractIllager)this, this.m_6844_(EquipmentSlot.CHEST))) {
            crossed = "_crossed";
        }
        if (this.attackAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(animation + ".attack" + (String)handSide, (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (!(!this.m_5912_() || event.getLimbSwingAmount() > -0.15f && event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(animation + ".run" + (String)handSide, (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(animation + ".walk" + crossed, (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.m_37888_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(animation + ".win", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(animation + ".idle" + crossed, (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

