/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.illagers;

import com.infamous.dungeons_libraries.entities.SpawnArmoredMob;
import com.infamous.dungeons_libraries.items.gearconfig.ArmorSet;
import com.infamous.dungeons_mobs.client.particle.ModParticleTypes;
import com.infamous.dungeons_mobs.entities.SpawnEquipmentHelper;
import com.infamous.dungeons_mobs.entities.projectiles.WindcallerBlastProjectileEntity;
import com.infamous.dungeons_mobs.entities.summonables.WindcallerTornadoEntity;
import com.infamous.dungeons_mobs.goals.ApproachTargetGoal;
import com.infamous.dungeons_mobs.goals.LookAtTargetGoal;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModItems;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class WindcallerEntity
extends AbstractIllager
implements IAnimatable,
SpawnArmoredMob {
    public int liftAttackAnimationTick;
    public int liftAttackAnimationLength = 25;
    public int liftAttackAnimationActionPoint = 15;
    public int blastAttackAnimationTick;
    public int blastAttackAnimationLength = 32;
    public int blastAttackAnimationActionPoint = 20;
    AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public int soundLoopTick;

    public WindcallerEntity(Level world) {
        super((EntityType)ModEntityTypes.WINDCALLER.get(), world);
    }

    public WindcallerEntity(EntityType<? extends WindcallerEntity> type, Level world) {
        super(type, world);
    }

    public boolean m_7490_() {
        return false;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new BlastAttackGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new LiftAttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, IronGolem.class, 5.0f, 1.2, 1.15));
        this.f_21345_.m_25352_(3, (Goal)new ApproachTargetGoal((PathfinderMob)this, 6.0, 1.1, true));
        this.f_21345_.m_25352_(4, (Goal)new LookAtTargetGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(600));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).m_26146_(600));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false).m_26146_(600));
    }

    public void m_7822_(byte p_28844_) {
        if (p_28844_ == 4) {
            this.liftAttackAnimationTick = this.liftAttackAnimationLength;
        } else if (p_28844_ == 11) {
            this.blastAttackAnimationTick = this.blastAttackAnimationLength;
        } else {
            super.m_7822_(p_28844_);
        }
    }

    boolean steepDropBelow() {
        boolean blockBeneath = false;
        for (int i = 0; i < 4; ++i) {
            if (this.f_19853_.m_8055_(new BlockPos(this.m_20183_().m_123341_(), this.m_20183_().m_123342_() - i, this.m_20183_().m_123343_())).m_60795_()) continue;
            blockBeneath = true;
        }
        return !this.f_19853_.f_46443_ && !blockBeneath;
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    public void m_6075_() {
        super.m_6075_();
        this.tickDownAnimTimers();
        if (this.m_5448_() != null && this.m_20270_((Entity)this.m_5448_()) > 4.0f && (!this.m_20096_() && this.steepDropBelow() || (this.m_5448_().m_20186_() > this.m_20186_() + 4.0 || this.m_20186_() < this.m_5448_().m_20186_() - 2.0) && this.m_20270_((Entity)this.m_5448_()) > 4.0f || this.m_20270_((Entity)this.m_5448_()) > 10.0f)) {
            if (this.m_20186_() < this.m_5448_().m_20186_() + 4.0) {
                this.m_20334_(0.0, 0.05, 0.0);
            } else {
                this.m_20334_(0.0, -0.01, 0.0);
            }
            double x = this.m_5448_().m_20185_() - this.m_20185_();
            double y = this.m_5448_().m_20186_() - this.m_20186_();
            double z = this.m_5448_().m_20189_() - this.m_20189_();
            double d = Math.sqrt(x * x + y * y + z * z);
            this.m_20256_(this.m_20184_().m_82520_(x / d * (double)0.2f, y / d * (double)0.2f, z / d * (double)0.2f).m_82490_(1.5));
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_21573_().m_26573_();
            this.m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3(this.m_5448_().m_20185_(), this.m_5448_().m_20188_(), this.m_5448_().m_20189_()));
        }
        ++this.soundLoopTick;
        if (this.soundLoopTick % 40 == 0) {
            this.m_5496_((SoundEvent)ModSoundEvents.WINDCALLER_FLY_LOOP.get(), 0.75f, 1.0f);
        }
    }

    public void m_8107_() {
        if (!this.f_19861_ && this.m_20184_().f_82480_ < 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.5, 1.0));
        }
        if (this.f_19853_.f_46443_) {
            this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.WIND.get(), this.m_20208_(0.1), this.m_20186_() + 0.05, this.m_20262_(0.1), (this.f_19796_.m_188500_() - 0.5) * 1.0, 0.0, (this.f_19796_.m_188500_() - 0.5) * 1.0);
        }
        super.m_8107_();
    }

    public void tickDownAnimTimers() {
        if (this.liftAttackAnimationTick > 0) {
            --this.liftAttackAnimationTick;
        }
        if (this.blastAttackAnimationTick > 0) {
            --this.blastAttackAnimationTick;
        }
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.liftAttackAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("windcaller_lift", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.blastAttackAnimationTick > 10) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("windcaller_blast", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("windcaller_fly", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.m_37888_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("windcaller_celebrate", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("windcaller_idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected void m_213945_(RandomSource random, DifficultyInstance p_180481_1_) {
        super.m_213945_(random, p_180481_1_);
        SpawnEquipmentHelper.equipMainhand(((Item)ModItems.WINDCALLER_STAFF.get()).m_7968_(), (Mob)this);
        SpawnEquipmentHelper.equipArmorSet(ModItems.WINDCALLER_ARMOR, (Mob)this);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_213386_1_, DifficultyInstance p_213386_2_, MobSpawnType p_213386_3_, @Nullable SpawnGroupData p_213386_4_, @Nullable CompoundTag p_213386_5_) {
        SpawnGroupData iLivingEntityData = super.m_6518_(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
        this.m_213945_(this.m_217043_(), p_213386_2_);
        this.m_213946_(this.m_217043_(), p_213386_2_);
        return iLivingEntityData;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22276_, 30.0);
    }

    public boolean m_7307_(Entity entityIn) {
        if (super.m_7307_(entityIn)) {
            return true;
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        return false;
    }

    public void m_7895_(int p_213660_1_, boolean p_213660_2_) {
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.WINDCALLER_IDLE.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.WINDCALLER_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.WINDCALLER_HURT.get();
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)ModSoundEvents.WINDCALLER_BLAST_VOCAL.get();
    }

    public ArmorSet getArmorSet() {
        return ModItems.WINDCALLER_ARMOR;
    }

    class BlastAttackGoal
    extends Goal {
        public WindcallerEntity mob;
        @Nullable
        public LivingEntity target;
        private final Predicate<Entity> TORNADO = p_33346_ -> p_33346_ instanceof WindcallerTornadoEntity;

        public BlastAttackGoal(WindcallerEntity mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            int nearbyTornadoes = 1;
            if (this.target != null) {
                nearbyTornadoes = this.mob.f_19853_.m_6249_((Entity)this.mob, this.target.m_20191_().m_82400_(5.0), this.TORNADO).size();
            }
            return this.target != null && this.mob.f_19796_.m_188503_(5) == 0 && (this.mob.m_20270_((Entity)this.target) <= 4.0f || !this.target.m_20096_() && this.mob.f_19796_.m_188503_(10) == 0 && (double)this.mob.m_20270_((Entity)this.target) < 7.5) && nearbyTornadoes <= 0 && this.mob.m_142582_((Entity)this.target) && this.animationsUseable();
        }

        public boolean m_8045_() {
            return this.target != null && !this.animationsUseable();
        }

        public void m_8056_() {
            this.mob.m_5496_((SoundEvent)ModSoundEvents.WINDCALLER_BLAST_VOCAL.get(), 1.0f, this.mob.m_6100_());
            this.mob.blastAttackAnimationTick = this.mob.blastAttackAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)11);
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            if (this.target != null) {
                this.mob.m_21563_().m_24946_(this.target.m_20185_(), this.target.m_20188_(), this.target.m_20189_());
            }
            if (this.target != null && this.mob.blastAttackAnimationTick == this.mob.blastAttackAnimationActionPoint) {
                double d1 = this.target.m_20185_() - this.mob.m_20185_();
                double d2 = this.target.m_20227_(0.5) - this.mob.m_20227_(0.5);
                double d3 = this.target.m_20189_() - this.mob.m_20189_();
                WindcallerBlastProjectileEntity smallfireballentity = new WindcallerBlastProjectileEntity(this.mob.f_19853_, (LivingEntity)this.mob, d1, 0.0, d3);
                smallfireballentity.m_6034_(this.mob.m_20185_(), this.mob.m_20227_(0.25), this.mob.m_20189_());
                this.mob.f_19853_.m_7967_((Entity)smallfireballentity);
                WindcallerTornadoEntity tornado = (WindcallerTornadoEntity)((EntityType)ModEntityTypes.TORNADO.get()).m_20615_(this.mob.f_19853_);
                tornado.m_20035_(this.mob.m_20183_(), 0.0f, 0.0f);
                tornado.m_5496_((SoundEvent)ModSoundEvents.WINDCALLER_BLAST_WIND.get(), 1.5f, 1.0f);
                tornado.setBlast(true);
                tornado.m_146922_(-this.mob.f_20885_ - 90.0f);
                ((ServerLevel)this.mob.f_19853_).m_47205_((Entity)tornado);
            }
        }

        public boolean animationsUseable() {
            return this.mob.blastAttackAnimationTick <= 0;
        }
    }

    class LiftAttackGoal
    extends Goal {
        public WindcallerEntity mob;
        @Nullable
        public LivingEntity target;
        private final Predicate<Entity> TORNADO = p_33346_ -> p_33346_ instanceof WindcallerTornadoEntity;

        public LiftAttackGoal(WindcallerEntity mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            int nearbyTornadoes = 1;
            if (this.target != null) {
                nearbyTornadoes = this.mob.f_19853_.m_6249_((Entity)this.mob, this.target.m_20191_().m_82400_(5.0), this.TORNADO).size();
            }
            return this.target != null && this.target.m_20096_() && this.mob.f_19796_.m_188503_(30) == 0 && this.mob.m_20270_((Entity)this.target) <= 16.0f && this.mob.m_20270_((Entity)this.target) > 3.0f && nearbyTornadoes <= 0 && this.mob.m_142582_((Entity)this.target) && this.animationsUseable();
        }

        public boolean m_8045_() {
            return this.target != null && !this.animationsUseable();
        }

        public void m_8056_() {
            this.mob.m_5496_((SoundEvent)ModSoundEvents.WINDCALLER_LIFT_VOCAL.get(), 1.0f, this.mob.m_6100_());
            this.mob.liftAttackAnimationTick = this.mob.liftAttackAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)4);
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            if (this.target != null) {
                this.mob.m_21563_().m_24946_(this.target.m_20185_(), this.target.m_20188_(), this.target.m_20189_());
            }
            if (this.target != null && this.mob.liftAttackAnimationTick == this.mob.liftAttackAnimationActionPoint) {
                WindcallerTornadoEntity tornado = (WindcallerTornadoEntity)((EntityType)ModEntityTypes.TORNADO.get()).m_20615_(this.mob.f_19853_);
                tornado.m_20035_(this.target.m_20183_(), 0.0f, 0.0f);
                tornado.m_5496_((SoundEvent)ModSoundEvents.WINDCALLER_LIFT_WIND.get(), 1.5f, 1.0f);
                ((ServerLevel)this.mob.f_19853_).m_47205_((Entity)tornado);
            }
        }

        public boolean animationsUseable() {
            return this.mob.liftAttackAnimationTick <= 0;
        }
    }
}

