/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.jungle;

import com.infamous.dungeons_mobs.entities.jungle.AbstractVineEntity;
import com.infamous.dungeons_mobs.entities.projectiles.PoisonQuillEntity;
import com.infamous.dungeons_mobs.entities.summonables.AreaDamageEntity;
import com.infamous.dungeons_mobs.goals.LookAtTargetGoal;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import com.infamous.dungeons_mobs.utils.PositionUtils;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class PoisonQuillVineEntity
extends AbstractVineEntity {
    AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public int delayedBehaviourTime;
    public int shootAnimationTick;
    public int shootAnimationLength = 18;
    public int shootAnimationActionPoint = 8;
    public boolean open;

    public PoisonQuillVineEntity(EntityType<? extends PoisonQuillVineEntity> p_i50147_1_, Level p_i50147_2_) {
        super(p_i50147_1_, p_i50147_2_);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new OpenGoal());
        this.f_21345_.m_25352_(0, (Goal)new CloseGoal());
        this.f_21345_.m_25352_(1, (Goal)new ShootAttackGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new LookAtTargetGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected float m_6431_(Pose p_213348_1_, EntityDimensions p_213348_2_) {
        return this.isOut() ? this.m_20206_() - 0.75f : super.m_6431_(p_213348_1_, p_213348_2_);
    }

    protected BodyRotationControl m_7560_() {
        return new BodyHelperController((Mob)this);
    }

    public int m_8132_() {
        return 180;
    }

    public int m_8085_() {
        return 180;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22277_, 25.0);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", (float)this.getAnimationTransitionTime(), this::predicate));
    }

    @Override
    public int getAnimationTransitionTime() {
        return 5;
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.f_20919_ > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("poison_quill_vine_retract", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.burstAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("poison_quill_vine_burst", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.retractAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("poison_quill_vine_retract", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.shootAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("poison_quill_vine_shoot", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.isOut() || this.burstAnimationTick > 0) {
            if (this.open) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("poison_quill_vine_idle_open", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("poison_quill_vine_idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("poison_quill_vine_idle_underground", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public int getBurstAnimationLength() {
        return 20;
    }

    @Override
    public int getRetractAnimationLength() {
        return 15;
    }

    @Override
    protected SoundEvent getAmbientSoundFoley() {
        return null;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.POISON_QUILL_VINE_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return (SoundEvent)ModSoundEvents.POISON_QUILL_VINE_HURT_VOCAL.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.POISON_QUILL_VINE_DEATH.get();
    }

    @Override
    protected SoundEvent getHurtSoundFoley(DamageSource p_184601_1_) {
        return (SoundEvent)ModSoundEvents.POISON_QUILL_VINE_HURT_FOLEY.get();
    }

    @Override
    public SoundEvent getBurstSound() {
        return (SoundEvent)ModSoundEvents.POISON_QUILL_VINE_BURST.get();
    }

    @Override
    public SoundEvent getRetractSound() {
        return (SoundEvent)ModSoundEvents.POISON_QUILL_VINE_BURST.get();
    }

    public SoundEvent getShootSound() {
        return (SoundEvent)ModSoundEvents.POISON_QUILL_VINE_SHOOT.get();
    }

    public SoundEvent getOpenSound() {
        return (SoundEvent)ModSoundEvents.POISON_QUILL_VINE_OPEN.get();
    }

    public SoundEvent getCloseSound() {
        return (SoundEvent)ModSoundEvents.POISON_QUILL_VINE_CLOSE.get();
    }

    @Override
    public SoundEvent getBurstSoundFoley() {
        return null;
    }

    @Override
    public SoundEvent getRetractSoundFoley() {
        return null;
    }

    @Override
    public boolean isKelp() {
        return false;
    }

    @Override
    public boolean shouldDieInWrongHabitat() {
        return true;
    }

    @Override
    public int wrongHabitatDieChance() {
        return 100;
    }

    @Override
    public int getLengthInSegments() {
        return Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(LENGTH)), (int)2, (int)26);
    }

    @Override
    public void spawnAreaDamage() {
        AreaDamageEntity areaDamage = AreaDamageEntity.spawnAreaDamage(this.f_19853_, this.m_20182_(), (LivingEntity)this, 5.0f, DamageSource.m_19370_((LivingEntity)this), 0.0f, 1.5f, 0.25f, 0.25f, 10, false, false, 0.75, 0.25, false, 0, 1);
        this.f_19853_.m_7967_((Entity)areaDamage);
    }

    @Override
    public void setDefaultFeatures() {
        this.setLengthInSegments(2 + this.f_19796_.m_188503_(3));
        this.setVanishes(false);
        this.setAlwaysOut(false);
        this.setDetectionDistance(7.5f);
    }

    @Override
    public float getExtraHitboxY() {
        return 1.625f;
    }

    @Override
    public void burst() {
        super.burst();
        this.delayedBehaviourTime = 10;
    }

    @Override
    public void retract() {
        super.retract();
        this.delayedBehaviourTime = 20;
    }

    @Override
    public void m_7822_(byte p_70103_1_) {
        if (p_70103_1_ == 7) {
            this.open = true;
        } else if (p_70103_1_ == 8) {
            this.open = false;
        } else if (p_70103_1_ == 9) {
            this.shootAnimationTick = this.shootAnimationLength;
        } else {
            super.m_7822_(p_70103_1_);
        }
    }

    @Override
    public void m_6075_() {
        super.m_6075_();
        if (this.delayedBehaviourTime > 0) {
            --this.delayedBehaviourTime;
        }
    }

    @Override
    public void tickDownAnimTimers() {
        super.tickDownAnimTimers();
        if (this.shootAnimationTick > 0) {
            --this.shootAnimationTick;
        }
    }

    public float m_20270_(Entity p_70032_1_) {
        float f = (float)(this.m_20185_() - p_70032_1_.m_20185_());
        float f1 = (float)(this.m_20188_() - p_70032_1_.m_20186_());
        float f2 = (float)(this.m_20189_() - p_70032_1_.m_20189_());
        return Mth.m_14116_((float)(f * f + f1 * f1 + f2 * f2));
    }

    class OpenGoal
    extends Goal {
        public boolean m_8036_() {
            return PoisonQuillVineEntity.this.isOut() && PoisonQuillVineEntity.this.delayedBehaviourTime <= 0 && PoisonQuillVineEntity.this.m_5448_() != null && !PoisonQuillVineEntity.this.open && PoisonQuillVineEntity.this.m_20270_((Entity)PoisonQuillVineEntity.this.m_5448_()) <= 15.0f;
        }

        public void m_8056_() {
            super.m_8056_();
            PoisonQuillVineEntity.this.open = true;
            PoisonQuillVineEntity.this.f_19853_.m_7605_((Entity)PoisonQuillVineEntity.this, (byte)7);
            PoisonQuillVineEntity.this.delayedBehaviourTime = 10;
            PoisonQuillVineEntity.this.m_5496_(PoisonQuillVineEntity.this.getOpenSound(), 1.0f, 1.0f);
        }
    }

    class CloseGoal
    extends Goal {
        public boolean m_8036_() {
            return PoisonQuillVineEntity.this.isOut() && PoisonQuillVineEntity.this.delayedBehaviourTime <= 0 && PoisonQuillVineEntity.this.open && (PoisonQuillVineEntity.this.m_5448_() == null || (double)PoisonQuillVineEntity.this.m_20270_((Entity)PoisonQuillVineEntity.this.m_5448_()) > 17.5);
        }

        public void m_8056_() {
            super.m_8056_();
            PoisonQuillVineEntity.this.open = false;
            PoisonQuillVineEntity.this.f_19853_.m_7605_((Entity)PoisonQuillVineEntity.this, (byte)8);
            PoisonQuillVineEntity.this.delayedBehaviourTime = 40;
            PoisonQuillVineEntity.this.m_5496_(PoisonQuillVineEntity.this.getCloseSound(), 1.0f, 1.0f);
        }
    }

    class ShootAttackGoal
    extends Goal {
        public PoisonQuillVineEntity mob;
        @Nullable
        public LivingEntity target;

        public ShootAttackGoal(PoisonQuillVineEntity mob) {
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.mob.open && this.mob.delayedBehaviourTime <= 0 && this.target != null && (double)this.mob.m_20270_((Entity)this.target) <= 12.5 && this.mob.m_142582_((Entity)this.target) && this.animationsUseable();
        }

        public boolean m_8045_() {
            return this.mob.open && this.mob.delayedBehaviourTime <= 0 && this.target != null && !this.animationsUseable();
        }

        public void m_8056_() {
            this.mob.shootAnimationTick = this.mob.shootAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)9);
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            this.mob.m_21573_().m_26573_();
            if (this.target != null && this.mob.shootAnimationTick == this.mob.shootAnimationActionPoint) {
                Vec3 pos = PositionUtils.getOffsetPos((Entity)this.mob, 0.0, this.mob.m_6431_(this.mob.m_20089_(), this.mob.m_6972_(this.mob.m_20089_())), 1.0, PoisonQuillVineEntity.this.f_20885_);
                double d1 = this.target.m_20185_() - pos.f_82479_;
                double d2 = this.target.m_20227_(0.6) - pos.f_82480_;
                double d3 = this.target.m_20189_() - pos.f_82481_;
                PoisonQuillEntity poisonQuill = new PoisonQuillEntity(this.mob.f_19853_, (LivingEntity)this.mob, d1, d2, d3);
                poisonQuill.setKelp(this.mob.isKelp());
                poisonQuill.rotateToMatchMovement();
                poisonQuill.m_6027_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
                this.mob.f_19853_.m_7967_((Entity)poisonQuill);
                this.mob.m_5496_(this.mob.getShootSound(), 1.25f, 1.0f);
            }
        }

        public boolean animationsUseable() {
            return this.mob.shootAnimationTick <= 0;
        }
    }

    class BodyHelperController
    extends BodyRotationControl {
        public BodyHelperController(Mob p_i50612_2_) {
            super(p_i50612_2_);
        }

        public void m_8121_() {
        }
    }
}

