/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.piglin;

import com.infamous.dungeons_mobs.entities.SpawnEquipmentHelper;
import com.infamous.dungeons_mobs.entities.piglin.ai.FungusThrowerAi;
import com.infamous.dungeons_mobs.interfaces.ISmartCrossbowUser;
import com.infamous.dungeons_mobs.items.BlueNethershroomItem;
import com.infamous.dungeons_mobs.mixin.PiglinAccessor;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModItems;
import com.infamous.dungeons_mobs.utils.PiglinHelper;
import com.mojang.serialization.Dynamic;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;

public class FungusThrowerEntity
extends Piglin {
    public FungusThrowerEntity(EntityType<? extends FungusThrowerEntity> entityType, Level world) {
        super(entityType, world);
    }

    public static boolean checkFungusThrowerSpawnRules(EntityType<? extends Piglin> p_234418_0_, LevelAccessor p_234418_1_, MobSpawnType p_234418_2_, BlockPos p_234418_3_, RandomSource p_234418_4_) {
        return !p_234418_1_.m_8055_(p_234418_3_.m_7495_()).m_204336_(BlockTags.f_13078_);
    }

    public boolean m_5886_(ProjectileWeaponItem shootableItem) {
        return super.m_5886_(shootableItem) || shootableItem instanceof BlueNethershroomItem;
    }

    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        Brain brain = super.m_8075_(dynamic);
        FungusThrowerAi.addFungusThrowerTasks(brain);
        return brain;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverWorld, DifficultyInstance difficultyInstance, MobSpawnType spawnReason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag compoundNBT) {
        SpawnGroupData spawnData = super.m_6518_(serverWorld, difficultyInstance, spawnReason, spawnDataIn, compoundNBT);
        if (this instanceof ISmartCrossbowUser && ((ISmartCrossbowUser)((Object)this)).isCrossbowUser()) {
            ((ISmartCrossbowUser)((Object)this)).setCrossbowUser(false);
        }
        if (spawnReason != MobSpawnType.STRUCTURE && this.m_34667_()) {
            SpawnEquipmentHelper.equipMainhand(((Item)ModItems.BLUE_NETHERSHROOM.get()).m_7968_(), (Mob)this);
        }
        return spawnData;
    }

    protected void m_8063_(ServerLevel serverWorld) {
        PiglinHelper.stopAdmiringItem(this);
        ((PiglinAccessor)((Object)this)).getInventory().m_19195_().forEach(arg_0 -> ((FungusThrowerEntity)this).m_19983_(arg_0));
        PiglinHelper.zombify((EntityType)ModEntityTypes.ZOMBIFIED_FUNGUS_THROWER.get(), this);
    }

    protected void m_213945_(RandomSource random, DifficultyInstance p_180481_1_) {
    }

    protected void m_213946_(RandomSource randomSource, DifficultyInstance p_180483_1_) {
    }

    protected boolean m_7808_(ItemStack replacement, ItemStack current) {
        boolean canReplaceCurrentItem = super.m_7808_(replacement, current);
        boolean takeReplacement = FungusThrowerAi.isBlueNethershroom(replacement);
        boolean keepCurrent = FungusThrowerAi.isBlueNethershroom(current);
        if (takeReplacement && !keepCurrent) {
            return true;
        }
        if (!takeReplacement && keepCurrent) {
            return canReplaceCurrentItem;
        }
        return (!this.m_34667_() || !FungusThrowerAi.isBlueNethershroom(replacement) || !FungusThrowerAi.isBlueNethershroom(current)) && canReplaceCurrentItem;
    }
}

