/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.piglin.ai;

import com.google.common.collect.ImmutableList;
import com.infamous.dungeons_mobs.entities.piglin.FungusThrowerEntity;
import com.infamous.dungeons_mobs.entities.projectiles.BlueNethershroomEntity;
import com.infamous.dungeons_mobs.items.BlueNethershroomItem;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import com.infamous.dungeons_mobs.tasks.ThrowAtTargetTask;
import com.infamous.dungeons_mobs.utils.BrainHelper;
import java.util.function.Predicate;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BackUpIfTooClose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.RunIf;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class FungusThrowerAi {
    public static final Predicate<Item> FUNGUS_ITEM_PREDICATE = item -> item instanceof BlueNethershroomItem;
    public static final Predicate<ItemStack> FUNGUS_ITEM_STACK_PREDICATE = itemStack -> itemStack.m_41720_() instanceof BlueNethershroomItem;

    public static <E extends FungusThrowerEntity> void addFungusThrowerTasks(Brain<E> brain) {
        ImmutableList additionalFightTasks = ImmutableList.of((Object)new RunIf(FungusThrowerAi::hasBlueNethershroom, (Behavior)new BackUpIfTooClose(6, 0.75f)), new ThrowAtTargetTask<FungusThrowerEntity>(FUNGUS_ITEM_STACK_PREDICATE, FungusThrowerAi::performFungusThrow));
        int priorityStart = 7;
        ImmutableList prioritizedFightTasks = BrainHelper.createPriorityPairs(priorityStart, additionalFightTasks);
        BrainHelper.addPrioritizedBehaviors(Activity.f_37988_, prioritizedFightTasks, brain);
    }

    public static void performFungusThrow(LivingEntity fungusThrower, LivingEntity attackTarget) {
        Vec3 targetDeltaMove = attackTarget.m_20184_();
        double xDiff = attackTarget.m_20185_() + targetDeltaMove.f_82479_ - fungusThrower.m_20185_();
        double yDiff = attackTarget.m_20186_() - fungusThrower.m_20186_();
        double zDiff = attackTarget.m_20189_() + targetDeltaMove.f_82481_ - fungusThrower.m_20189_();
        float horizDistSq = Mth.m_14116_((float)((float)(xDiff * xDiff + zDiff * zDiff)));
        InteractionHand weaponHoldingHand = ProjectileUtil.getWeaponHoldingHand((LivingEntity)fungusThrower, FUNGUS_ITEM_PREDICATE);
        ItemStack fungusStack = fungusThrower.m_21120_(weaponHoldingHand);
        BlueNethershroomEntity blueNethershroom = BlueNethershroomItem.createBlueNethershroom(fungusThrower.f_19853_, fungusThrower, fungusStack.m_41777_());
        blueNethershroom.m_146926_(blueNethershroom.m_146909_() + 20.0f);
        blueNethershroom.m_6686_(xDiff, yDiff + (double)(horizDistSq * 0.2f), zDiff, 0.75f, 8.0f);
        if (!fungusThrower.m_20067_()) {
            fungusThrower.f_19853_.m_6263_(null, fungusThrower.m_20185_(), fungusThrower.m_20186_(), fungusThrower.m_20189_(), (SoundEvent)ModSoundEvents.FUNGUS_THROWER_THROW.get(), fungusThrower.m_5720_(), 1.0f, (fungusThrower.m_217043_().m_188501_() - fungusThrower.m_217043_().m_188501_()) * 0.2f + 1.0f);
        }
        fungusThrower.f_19853_.m_7967_((Entity)blueNethershroom);
        fungusThrower.m_6674_(weaponHoldingHand);
    }

    private static boolean hasBlueNethershroom(LivingEntity living) {
        return living.m_21093_(FUNGUS_ITEM_STACK_PREDICATE);
    }

    public static boolean isBlueNethershroom(ItemStack itemStack) {
        return FUNGUS_ITEM_PREDICATE.test(itemStack.m_41720_());
    }
}

