/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.projectiles;

import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModItems;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class BlueNethershroomEntity
extends ThrowableItemProjectile
implements ItemSupplier {
    public static final int LIGHT_BLUE_HEX_COLOR_CODE = 57599;

    public BlueNethershroomEntity(EntityType<? extends BlueNethershroomEntity> entityType, Level world) {
        super(entityType, world);
    }

    public BlueNethershroomEntity(Level world, LivingEntity shooter) {
        super((EntityType)ModEntityTypes.BLUE_NETHERSHROOM.get(), shooter, world);
    }

    public BlueNethershroomEntity(Level world, double x, double y, double z) {
        super((EntityType)ModEntityTypes.BLUE_NETHERSHROOM.get(), x, y, z, world);
    }

    protected Item m_7881_() {
        return (Item)ModItems.BLUE_NETHERSHROOM.get();
    }

    protected float m_7139_() {
        return 0.05f;
    }

    protected void m_6532_(HitResult rtr) {
        super.m_6532_(rtr);
        ItemStack itemstack = this.m_7846_();
        List list = PotionUtils.m_43547_((ItemStack)itemstack);
        if (!list.isEmpty() && !this.f_19853_.f_46443_) {
            Entity target = null;
            if (rtr instanceof EntityHitResult) {
                EntityHitResult entityHitResult = (EntityHitResult)rtr;
                target = entityHitResult.m_82443_();
            }
            this.makeAreaOfEffectCloud(target, itemstack);
            this.m_146870_();
            BlockPos blockPos = this.m_20183_();
            Vec3 vec3 = Vec3.m_82539_((Vec3i)blockPos);
            this.f_19853_.m_6263_(null, vec3.f_82479_ + 0.5, vec3.m_7098_() + 0.5, vec3.m_7094_() + 0.5, (SoundEvent)ModSoundEvents.FUNGUS_THROWER_FUNGUS_LAND.get(), SoundSource.NEUTRAL, 1.0f, this.f_19853_.f_46441_.m_188501_() * 0.1f + 0.9f);
        }
    }

    private void makeAreaOfEffectCloud(@Nullable Entity target, ItemStack itemStack) {
        AreaEffectCloud aoeCloud = new AreaEffectCloud(this.f_19853_, target != null ? target.m_20185_() : this.m_20185_(), target != null ? target.m_20186_() : this.m_20186_(), target != null ? target.m_20189_() : this.m_20189_());
        Entity owner = this.m_37282_();
        if (owner instanceof LivingEntity) {
            aoeCloud.m_19718_((LivingEntity)owner);
        }
        aoeCloud.m_19712_(3.0f);
        aoeCloud.m_19732_(-0.5f);
        aoeCloud.m_19740_(10);
        aoeCloud.m_19738_(-aoeCloud.m_19743_() / (float)aoeCloud.m_19748_());
        for (MobEffectInstance customEffects : PotionUtils.m_43571_((ItemStack)itemStack)) {
            aoeCloud.m_19716_(new MobEffectInstance(customEffects));
        }
        this.f_19853_.m_7967_((Entity)aoeCloud);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

