/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.projectiles;

import com.infamous.dungeons_mobs.client.particle.ModParticleTypes;
import com.infamous.dungeons_mobs.entities.projectiles.StraightMovingProjectileEntity;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class NecromancerOrbEntity
extends StraightMovingProjectileEntity
implements IAnimatable {
    private static final EntityDataAccessor<Boolean> DELAYED_FORM = SynchedEntityData.m_135353_(NecromancerOrbEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int formAnimationTick;
    public int formAnimationLength = 20;
    public int vanishAnimationTick;
    public int textureChange = 0;
    AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public NecromancerOrbEntity(Level worldIn) {
        super((EntityType<? extends StraightMovingProjectileEntity>)((EntityType)ModEntityTypes.NECROMANCER_ORB.get()), worldIn);
    }

    public NecromancerOrbEntity(EntityType<? extends NecromancerOrbEntity> p_i50147_1_, Level p_i50147_2_) {
        super(p_i50147_1_, p_i50147_2_);
    }

    public NecromancerOrbEntity(Level p_i1794_1_, LivingEntity p_i1794_2_, double p_i1794_3_, double p_i1794_5_, double p_i1794_7_) {
        super((EntityType<? extends StraightMovingProjectileEntity>)((EntityType)ModEntityTypes.NECROMANCER_ORB.get()), p_i1794_2_, p_i1794_3_, p_i1794_5_, p_i1794_7_, p_i1794_1_);
    }

    public NecromancerOrbEntity(EntityType<? extends NecromancerOrbEntity> necromancerOrbEntityType, Level p_i1795_1_, double p_i1795_2_, double p_i1795_4_, double p_i1795_6_, double p_i1795_8_, double p_i1795_10_, double p_i1795_12_) {
        super(necromancerOrbEntityType, p_i1795_2_, p_i1795_4_, p_i1795_6_, p_i1795_8_, p_i1795_10_, p_i1795_12_, p_i1795_1_);
    }

    public NecromancerOrbEntity(Level p_i1795_1_, double p_i1795_2_, double p_i1795_4_, double p_i1795_6_, double p_i1795_8_, double p_i1795_10_, double p_i1795_12_) {
        super((EntityType<? extends StraightMovingProjectileEntity>)((EntityType)ModEntityTypes.NECROMANCER_ORB.get()), p_i1795_2_, p_i1795_4_, p_i1795_6_, p_i1795_8_, p_i1795_10_, p_i1795_12_, p_i1795_1_);
    }

    public NecromancerOrbEntity(EntityType<? extends NecromancerOrbEntity> necromancerOrbEntityType, LivingEntity p_i1794_2_, double p_i1794_3_, double p_i1794_5_, double p_i1794_7_, Level p_i1794_1_) {
        super(necromancerOrbEntityType, p_i1794_2_, p_i1794_3_, p_i1794_5_, p_i1794_7_, p_i1794_1_);
    }

    public void m_7822_(byte p_28844_) {
        if (p_28844_ == 1) {
            this.vanishAnimationTick = this.getVanishAnimationLength();
        } else if (p_28844_ == 2) {
            this.formAnimationTick = this.formAnimationLength;
        } else {
            super.m_7822_(p_28844_);
        }
    }

    @Override
    protected ParticleOptions getTrailParticle() {
        if (this.m_6095_().equals(ModEntityTypes.BLASTLING_BULLET.get())) {
            return null;
        }
        return (ParticleOptions)ModParticleTypes.NECROMANCY.get();
    }

    @Override
    public double getSpawnParticlesY() {
        return 0.2;
    }

    @Override
    public boolean shouldSpawnParticles() {
        return this.vanishAnimationTick <= 0;
    }

    @Override
    protected float getInertia() {
        return 0.8f;
    }

    public void startForming() {
        if (!this.f_19853_.f_46443_) {
            this.formAnimationTick = this.formAnimationLength;
            this.f_19853_.m_7605_((Entity)this, (byte)2);
        }
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    @Override
    public void m_6075_() {
        super.m_6075_();
        this.tickDownAnimTimers();
        if (this.f_19797_ % 5 == 0) {
            ++this.textureChange;
        }
        if (!this.f_19853_.f_46443_ && this.lifeTime >= this.vanishAfterTime() && this.vanishAnimationTick <= 0) {
            this.vanishAnimationTick = this.getVanishAnimationLength();
            this.f_19853_.m_7605_((Entity)this, (byte)1);
        }
        if (!this.f_19853_.f_46443_ && this.hasDelayedForm()) {
            this.startForming();
            this.setDelayedForm(false);
        }
        if (!this.f_19853_.f_46443_ && this.vanishAnimationTick > 0) {
            this.m_20334_(0.0, 0.0, 0.0);
        }
        if (!this.f_19853_.f_46443_ && this.vanishAnimationTick == 2) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void tickDownAnimTimers() {
        if (this.formAnimationTick > 0) {
            --this.formAnimationTick;
        }
        if (this.vanishAnimationTick > 0) {
            --this.vanishAnimationTick;
        }
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.vanishAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("necromancer_orb_vanish", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.formAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("necromancer_orb_form", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("necromancer_orb_idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DELAYED_FORM, (Object)false);
    }

    public boolean hasDelayedForm() {
        return (Boolean)this.f_19804_.m_135370_(DELAYED_FORM);
    }

    public void setDelayedForm(boolean attached) {
        this.f_19804_.m_135381_(DELAYED_FORM, (Object)attached);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public boolean m_6060_() {
        return false;
    }

    protected void m_5790_(EntityHitResult p_213868_1_) {
        super.m_5790_(p_213868_1_);
    }

    @Override
    public void onHitEntity(Entity entity) {
        if (!(entity instanceof Mob && ((Mob)entity).m_6336_() == MobType.f_21641_ || this.f_19853_.f_46443_)) {
            super.onHitEntity(entity);
            Entity entity1 = this.m_37282_();
            if (entity1 instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity1;
                boolean flag = entity.m_6469_(DamageSource.m_19367_((Entity)this, (Entity)livingentity), 6.0f);
                if (flag && entity.m_6084_()) {
                    this.m_19970_(livingentity, entity);
                }
            } else {
                boolean flag = entity.m_6469_(DamageSource.f_19319_, 6.0f);
            }
            entity.m_20201_().m_20153_();
            entity.m_20256_(entity.m_20184_().m_82549_(this.m_20184_().m_82490_(2.0)));
            this.m_5496_((SoundEvent)ModSoundEvents.NECROMANCER_ORB_IMPACT.get(), 1.0f, 1.0f);
            this.vanishAnimationTick = this.getVanishAnimationLength();
            this.f_19853_.m_7605_((Entity)this, (byte)1);
        }
    }

    @Override
    public boolean m_6087_() {
        return false;
    }

    @Override
    public boolean m_6469_(DamageSource p_70097_1_, float p_70097_2_) {
        return false;
    }

    @Override
    protected boolean shouldBurn() {
        return false;
    }

    @Override
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    public SoundEvent getImpactSound() {
        return (SoundEvent)ModSoundEvents.NECROMANCER_ORB_IMPACT.get();
    }

    @Override
    public int getVanishAnimationLength() {
        return 40;
    }
}

