/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.projectiles;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;

public abstract class StraightMovingProjectileEntity
extends Projectile {
    public double xPower;
    public double yPower;
    public double zPower;
    public boolean stuckInBlock;
    private final Predicate<Entity> CAN_HIT = entity -> this.m_5603_((Entity)entity);
    public int lifeTime;
    public float lockedXRot;
    public float lockedYRot;

    protected StraightMovingProjectileEntity(EntityType<? extends StraightMovingProjectileEntity> p_i50173_1_, Level p_i50173_2_) {
        super(p_i50173_1_, p_i50173_2_);
    }

    public StraightMovingProjectileEntity(EntityType<? extends StraightMovingProjectileEntity> p_i50174_1_, double p_i50174_2_, double p_i50174_4_, double p_i50174_6_, double p_i50174_8_, double p_i50174_10_, double p_i50174_12_, Level p_i50174_14_) {
        this(p_i50174_1_, p_i50174_14_);
        this.m_7678_(p_i50174_2_, p_i50174_4_, p_i50174_6_, this.m_146908_(), this.m_146909_());
        this.m_20090_();
        double d0 = Mth.m_14116_((float)((float)(p_i50174_8_ * p_i50174_8_ + p_i50174_10_ * p_i50174_10_ + p_i50174_12_ * p_i50174_12_)));
        if (d0 != 0.0) {
            this.xPower = p_i50174_8_ / d0 * 0.1;
            this.yPower = p_i50174_10_ / d0 * 0.1;
            this.zPower = p_i50174_12_ / d0 * 0.1;
        }
        Vec3 vec3 = new Vec3(p_i50174_8_, p_i50174_10_, p_i50174_12_).m_82541_();
        double d1 = vec3.m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d1) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    public StraightMovingProjectileEntity(EntityType<? extends StraightMovingProjectileEntity> p_i50175_1_, LivingEntity p_i50175_2_, double p_i50175_3_, double p_i50175_5_, double p_i50175_7_, Level p_i50175_9_) {
        this(p_i50175_1_, p_i50175_2_.m_20185_(), p_i50175_2_.m_20186_(), p_i50175_2_.m_20189_(), p_i50175_3_, p_i50175_5_, p_i50175_7_, p_i50175_9_);
        this.m_5602_((Entity)p_i50175_2_);
        this.m_19915_(p_i50175_2_.m_146908_(), p_i50175_2_.m_146909_());
    }

    protected void m_8097_() {
    }

    public void setPower(double powerX, double powerY, double powerZ) {
        double d0 = Mth.m_14116_((float)((float)(powerX * powerX + powerY * powerY + powerZ * powerZ)));
        if (d0 != 0.0) {
            this.xPower = powerX / d0 * 0.1;
            this.yPower = powerY / d0 * 0.1;
            this.zPower = powerZ / d0 * 0.1;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6783_(double p_70112_1_) {
        double d0 = this.m_20191_().m_82309_() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return p_70112_1_ < (d0 *= 64.0) * d0;
    }

    public void tryToDealDamage() {
        List list = this.f_19853_.m_6249_((Entity)this, this.m_20191_(), this.CAN_HIT);
        if (!list.isEmpty() && !this.f_19853_.f_46443_) {
            for (Entity entity : list) {
                this.onHitEntity(entity);
            }
        }
    }

    public void rotateToMatchMovement() {
        this.m_37283_();
    }

    public boolean shouldUpdateRotation() {
        return true;
    }

    protected void m_37283_() {
        if (this.stuckInBlock) {
            this.m_146926_(this.lockedXRot);
            this.m_146922_(this.lockedYRot);
        } else {
            super.m_37283_();
        }
    }

    public void m_6075_() {
        super.m_6075_();
        if (this.shouldUpdateRotation()) {
            this.m_37283_();
        }
        if (!this.f_19853_.f_46443_ && this.vanishesAfterTime()) {
            if (this.lifeTime < this.vanishAfterTime() + this.getVanishAnimationLength()) {
                ++this.lifeTime;
            } else {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
        if (this.f_19853_.f_46443_ && this.lifeTime < this.vanishAfterTime() + this.getVanishAnimationLength()) {
            ++this.lifeTime;
        }
        this.tryToDealDamage();
    }

    public void m_8119_() {
        Entity entity = this.m_37282_();
        if (this.stuckInBlock) {
            this.f_19794_ = false;
        }
        if (this.f_19853_.f_46443_ || (entity == null || !entity.m_213877_()) && this.f_19853_.m_46805_(this.m_20183_())) {
            HitResult raytraceresult;
            super.m_8119_();
            if (this.shouldBurn()) {
                this.m_20254_(1);
            }
            if ((raytraceresult = ProjectileUtil.m_37294_((Entity)this, this::m_5603_)).m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)raytraceresult)) {
                this.m_6532_(raytraceresult);
            }
            this.m_20101_();
            Vec3 vector3d = this.m_20184_();
            double d0 = this.m_20185_() + vector3d.f_82479_;
            double d1 = this.m_20186_() + vector3d.f_82480_;
            double d2 = this.m_20189_() + vector3d.f_82481_;
            float f = this.getInertia();
            if (this.m_20069_()) {
                for (int i = 0; i < 4; ++i) {
                    if (this.getUnderWaterTrailParticle() == null || !this.shouldSpawnParticles()) continue;
                    this.spawnUnderWaterTrailParticle();
                }
                if (this.slowedDownInWater()) {
                    f = 0.8f;
                }
            }
            this.m_20256_(vector3d.m_82520_(this.xPower, this.yPower, this.zPower).m_82490_((double)f));
            if (this.getTrailParticle() != null && this.shouldSpawnParticles()) {
                this.spawnTrailParticle();
            }
            this.m_6034_(d0, d1, d2);
        } else {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public boolean vanishesAfterTime() {
        return true;
    }

    public int vanishAfterTime() {
        return 200;
    }

    public int getVanishAnimationLength() {
        return 0;
    }

    public void onHitEntity(Entity entity) {
        this.playImpactSound();
    }

    public boolean getsStuckInBlocks() {
        return false;
    }

    public boolean keepsHittingAfterStuck() {
        return false;
    }

    public abstract SoundEvent getImpactSound();

    public void playImpactSound() {
        if (this.getImpactSound() != null) {
            this.m_5496_(this.getImpactSound(), 1.0f, 1.0f);
        }
    }

    protected void m_8060_(BlockHitResult p_230299_1_) {
        super.m_8060_(p_230299_1_);
        if (!this.stuckInBlock) {
            this.playImpactSound();
        }
        if (!this.getsStuckInBlocks()) {
            if (!this.f_19853_.f_46443_) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        } else {
            this.lockedXRot = this.m_146909_();
            this.lockedYRot = this.m_146908_();
            this.stuckInBlock = true;
            this.setPower(0.0, 0.0, 0.0);
            this.m_20334_(0.0, 0.0, 0.0);
        }
    }

    public boolean slowedDownInWater() {
        return true;
    }

    public void spawnTrailParticle() {
        this.f_19853_.m_7106_(this.getTrailParticle(), this.m_20185_(), this.m_20186_() + this.getSpawnParticlesY(), this.m_20189_(), 0.0, 0.0, 0.0);
    }

    public void spawnUnderWaterTrailParticle() {
        this.f_19853_.m_7106_(this.getUnderWaterTrailParticle(), this.m_20185_(), this.m_20186_() + this.getSpawnParticlesY(), this.m_20189_(), 0.0, 0.0, 0.0);
    }

    public double getSpawnParticlesY() {
        return 0.5;
    }

    public boolean shouldSpawnParticles() {
        return true;
    }

    protected boolean m_5603_(Entity p_230298_1_) {
        boolean foundOwnerPartInEntity = false;
        if (this.m_37282_() != null && this.m_37282_().isMultipartEntity()) {
            for (PartEntity entity : this.m_37282_().getParts()) {
                if (p_230298_1_ != entity) continue;
                foundOwnerPartInEntity = true;
            }
        }
        return super.m_5603_(p_230298_1_) && (this.keepsHittingAfterStuck() || !this.stuckInBlock) && !p_230298_1_.f_19794_ && !foundOwnerPartInEntity;
    }

    protected boolean shouldBurn() {
        return true;
    }

    protected ParticleOptions getTrailParticle() {
        return ParticleTypes.f_123762_;
    }

    protected ParticleOptions getUnderWaterTrailParticle() {
        return ParticleTypes.f_123795_;
    }

    protected float getInertia() {
        return 0.95f;
    }

    public void m_7380_(CompoundTag p_213281_1_) {
        super.m_7380_(p_213281_1_);
        p_213281_1_.m_128365_("power", (Tag)this.m_20063_(new double[]{this.xPower, this.yPower, this.zPower}));
    }

    public void m_7378_(CompoundTag p_70037_1_) {
        ListTag listnbt;
        super.m_7378_(p_70037_1_);
        if (p_70037_1_.m_128425_("power", 9) && (listnbt = p_70037_1_.m_128437_("power", 6)).size() == 3) {
            this.xPower = listnbt.m_128772_(0);
            this.yPower = listnbt.m_128772_(1);
            this.zPower = listnbt.m_128772_(2);
        }
    }

    public boolean m_6087_() {
        return true;
    }

    public float m_6143_() {
        return 1.0f;
    }

    public boolean m_6469_(DamageSource p_70097_1_, float p_70097_2_) {
        if (this.m_6673_(p_70097_1_)) {
            return false;
        }
        this.m_5834_();
        Entity entity = p_70097_1_.m_7639_();
        if (entity != null) {
            Vec3 vector3d = entity.m_20154_();
            this.m_20256_(vector3d);
            this.xPower = vector3d.f_82479_ * 0.1;
            this.yPower = vector3d.f_82480_ * 0.1;
            this.zPower = vector3d.f_82481_ * 0.1;
            this.m_5602_(entity);
            return true;
        }
        return false;
    }

    public float getBrightness() {
        return 1.0f;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

