/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.redstone;

import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import java.util.EnumSet;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class RedstoneCubeEntity
extends Monster {
    protected int rollingDuration;
    private static final EntityDataAccessor<Boolean> IS_ROLLING = SynchedEntityData.m_135353_(RedstoneCubeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public RedstoneCubeEntity(Level worldIn) {
        super((EntityType)ModEntityTypes.REDSTONE_CUBE.get(), worldIn);
    }

    public RedstoneCubeEntity(EntityType<? extends RedstoneCubeEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new MoveHelperController(this);
        this.f_19793_ = 1.0f;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 16.0).m_22268_(Attributes.f_22279_, 0.30000000447034836).m_22268_(Attributes.f_22281_, 4.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_ROLLING, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new AttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new FaceRandomGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, entity -> Math.abs(entity.m_20186_() - this.m_20186_()) <= 4.0));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public void m_7334_(Entity entityIn) {
        super.m_7334_(entityIn);
        if (entityIn instanceof IronGolem && this.canDamagePlayer()) {
            this.dealDamage((LivingEntity)((IronGolem)entityIn));
        }
    }

    public void m_6123_(Player entityIn) {
        if (this.canDamagePlayer()) {
            this.dealDamage((LivingEntity)entityIn);
        }
    }

    protected void dealDamage(LivingEntity entityIn) {
        if (this.m_6084_()) {
            int i = 2;
            if (this.m_20280_((Entity)entityIn) < 0.6 * (double)i * 0.6 * (double)i && this.m_142582_((Entity)entityIn) && entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)this), this.getAttackDamageAmount())) {
                this.m_5496_(SoundEvents.f_12446_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                this.m_19970_((LivingEntity)this, (Entity)entityIn);
            }
        }
    }

    protected float getAttackDamageAmount() {
        return (float)this.m_21133_(Attributes.f_22281_);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 0.625f * sizeIn.f_20378_;
    }

    protected boolean canDamagePlayer() {
        return this.m_6142_();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12446_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12442_;
    }

    public int m_8132_() {
        return 0;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.isRolling() && this.f_19853_.f_46443_) {
            this.f_19853_.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, this.m_20208_(0.5) + 1.0, this.m_20187_() - 0.25 + 1.0, this.m_20262_(0.5) + 1.0, (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
        }
        if (this.rollingDuration > 0) {
            --this.rollingDuration;
            this.updateRoll();
        } else {
            this.stopRolling();
        }
    }

    public void startRolling(int timeIn) {
        this.rollingDuration = timeIn;
        if (!this.f_19853_.f_46443_) {
            this.setIsRolling(true);
        }
    }

    public void stopRolling() {
        this.rollingDuration = 0;
        if (!this.f_19853_.f_46443_) {
            this.setIsRolling(false);
        }
    }

    public boolean shouldRoll() {
        return this.m_20096_() || this.m_20069_();
    }

    protected void updateRoll() {
        if (!this.shouldRoll()) {
            this.rollingDuration = 0;
        }
        if (!this.f_19853_.f_46443_ && this.rollingDuration <= 0) {
            this.setIsRolling(false);
        }
    }

    public void setIsRolling(boolean isRolling) {
        this.f_19804_.m_135381_(IS_ROLLING, (Object)isRolling);
    }

    public boolean isRolling() {
        return (Boolean)this.f_19804_.m_135370_(IS_ROLLING);
    }

    static class MoveHelperController
    extends MoveControl {
        private float yRot;
        private final RedstoneCubeEntity redstoneCubeEntity;
        private boolean isAggressive;

        public MoveHelperController(RedstoneCubeEntity cubeIn) {
            super((Mob)cubeIn);
            this.redstoneCubeEntity = cubeIn;
            this.yRot = 180.0f * cubeIn.m_146908_() / (float)Math.PI;
        }

        public void setDirection(float yRotIn, boolean aggressive) {
            this.yRot = yRotIn;
            this.isAggressive = aggressive;
        }

        public void setSpeed(double speedIn) {
            this.f_24978_ = speedIn;
            this.f_24981_ = MoveControl.Operation.MOVE_TO;
        }

        public void m_8126_() {
            this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), this.yRot, 90.0f));
            this.f_24974_.f_20885_ = this.f_24974_.m_146908_();
            this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
            if (this.f_24981_ == MoveControl.Operation.WAIT) {
                this.f_24974_.m_21564_(0.0f);
            } else if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                this.f_24981_ = MoveControl.Operation.WAIT;
                if (this.f_24974_.m_20096_() || this.f_24974_.m_20069_()) {
                    this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                    if (!this.redstoneCubeEntity.isRolling() && this.redstoneCubeEntity.shouldRoll()) {
                        this.redstoneCubeEntity.startRolling(20);
                    }
                }
            }
        }
    }

    static class AttackGoal
    extends Goal {
        private final RedstoneCubeEntity redstoneCubeEntity;
        private int growTieredTimer;

        AttackGoal(RedstoneCubeEntity cubeIn) {
            this.redstoneCubeEntity = cubeIn;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.redstoneCubeEntity.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            return !(livingentity instanceof Player) || !((Player)livingentity).m_150110_().f_35934_;
        }

        public void m_8056_() {
            this.growTieredTimer = 300;
            super.m_8056_();
        }

        public boolean m_8045_() {
            LivingEntity livingentity = this.redstoneCubeEntity.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (livingentity instanceof Player && ((Player)livingentity).m_150110_().f_35934_) {
                return false;
            }
            return --this.growTieredTimer > 0;
        }

        public void m_8037_() {
            this.redstoneCubeEntity.m_21391_((Entity)this.redstoneCubeEntity.m_5448_(), 10.0f, 10.0f);
            ((MoveHelperController)this.redstoneCubeEntity.m_21566_()).setDirection(this.redstoneCubeEntity.m_146908_(), this.redstoneCubeEntity.canDamagePlayer());
        }
    }

    static class FaceRandomGoal
    extends Goal {
        private final RedstoneCubeEntity redstoneCubeEntity;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public FaceRandomGoal(RedstoneCubeEntity cubeIn) {
            this.redstoneCubeEntity = cubeIn;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.redstoneCubeEntity.m_5448_() == null && (this.redstoneCubeEntity.m_20096_() || this.redstoneCubeEntity.m_20069_() || this.redstoneCubeEntity.m_20077_() || this.redstoneCubeEntity.m_21023_(MobEffects.f_19620_));
        }

        public void m_8037_() {
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = 40 + this.redstoneCubeEntity.m_217043_().m_188503_(60);
                this.chosenDegrees = this.redstoneCubeEntity.m_217043_().m_188503_(360);
            }
            ((MoveHelperController)this.redstoneCubeEntity.m_21566_()).setDirection(this.chosenDegrees, false);
        }
    }
}

