/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.redstone;

import com.infamous.dungeons_mobs.client.particle.ModParticleTypes;
import com.infamous.dungeons_mobs.entities.redstone.RedstoneMineEntity;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class RedstoneGolemEntity
extends Raider
implements IAnimatable {
    private int attackTimer;
    private int mineAttackCooldown;
    private int attackID;
    public static final byte MELEE_ATTACK = 1;
    public static final byte MINE_ATTACK = 2;
    private static final EntityDataAccessor<Boolean> SUMMONING_MINES = SynchedEntityData.m_135353_(RedstoneGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> MELEEATTACKING = SynchedEntityData.m_135353_(RedstoneGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public int soundLoopTick;

    public RedstoneGolemEntity(Level worldIn) {
        super((EntityType)ModEntityTypes.REDSTONE_GOLEM.get(), worldIn);
    }

    public RedstoneGolemEntity(EntityType<? extends RedstoneGolemEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_19793_ = 1.25f;
        this.f_21364_ = 40;
        this.mineAttackCooldown = 200;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SUMMONING_MINES, (Object)false);
        this.f_19804_.m_135372_(MELEEATTACKING, (Object)false);
    }

    public boolean isSummoningMines() {
        return (Boolean)this.f_19804_.m_135370_(SUMMONING_MINES);
    }

    public void setSummoningMines(boolean summoningMines) {
        this.f_19804_.m_135381_(SUMMONING_MINES, (Object)summoningMines);
    }

    public boolean isMeleeAttacking() {
        return (Boolean)this.f_19804_.m_135370_(MELEEATTACKING);
    }

    public void setMeleeAttacking(boolean attacking) {
        this.f_19804_.m_135381_(MELEEATTACKING, (Object)attacking);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        Vec3 velocity = this.m_20184_();
        float groundSpeed = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
        if (this.isSummoningMines()) {
            event.getController().setAnimationSpeed(1.0);
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.redstone_golem.summon", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
        } else if (this.isMeleeAttacking()) {
            event.getController().setAnimationSpeed(1.0);
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.redstone_golem.attack", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimationSpeed((double)(groundSpeed * 10.0f));
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.redstone_golem.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimationSpeed(1.0);
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.redstone_golem.general", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new MeleeGoal());
        this.f_21345_.m_25352_(5, (Goal)new AttackGoal((PathfinderMob)this, 1.3));
        this.f_21345_.m_25352_(4, (Goal)new SummonRedstoneMinesGoal());
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.REDSTONE_GOLEM_IDLE.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)ModSoundEvents.REDSTONE_GOLEM_STEP.get(), 1.0f, 1.0f);
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.REDSTONE_GOLEM_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.REDSTONE_GOLEM_DEATH.get();
    }

    public void m_6075_() {
        super.m_6075_();
        ++this.soundLoopTick;
        if (this.soundLoopTick % 30 == 0) {
            this.m_5496_((SoundEvent)ModSoundEvents.REDSTONE_GOLEM_IDLE_PULSE_LOOP.get(), 0.75f, 1.0f);
        }
        if (!this.f_19853_.f_46443_ && this.f_19796_.m_188503_(100) == 0) {
            this.m_5496_((SoundEvent)ModSoundEvents.REDSTONE_GOLEM_SPARK.get(), 0.25f, this.m_6100_());
            this.f_19853_.m_7605_((Entity)this, (byte)4);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.attackID != 0) {
            ++this.attackTimer;
        }
        if (!this.f_19853_.f_46443_ && this.mineAttackCooldown > 0) {
            --this.mineAttackCooldown;
        }
        this.handleLeafCollision();
        this.handleSteppingOnBlocks();
    }

    private void handleSteppingOnBlocks() {
        int k;
        int j;
        int i;
        BlockPos pos;
        BlockState blockstate;
        if (this.m_20184_().m_165925_() > 2.500000277905201E-7 && this.f_19796_.m_188503_(5) == 0 && !(blockstate = this.f_19853_.m_8055_(pos = new BlockPos(i = Mth.m_14107_((double)this.m_20185_()), j = Mth.m_14107_((double)(this.m_20186_() - (double)0.2f)), k = Mth.m_14107_((double)this.m_20189_())))).m_60795_()) {
            this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate).setPos(pos), this.m_20185_() + ((double)this.f_19796_.m_188501_() - 0.5) * (double)this.m_20205_(), this.m_20186_() + 0.1, this.m_20189_() + ((double)this.f_19796_.m_188501_() - 0.5) * (double)this.m_20205_(), 4.0 * ((double)this.f_19796_.m_188501_() - 0.5), 0.5, ((double)this.f_19796_.m_188501_() - 0.5) * 4.0);
        }
    }

    private void handleLeafCollision() {
        if (this.m_6084_() && this.f_19862_ && ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this)) {
            boolean destroyedLeafBlock = false;
            AABB axisalignedbb = this.m_20191_().m_82400_(0.2);
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)axisalignedbb.f_82288_), (int)Mth.m_14107_((double)axisalignedbb.f_82289_), (int)Mth.m_14107_((double)axisalignedbb.f_82290_), (int)Mth.m_14107_((double)axisalignedbb.f_82291_), (int)Mth.m_14107_((double)axisalignedbb.f_82292_), (int)Mth.m_14107_((double)axisalignedbb.f_82293_))) {
                BlockState blockstate = this.f_19853_.m_8055_(blockpos);
                Block block = blockstate.m_60734_();
                if (!(block instanceof LeavesBlock)) continue;
                destroyedLeafBlock = this.f_19853_.m_46953_(blockpos, true, (Entity)this) || destroyedLeafBlock;
            }
            if (!destroyedLeafBlock && this.f_19861_) {
                this.m_6135_();
            }
        }
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22281_, 16.0).m_22268_(Attributes.f_22282_, 3.0).m_22268_(Attributes.f_22277_, 25.0);
    }

    private float getAttackKnockback() {
        return (float)this.m_21133_(Attributes.f_22282_);
    }

    protected int m_7302_(int air) {
        return air;
    }

    public boolean m_7327_(Entity entityIn) {
        if (!this.f_19853_.f_46443_ && this.attackID == 0) {
            this.attackID = 1;
        }
        return true;
    }

    public boolean m_6914_(LevelReader worldIn) {
        BlockPos golemPos = this.m_20183_();
        BlockPos posBeneathGolem = golemPos.m_7495_();
        BlockState blockstateBeneathGolem = worldIn.m_8055_(posBeneathGolem);
        if (!blockstateBeneathGolem.m_60634_((BlockGetter)worldIn, posBeneathGolem, (Entity)this)) {
            return false;
        }
        for (int i = 1; i < 4; ++i) {
            BlockState blockstateAboveGolem;
            BlockPos posAboveGolem = golemPos.m_6630_(i);
            if (NaturalSpawner.m_47056_((BlockGetter)worldIn, (BlockPos)posAboveGolem, (BlockState)(blockstateAboveGolem = worldIn.m_8055_(posAboveGolem)), (FluidState)blockstateAboveGolem.m_60819_(), (EntityType)((EntityType)ModEntityTypes.REDSTONE_GOLEM.get()))) continue;
            return false;
        }
        return NaturalSpawner.m_47056_((BlockGetter)worldIn, (BlockPos)golemPos, (BlockState)worldIn.m_8055_(golemPos), (FluidState)Fluids.f_76191_.m_76145_(), (EntityType)((EntityType)ModEntityTypes.REDSTONE_GOLEM.get())) && worldIn.m_45784_((Entity)this);
    }

    private void setAttackID(int id) {
        this.attackID = id;
        this.attackTimer = 0;
        this.f_19853_.m_7605_((Entity)this, (byte)(-id));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id <= 0) {
            this.attackID = Math.abs(id);
            this.attackTimer = 0;
        } else if (id == 4) {
            for (int i = 0; i < 5; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.REDSTONE_SPARK.get(), this.m_20208_(1.1), this.m_20187_(), this.m_20262_(1.1), -0.15 + this.f_19796_.m_188500_() * 0.15, -0.15 + this.f_19796_.m_188500_() * 0.15, -0.15 + this.f_19796_.m_188500_() * 0.15);
            }
        } else {
            super.m_7822_(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.875f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new Navigator((Mob)this, worldIn);
    }

    public void m_7895_(int p_213660_1_, boolean p_213660_2_) {
    }

    public SoundEvent m_7930_() {
        return SoundEvents.f_12009_;
    }

    public boolean m_7490_() {
        return false;
    }

    public boolean m_7307_(Entity entityIn) {
        if (super.m_7307_(entityIn)) {
            return true;
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).m_6336_() == MobType.f_21643_ || entityIn instanceof Raider) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        return false;
    }

    private boolean canSummonMines() {
        return this.mineAttackCooldown <= 0 && this.m_5448_() != null && this.m_5448_().m_6084_() && this.m_20096_() && this.attackID == 0;
    }

    private void createSpellEntity(double x, double z, double minY, double maxY, int delay) {
        BlockPos blockpos = new BlockPos(x, maxY, z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = this.f_19853_.m_8055_(blockpos1 = blockpos.m_7495_())).m_60783_((BlockGetter)this.f_19853_, blockpos1, Direction.UP)) continue;
            if (!this.f_19853_.m_46859_(blockpos) && !(voxelshape = (blockstate1 = this.f_19853_.m_8055_(blockpos)).m_60812_((BlockGetter)this.f_19853_, blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)minY) - 1);
        if (flag) {
            this.f_19853_.m_7967_((Entity)new RedstoneMineEntity(this.f_19853_, x, (double)blockpos.m_123342_() + d0, z, delay, (LivingEntity)this));
        }
    }

    class MeleeGoal
    extends Goal {
        public MeleeGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return RedstoneGolemEntity.this.m_5448_() != null && RedstoneGolemEntity.this.attackID == 1;
        }

        public boolean m_8045_() {
            return RedstoneGolemEntity.this.attackTimer < 15;
        }

        public void m_8056_() {
            RedstoneGolemEntity.this.setAttackID(1);
            RedstoneGolemEntity.this.setMeleeAttacking(true);
        }

        public void m_8037_() {
            if (RedstoneGolemEntity.this.m_5448_() != null && RedstoneGolemEntity.this.m_5448_().m_6084_()) {
                RedstoneGolemEntity.this.m_21563_().m_24960_((Entity)RedstoneGolemEntity.this.m_5448_(), 30.0f, 30.0f);
                if (RedstoneGolemEntity.this.attackTimer == 8) {
                    RedstoneGolemEntity.this.m_5496_((SoundEvent)ModSoundEvents.REDSTONE_GOLEM_ATTACK.get(), 1.0f, 1.0f);
                }
                if (RedstoneGolemEntity.this.attackTimer == 9) {
                    float attackKnockback = RedstoneGolemEntity.this.getAttackKnockback();
                    LivingEntity attackTarget = RedstoneGolemEntity.this.m_5448_();
                    double ratioX = Mth.m_14031_((float)(RedstoneGolemEntity.this.m_146908_() * ((float)Math.PI / 180)));
                    double ratioZ = -Mth.m_14089_((float)(RedstoneGolemEntity.this.m_146908_() * ((float)Math.PI / 180)));
                    double knockbackReduction = 0.5;
                    attackTarget.m_6469_(DamageSource.m_19370_((LivingEntity)RedstoneGolemEntity.this), (float)RedstoneGolemEntity.this.m_21133_(Attributes.f_22281_));
                    this.forceKnockback(attackTarget, attackKnockback * 0.5f, ratioX, ratioZ, knockbackReduction);
                    RedstoneGolemEntity.this.m_20256_(RedstoneGolemEntity.this.m_20184_().m_82542_(0.6, 1.0, 0.6));
                }
            }
        }

        private void forceKnockback(LivingEntity attackTarget, float strength, double ratioX, double ratioZ, double knockbackResistanceReduction) {
            LivingKnockBackEvent event = ForgeHooks.onLivingKnockBack((LivingEntity)attackTarget, (float)strength, (double)ratioX, (double)ratioZ);
            if (event.isCanceled()) {
                return;
            }
            strength = event.getStrength();
            ratioX = event.getRatioX();
            ratioZ = event.getRatioZ();
            if (!((strength = (float)((double)strength * (1.0 - attackTarget.m_21133_(Attributes.f_22278_) * knockbackResistanceReduction))) <= 0.0f)) {
                attackTarget.f_19812_ = true;
                Vec3 vector3d = attackTarget.m_20184_();
                Vec3 vector3d1 = new Vec3(ratioX, 0.0, ratioZ).m_82541_().m_82490_((double)strength);
                attackTarget.m_20334_(vector3d.f_82479_ / 2.0 - vector3d1.f_82479_, attackTarget.m_20096_() ? Math.min(0.4, vector3d.f_82480_ / 2.0 + (double)strength) : vector3d.f_82480_, vector3d.f_82481_ / 2.0 - vector3d1.f_82481_);
            }
        }

        public void m_8041_() {
            RedstoneGolemEntity.this.setMeleeAttacking(false);
            RedstoneGolemEntity.this.setAttackID(0);
        }

        public boolean m_183429_() {
            return true;
        }
    }

    class AttackGoal
    extends MeleeAttackGoal {
        private int maxAttackTimer;
        private final double moveSpeed;
        private int delayCounter;
        private int attackTimer;

        public AttackGoal(PathfinderMob creatureEntity, double moveSpeed) {
            super(creatureEntity, moveSpeed, true);
            this.maxAttackTimer = 20;
            this.moveSpeed = moveSpeed;
        }

        public boolean m_8036_() {
            return RedstoneGolemEntity.this.m_5448_() != null && RedstoneGolemEntity.this.m_5448_().m_6084_();
        }

        public void m_8056_() {
            RedstoneGolemEntity.this.m_21561_(true);
            this.delayCounter = 0;
        }

        public void m_8037_() {
            LivingEntity livingentity = RedstoneGolemEntity.this.m_5448_();
            if (livingentity == null) {
                return;
            }
            RedstoneGolemEntity.this.f_21365_.m_24960_((Entity)livingentity, 30.0f, 30.0f);
            if (--this.delayCounter <= 0) {
                this.delayCounter = 4 + RedstoneGolemEntity.this.m_217043_().m_188503_(7);
                RedstoneGolemEntity.this.m_21573_().m_5624_((Entity)livingentity, this.moveSpeed);
            }
            this.attackTimer = Math.max(this.attackTimer - 1, 0);
            this.m_6739_(livingentity, RedstoneGolemEntity.this.m_20275_(livingentity.m_20185_(), livingentity.m_20191_().f_82289_, livingentity.m_20189_()));
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            if ((distToEnemySqr <= this.m_6639_(enemy) || RedstoneGolemEntity.this.m_20191_().m_82381_(enemy.m_20191_())) && this.attackTimer <= 0) {
                this.attackTimer = this.maxAttackTimer;
                RedstoneGolemEntity.this.m_7327_((Entity)enemy);
            }
        }

        public void m_8041_() {
            RedstoneGolemEntity.this.m_21573_().m_26573_();
            if (RedstoneGolemEntity.this.m_5448_() == null) {
                RedstoneGolemEntity.this.m_21561_(false);
            }
        }

        public AttackGoal setMaxAttackTick(int max) {
            this.maxAttackTimer = max;
            return this;
        }
    }

    class SummonRedstoneMinesGoal
    extends Goal {
        static final int MINE_ATTACK_COOLDOWN = 200;

        SummonRedstoneMinesGoal() {
        }

        public boolean m_8036_() {
            return RedstoneGolemEntity.this.canSummonMines();
        }

        public boolean m_8045_() {
            return RedstoneGolemEntity.this.attackTimer < 100;
        }

        public void m_8056_() {
            RedstoneGolemEntity.this.setSummoningMines(true);
            RedstoneGolemEntity.this.setAttackID(2);
            RedstoneGolemEntity.this.m_5496_((SoundEvent)ModSoundEvents.REDSTONE_GOLEM_SUMMON_MINES.get(), 1.5f, 1.0f);
        }

        public void m_8037_() {
            RedstoneGolemEntity.this.m_21573_().m_26573_();
            if (RedstoneGolemEntity.this.attackTimer == 12) {
                BlockPos centerPos = RedstoneGolemEntity.this.m_20183_();
                for (int i = 0; i < 14; ++i) {
                    double randomNearbyX = (double)centerPos.m_123341_() + RedstoneGolemEntity.this.f_19796_.m_188583_() * 10.0;
                    double randomNearbyZ = (double)centerPos.m_123343_() + RedstoneGolemEntity.this.f_19796_.m_188583_() * 10.0;
                    int j = 250 + 4 * i;
                    BlockPos randomBlockPos = new BlockPos(randomNearbyX, (double)centerPos.m_123342_(), randomNearbyZ);
                    RedstoneGolemEntity.this.createSpellEntity(randomBlockPos.m_123341_(), randomBlockPos.m_123343_(), randomBlockPos.m_123342_(), randomBlockPos.m_123342_() + 1, j);
                }
            }
        }

        public void m_8041_() {
            RedstoneGolemEntity.this.setAttackID(0);
            RedstoneGolemEntity.this.mineAttackCooldown = 200;
            RedstoneGolemEntity.this.setSummoningMines(false);
        }
    }

    static class Navigator
    extends GroundPathNavigation {
        public Navigator(Mob mobEntity, Level world) {
            super(mobEntity, world);
        }

        protected PathFinder m_5532_(int p_179679_1_) {
            this.f_26508_ = new Processor();
            return new PathFinder(this.f_26508_, p_179679_1_);
        }
    }

    static class Processor
    extends WalkNodeEvaluator {
        private Processor() {
        }

        protected BlockPathTypes m_6603_(BlockGetter blockReader, boolean canBreakDoors, boolean canWalkThroughDoorways, BlockPos blockPos, BlockPathTypes pathNodeType) {
            return pathNodeType == BlockPathTypes.LEAVES ? BlockPathTypes.OPEN : super.m_6603_(blockReader, canBreakDoors, canWalkThroughDoorways, blockPos, pathNodeType);
        }
    }
}

