/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.slime;

import com.infamous.dungeons_mobs.entities.projectiles.SlimeballEntity;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class ConjuredSlimeEntity
extends Slime
implements RangedAttackMob {
    public ConjuredSlimeEntity(Level worldIn) {
        super((EntityType)ModEntityTypes.CONJURED_SLIME.get(), worldIn);
    }

    public ConjuredSlimeEntity(EntityType<? extends ConjuredSlimeEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new MoveHelperController(this);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new ImmobileRangedAttackGoal(40, 10.0f));
        this.f_21345_.m_25352_(3, (Goal)new FaceRandomGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, this::canSlimeReach));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    private boolean canSlimeReach(LivingEntity target) {
        return Math.abs(target.m_20186_() - this.m_20186_()) <= 4.0;
    }

    public EntityType<? extends ConjuredSlimeEntity> m_6095_() {
        return (EntityType)ModEntityTypes.CONJURED_SLIME.get();
    }

    public void m_7334_(Entity entityIn) {
        double d1;
        double d0;
        double d2;
        if (!(this.m_5803_() || this.m_20365_(entityIn) || entityIn.f_19794_ || this.f_19794_ || !((d2 = Mth.m_14005_((double)(d0 = entityIn.m_20185_() - this.m_20185_()), (double)(d1 = entityIn.m_20189_() - this.m_20189_()))) >= (double)0.01f))) {
            d2 = Mth.m_14116_((float)((float)d2));
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            d0 *= 0.5;
            d1 *= 0.5;
            if (!this.m_20160_()) {
                this.m_5997_(-d0, 0.0, -d1);
            }
            if (!entityIn.m_20160_()) {
                entityIn.m_5997_(d0, 0.0, d1);
            }
        }
    }

    public void m_6123_(Player entityIn) {
    }

    protected void m_33637_(LivingEntity entityIn) {
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 0.625f * sizeIn.f_20378_;
    }

    protected boolean m_7483_() {
        return this.m_6142_();
    }

    protected void m_6135_() {
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        double xDifference = target.m_20185_() - this.m_20185_();
        double yDifference = target.m_20227_(0.5) - this.m_20227_(0.5);
        double zDifference = target.m_20189_() - this.m_20189_();
        float euclidDist = Mth.m_14116_((float)((float)(xDifference * xDifference + yDifference * yDifference + zDifference * zDifference)));
        SlimeballEntity slimeballEntity = new SlimeballEntity(this.f_19853_, (LivingEntity)this, 0.0, 0.0, 0.0);
        slimeballEntity.m_6034_(slimeballEntity.m_20185_(), this.m_20227_(0.5), slimeballEntity.m_20189_());
        slimeballEntity.m_6686_(xDifference, yDifference, zDifference, euclidDist, 0.0f);
        this.f_19853_.m_7967_((Entity)slimeballEntity);
    }

    static class MoveHelperController
    extends MoveControl {
        private float yRot;
        private final ConjuredSlimeEntity slime;

        public MoveHelperController(ConjuredSlimeEntity slimeIn) {
            super((Mob)slimeIn);
            this.slime = slimeIn;
            this.yRot = 180.0f * slimeIn.m_146908_() / (float)Math.PI;
        }

        public void setDirection(float yRotIn) {
            this.yRot = yRotIn;
        }

        public void m_8126_() {
            this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), this.yRot, 90.0f));
            this.f_24974_.f_20885_ = this.f_24974_.m_146908_();
            this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
        }
    }

    class ImmobileRangedAttackGoal
    extends Goal {
        private final int minRangedAttackInterval;
        private final int maxRangedAttackTime;
        private final float attackRadius;
        private final float maxAttackDistance;
        private int rangedAttackTime = -1;
        private int seeTime;
        private int growTieredTimer;

        public ImmobileRangedAttackGoal(int maxAttackTimeIn, float maxAttackDistanceIn) {
            this.minRangedAttackInterval = maxAttackTimeIn;
            this.maxRangedAttackTime = maxAttackTimeIn;
            this.attackRadius = maxAttackDistanceIn;
            this.maxAttackDistance = maxAttackDistanceIn * maxAttackDistanceIn;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = ConjuredSlimeEntity.this.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            return (!(livingentity instanceof Player) || !((Player)livingentity).m_150110_().f_35934_) && ConjuredSlimeEntity.this.m_21566_() instanceof MoveHelperController;
        }

        public void m_8056_() {
            this.growTieredTimer = 300;
            super.m_8056_();
        }

        public void m_8041_() {
            this.seeTime = 0;
            this.rangedAttackTime = -1;
        }

        public boolean m_8045_() {
            LivingEntity livingentity = ConjuredSlimeEntity.this.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (livingentity instanceof Player && ((Player)livingentity).m_150110_().f_35934_) {
                return false;
            }
            return --this.growTieredTimer > 0;
        }

        public void m_8037_() {
            LivingEntity attackTarget = ConjuredSlimeEntity.this.m_5448_();
            if (attackTarget != null) {
                double distanceSqToTarget = ConjuredSlimeEntity.this.m_20275_(attackTarget.m_20185_(), attackTarget.m_20186_(), attackTarget.m_20189_());
                boolean canSeeTarget = ConjuredSlimeEntity.this.m_21574_().m_148306_((Entity)attackTarget);
                this.seeTime = canSeeTarget ? ++this.seeTime : 0;
                ConjuredSlimeEntity.this.m_21391_((Entity)ConjuredSlimeEntity.this.m_5448_(), 10.0f, 10.0f);
                ((MoveHelperController)ConjuredSlimeEntity.this.m_21566_()).setDirection(ConjuredSlimeEntity.this.m_146908_());
                if (--this.rangedAttackTime == 0) {
                    if (!canSeeTarget) {
                        return;
                    }
                    float f = Mth.m_14116_((float)((float)distanceSqToTarget)) / this.attackRadius;
                    float clamp = Mth.m_14036_((float)f, (float)0.1f, (float)1.0f);
                    ConjuredSlimeEntity.this.m_6504_(attackTarget, clamp);
                    this.rangedAttackTime = Mth.m_14143_((float)(f * (float)(this.maxRangedAttackTime - this.minRangedAttackInterval) + (float)this.minRangedAttackInterval));
                } else if (this.rangedAttackTime < 0) {
                    float f2 = Mth.m_14116_((float)((float)distanceSqToTarget)) / this.attackRadius;
                    this.rangedAttackTime = Mth.m_14143_((float)(f2 * (float)(this.maxRangedAttackTime - this.minRangedAttackInterval) + (float)this.minRangedAttackInterval));
                }
            }
        }
    }

    static class FaceRandomGoal
    extends Goal {
        private final ConjuredSlimeEntity slime;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public FaceRandomGoal(ConjuredSlimeEntity slimeIn) {
            this.slime = slimeIn;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.slime.m_5448_() == null && (this.slime.f_19861_ || this.slime.m_20069_() || this.slime.m_20077_() || this.slime.m_21023_(MobEffects.f_19620_)) && this.slime.m_21566_() instanceof MoveHelperController;
        }

        public void m_8037_() {
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = 40 + this.slime.m_217043_().m_188503_(60);
                this.chosenDegrees = this.slime.m_217043_().m_188503_(360);
            }
            ((MoveHelperController)this.slime.m_21566_()).setDirection(this.chosenDegrees);
        }
    }
}

