/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.summonables;

import com.google.common.collect.Lists;
import com.infamous.dungeons_mobs.interfaces.ITrapsTarget;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;

public abstract class AbstractTrapEntity
extends Entity
implements IAnimatable {
    public int spawnAnimationTick = this.getSpawnAnimationLength();
    public int decayAnimationTick;
    public int lifeTime;
    public Entity owner;
    public boolean isTrappingMob;
    public List<Entity> trappedEntities = Lists.newArrayList();
    public List<Vec3> trappedEntityPositions = Lists.newArrayList();

    public AbstractTrapEntity(EntityType<? extends AbstractTrapEntity> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public void m_6075_() {
        super.m_6075_();
        this.tickDownAnimTimers();
        this.increaseLifeTime();
        this.performBasicTrapFunctions();
    }

    public void increaseLifeTime() {
        ++this.lifeTime;
        if (!this.f_19853_.f_46443_) {
            if (this.lifeTime == this.timeToDecay()) {
                this.decayAnimationTick = this.getDecayAnimationLength();
                this.f_19853_.m_7605_((Entity)this, (byte)2);
            }
            if (this.decayAnimationTick == 2) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    public void performBasicTrapFunctions() {
        if (!this.f_19853_.f_46443_) {
            List list;
            boolean isTrapping = false;
            if (this.canTrap() && !(list = this.f_19853_.m_6249_((Entity)this, this.m_20191_(), Entity::m_6084_)).isEmpty()) {
                for (Entity entity : list) {
                    if (!(entity instanceof LivingEntity) || !this.canTrapEntity((LivingEntity)entity)) continue;
                    if (!this.trappedEntities.contains(entity)) {
                        this.trappedEntities.add(entity);
                        this.trappedEntityPositions.add(entity.m_20182_());
                    }
                    if (this.owner != null && this.owner instanceof Mob && ((Mob)this.owner).m_5448_() != null && ((Mob)this.owner).m_5448_().m_6084_() && ((Mob)this.owner).m_5448_() == entity && this.owner instanceof ITrapsTarget) {
                        ((ITrapsTarget)this.owner).setTargetTrapped(true, true);
                    }
                    isTrapping = true;
                }
            }
            for (Entity entity : this.trappedEntities) {
                int entityIndex = this.trappedEntities.indexOf(entity);
                Vec3 entityTrappedPosition = this.trappedEntityPositions.get(entityIndex);
                entity.f_19789_ = 0.0f;
                if (!((double)this.distanceBetweenVector3ds(entity.m_20182_(), entityTrappedPosition) > 0.5)) continue;
                entity.m_6021_(entityTrappedPosition.f_82479_, entityTrappedPosition.f_82480_, entityTrappedPosition.f_82481_);
            }
            this.isTrappingMob = isTrapping;
        }
    }

    public float distanceBetweenVector3ds(Vec3 position, Vec3 positionToGetDistanceTo) {
        float f = (float)(position.f_82479_ - positionToGetDistanceTo.f_82479_);
        float f1 = (float)(position.f_82480_ - positionToGetDistanceTo.f_82480_);
        float f2 = (float)(position.f_82481_ - positionToGetDistanceTo.f_82481_);
        return Mth.m_14116_((float)(f * f + f1 * f1 + f2 * f2));
    }

    public void tickDownAnimTimers() {
        if (this.spawnAnimationTick > 0) {
            --this.spawnAnimationTick;
        }
        if (this.decayAnimationTick > 0) {
            --this.decayAnimationTick;
        }
    }

    public abstract int getSpawnAnimationLength();

    public abstract int getDecayAnimationLength();

    public int timeToDecay() {
        return 80;
    }

    public boolean canTrap() {
        return this.spawnAnimationTick <= 0;
    }

    public boolean canTrapEntity(LivingEntity entity) {
        return !entity.m_5833_();
    }

    public void m_7822_(byte p_70103_1_) {
        if (p_70103_1_ == 1) {
            this.spawnAnimationTick = this.getSpawnAnimationLength();
        } else if (p_70103_1_ == 2) {
            this.decayAnimationTick = this.getDecayAnimationLength();
        } else {
            super.m_7822_(p_70103_1_);
        }
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag p_70037_1_) {
    }

    protected void m_7380_(CompoundTag p_213281_1_) {
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

