/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.summonables;

import com.infamous.dungeons_mobs.entities.summonables.AreaDamageEntity;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class ConstructEntity
extends PathfinderMob {
    public static final EntityDataAccessor<Integer> LIFE_TICKS = SynchedEntityData.m_135353_(ConstructEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public Direction directionToFace = null;
    private LivingEntity caster;
    private UUID casterUuid;

    protected ConstructEntity(EntityType<? extends ConstructEntity> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    protected ConstructEntity(EntityType<? extends ConstructEntity> entityTypeIn, Level worldIn, double x, double y, double z, LivingEntity casterIn, int lifeTicksIn) {
        this(entityTypeIn, worldIn);
        this.setLifeTicks(lifeTicksIn);
        this.setCaster(casterIn);
        this.m_6034_(x, y, z);
    }

    public static boolean canVehicleCollide(Entity p_242378_0_, Entity p_242378_1_) {
        return (p_242378_1_.m_5829_() || p_242378_1_.m_6094_()) && !p_242378_0_.m_20365_(p_242378_1_);
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.f_19853_ instanceof ServerLevel && (entity = ((ServerLevel)this.f_19853_).m_8791_(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    public void setCaster(@Nullable LivingEntity caster) {
        this.caster = caster;
        this.casterUuid = caster == null ? null : caster.m_20148_();
    }

    public void m_5997_(double p_70024_1_, double p_70024_3_, double p_70024_5_) {
    }

    public void m_6478_(MoverType p_213315_1_, Vec3 p_213315_2_) {
    }

    public boolean m_7337_(Entity p_241849_1_) {
        return ConstructEntity.canVehicleCollide((Entity)this, p_241849_1_);
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6469_(DamageSource p_70097_1_, float p_70097_2_) {
        if (p_70097_1_ == DamageSource.f_19317_) {
            return super.m_6469_(p_70097_1_, p_70097_2_);
        }
        return false;
    }

    public void faceDirection(Direction directionToFace) {
        float rotationAmount = 0.0f;
        if (directionToFace == Direction.NORTH) {
            rotationAmount = 90.0f;
        }
        if (directionToFace == Direction.SOUTH) {
            rotationAmount = -90.0f;
        }
        if (directionToFace == Direction.EAST) {
            rotationAmount = 0.0f;
        }
        if (directionToFace == Direction.WEST) {
            rotationAmount = 180.0f;
        }
        this.m_146922_(rotationAmount);
    }

    public boolean m_6097_() {
        return false;
    }

    public void m_7378_(CompoundTag compound) {
        this.setLifeTicks(compound.m_128451_("LifeTicks"));
        if (compound.m_128403_("Owner")) {
            this.casterUuid = compound.m_128342_("Owner");
        }
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128405_("LifeTicks", this.getLifeTicks());
        if (this.casterUuid != null) {
            compound.m_128362_("Owner", this.casterUuid);
        }
    }

    public int getLifeTicks() {
        return (Integer)this.f_19804_.m_135370_(LIFE_TICKS);
    }

    public void setLifeTicks(int p_189794_1_) {
        this.f_19804_.m_135381_(LIFE_TICKS, (Object)p_189794_1_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LIFE_TICKS, (Object)0);
    }

    public void handleExistence() {
        this.m_20073_();
    }

    public void handleExpiration() {
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public void m_6075_() {
        if (this.getLifeTicks() > 100) {
            List v = this.f_19853_.m_45933_((Entity)this, this.m_20191_());
            for (Entity entity : v) {
                if (entity == this || !(entity instanceof ConstructEntity)) continue;
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                break;
            }
        }
        this.setLifeTicks(this.getLifeTicks() - 1);
        if (!this.f_19853_.m_5776_() && this.getLifeTicks() <= 0) {
            this.handleExpiration();
        } else {
            this.handleExistence();
        }
    }

    public void spawnAreaDamage() {
        AreaDamageEntity areaDamage = AreaDamageEntity.spawnAreaDamage(this.f_19853_, this.m_20182_(), (LivingEntity)this, 2.5f, DamageSource.m_19370_((LivingEntity)this), 0.0f, 1.25f, 0.25f, 0.25f, 5, false, false, 0.75, 0.25, false, 0, 1);
        this.f_19853_.m_7967_((Entity)areaDamage);
    }
}

