/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.summonables;

import com.infamous.dungeons_mobs.client.particle.ModParticleTypes;
import com.infamous.dungeons_mobs.mod.ModDamageSources;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class IceCloudEntity
extends Entity
implements IAnimatable {
    private static final Predicate<Entity> ALIVE = p_213685_0_ -> p_213685_0_.m_6084_();
    public LivingEntity target;
    public Entity owner;
    public int formAnimationTick;
    public int formAnimationLength = 40;
    public int fallAnimationTick;
    public int fallAnimationLength = 17;
    public int landAnimationTick;
    public int landAnimationLength = 22;
    public int lifeTime;
    public boolean falling;
    public boolean hasFormed;
    public int soundLoopTick;
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public IceCloudEntity(Level world) {
        super((EntityType)ModEntityTypes.ICE_CLOUD.get(), world);
        this.f_19850_ = true;
    }

    public IceCloudEntity(EntityType<? extends IceCloudEntity> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.f_19850_ = true;
    }

    public static void spawn(Entity summoningEntity, LivingEntity target) {
        IceCloudEntity iceChunk = (IceCloudEntity)((EntityType)ModEntityTypes.ICE_CLOUD.get()).m_20615_(summoningEntity.f_19853_);
        iceChunk.m_6027_(target.m_20185_(), target.m_20186_() + (double)target.m_20206_() + 3.0, target.m_20189_());
        iceChunk.target = target;
        iceChunk.owner = summoningEntity;
        iceChunk.m_5496_((SoundEvent)ModSoundEvents.ICE_CHUNK_SUMMONED.get(), 1.0f, iceChunk.getRandomPitch());
        summoningEntity.f_19853_.m_7967_((Entity)iceChunk);
    }

    public boolean m_6097_() {
        return false;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6051_() {
        return false;
    }

    protected float getRandomPitch() {
        return (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f;
    }

    public void m_7822_(byte p_28844_) {
        if (p_28844_ == 1) {
            this.formAnimationTick = this.formAnimationLength;
        } else if (p_28844_ == 2) {
            this.fallAnimationTick = this.fallAnimationLength;
        } else if (p_28844_ == 3) {
            this.landAnimationTick = this.landAnimationLength;
        } else if (p_28844_ == 4) {
            this.falling = true;
        } else if (p_28844_ == 5) {
            for (int i = 0; i < 50; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.3;
                double d1 = this.f_19796_.m_188583_() * 0.2;
                double d2 = this.f_19796_.m_188583_() * 0.3;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_(), this.m_20189_(), d0, d1, d2);
            }
        } else if (p_28844_ == 6) {
            this.hasFormed = true;
        } else if (p_28844_ == 7) {
            this.target = null;
        } else {
            super.m_7822_(p_28844_);
        }
    }

    public void moveToTarget() {
        if (this.target != null && !this.target.m_21224_() && this.distanceToIgnoringY((Entity)this.target) > 1.0f) {
            this.m_20334_(0.0, 0.0, 0.0);
            double x = this.target.m_20185_() - this.m_20185_();
            double y = this.target.m_20186_() + (double)this.target.m_20206_() + 3.0 - this.m_20186_();
            double z = this.target.m_20189_() - this.m_20189_();
            double d = Math.sqrt(x * x + y * y + z * z);
            this.m_20256_(this.m_20184_().m_82520_(x / d * (double)0.2f, y / d * (double)0.2f, z / d * (double)0.2f).m_82490_(1.0));
            this.m_6478_(MoverType.SELF, this.m_20184_());
        }
    }

    public float distanceToIgnoringY(Entity p_70032_1_) {
        float f = (float)(this.m_20185_() - p_70032_1_.m_20185_());
        float f2 = (float)(this.m_20189_() - p_70032_1_.m_20189_());
        return Mth.m_14116_((float)(f * f + f2 * f2));
    }

    public void m_6075_() {
        super.m_6075_();
        this.f_19790_ = this.m_20185_();
        this.f_19791_ = this.m_20186_();
        this.f_19792_ = this.m_20189_();
        if (this.f_19853_.f_46443_ && this.landAnimationTick <= 0) {
            if (this.hasFormed) {
                this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.SNOWFLAKE.get(), this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
            } else {
                for (int i = 0; i < 2; ++i) {
                    this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.SNOWFLAKE.get(), this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), -(this.f_19796_.m_188500_() - 0.5) * 2.0, this.f_19796_.m_188500_(), -(this.f_19796_.m_188500_() - 0.5) * 2.0);
                }
            }
        }
        HitResult raytraceresult = ProjectileUtil.m_37294_((Entity)this, this::canHitEntity);
        boolean flag = false;
        if (raytraceresult.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos blockpos = ((BlockHitResult)raytraceresult).m_82425_();
            BlockState blockstate = this.f_19853_.m_8055_(blockpos);
            if (blockstate.m_60713_(Blocks.f_50142_)) {
                this.m_20221_(blockpos);
                flag = true;
            } else if (blockstate.m_60713_(Blocks.f_50446_)) {
                BlockEntity blockEntity = this.f_19853_.m_7702_(blockpos);
                if (blockEntity instanceof TheEndGatewayBlockEntity && TheEndGatewayBlockEntity.m_59940_((Entity)this)) {
                    TheEndGatewayBlockEntity.m_155828_((Level)this.f_19853_, (BlockPos)blockpos, (BlockState)blockstate, (Entity)this, (TheEndGatewayBlockEntity)((TheEndGatewayBlockEntity)blockEntity));
                }
                flag = true;
            }
        }
        if (raytraceresult.m_6662_() != HitResult.Type.MISS && !flag) {
            this.onHit(raytraceresult);
        }
        this.m_20101_();
        this.tickDownAnimTimers();
        if (this.hasFormed) {
            ++this.soundLoopTick;
            ++this.lifeTime;
        }
        if (this.soundLoopTick % 80 == 0 && this.hasFormed && !this.falling && this.fallAnimationTick <= 0) {
            this.m_5496_((SoundEvent)ModSoundEvents.ICE_CHUNK_IDLE_LOOP.get(), 0.5f, 1.0f);
        }
        if (!this.f_19853_.f_46443_) {
            if (this.target != null && !this.canHitEntity((Entity)this.target)) {
                this.target = null;
                this.f_19853_.m_7605_((Entity)this, (byte)7);
            }
            if (!this.hasFormed && this.formAnimationTick <= 0) {
                this.formAnimationTick = this.formAnimationLength;
                this.f_19853_.m_7605_((Entity)this, (byte)1);
            }
            if (this.formAnimationTick == 1) {
                this.m_5496_((SoundEvent)ModSoundEvents.ICE_CHUNK_IDLE_LOOP.get(), 0.5f, 1.0f);
                this.hasFormed = true;
                this.f_19853_.m_7605_((Entity)this, (byte)6);
            }
            if (this.target != null && this.lifeTime > 100 && this.fallAnimationTick <= 0 && !this.falling || this.target == null || this.target.m_21224_()) {
                this.m_5496_((SoundEvent)ModSoundEvents.ICE_CHUNK_FALL.get(), 1.0f, this.getRandomPitch());
                this.fallAnimationTick = this.fallAnimationLength;
                this.f_19853_.m_7605_((Entity)this, (byte)2);
            }
            if (this.fallAnimationTick == 1) {
                this.falling = true;
                this.f_19853_.m_7605_((Entity)this, (byte)4);
            }
            if (this.landAnimationTick == 1 || this.lifeTime > 150) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
        if (this.hasFormed && this.landAnimationTick <= 0 && !this.falling && this.fallAnimationTick <= 0) {
            this.moveToTarget();
        }
        if (this.falling && this.landAnimationTick <= 0) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -1.25, 0.0));
            this.m_6478_(MoverType.SELF, this.m_20184_());
        }
    }

    protected boolean canHitEntity(Entity p_230298_1_) {
        return !p_230298_1_.m_5833_() && p_230298_1_.m_6084_() && p_230298_1_.m_6087_();
    }

    protected void onHit(HitResult p_70227_1_) {
        HitResult.Type raytraceresult$type = p_70227_1_.m_6662_();
        if (!this.f_19853_.f_46443_ && this.landAnimationTick <= 0) {
            this.landAnimationTick = this.landAnimationLength;
            this.f_19853_.m_7605_((Entity)this, (byte)3);
            this.land();
            this.m_6027_(this.m_20185_(), this.m_20186_() - 1.0, this.m_20189_());
            this.m_5496_((SoundEvent)ModSoundEvents.ICE_CHUNK_LAND.get(), 1.5f, this.getRandomPitch());
        }
        if (raytraceresult$type == HitResult.Type.ENTITY) {
            this.onHitEntity((EntityHitResult)p_70227_1_);
        } else if (raytraceresult$type == HitResult.Type.BLOCK) {
            this.onHitBlock((BlockHitResult)p_70227_1_);
        }
    }

    protected void onHitEntity(EntityHitResult p_213868_1_) {
    }

    protected void onHitBlock(BlockHitResult p_230299_1_) {
    }

    private void land() {
        if (this.m_6084_()) {
            for (LivingEntity entity : this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(2.5), ALIVE)) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 2));
                entity.m_6469_(ModDamageSources.iceChunk(this, this.owner), 15.0f);
                this.strongKnockback((Entity)entity);
            }
            this.f_19853_.m_7605_((Entity)this, (byte)5);
        }
    }

    private void strongKnockback(Entity p_213688_1_) {
        p_213688_1_.m_5997_(this.f_19796_.m_188583_() * 1.0, 0.1, this.f_19796_.m_188583_() * 1.0);
    }

    public boolean m_5829_() {
        return true;
    }

    public void tickDownAnimTimers() {
        if (this.formAnimationTick > 0) {
            --this.formAnimationTick;
        }
        if (this.fallAnimationTick > 0) {
            --this.fallAnimationTick;
        }
        if (this.landAnimationTick > 0) {
            --this.landAnimationTick;
        }
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.formAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("ice_chunk_form", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.landAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("ice_chunk_land", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.fallAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("ice_chunk_fall", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.hasFormed) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("ice_chunk_idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("ice_chunk_idle_unformed", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag p_70037_1_) {
    }

    protected void m_7380_(CompoundTag p_213281_1_) {
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

