/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.summonables;

import com.infamous.dungeons_mobs.entities.summonables.AbstractTrapEntity;
import com.infamous.dungeons_mobs.tags.EntityTags;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class KelpTrapEntity
extends AbstractTrapEntity {
    private static final EntityDataAccessor<Boolean> PULLING = SynchedEntityData.m_135353_(KelpTrapEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public int ensnareAnimationTick;
    public int ensnareAnimationLength = 5;
    public int trappedMobTime;
    public int bubbleAudioInterval;

    public KelpTrapEntity(EntityType<? extends KelpTrapEntity> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.ensnareAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("kelp_trap_ensnare", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.spawnAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("kelp_trap_spawn", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.decayAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("vine_trap_decay", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.isPulling()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("kelp_trap_idle_pulling", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("vine_trap_idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public int getSpawnAnimationLength() {
        return 10;
    }

    @Override
    public int getDecayAnimationLength() {
        return 25;
    }

    @Override
    public boolean canTrapEntity(LivingEntity entity) {
        return super.canTrapEntity(entity) && !entity.m_6095_().m_204039_(EntityTags.PLANT_MOBS);
    }

    @Override
    protected void m_8097_() {
        this.f_19804_.m_135372_(PULLING, (Object)true);
    }

    @Override
    protected void m_7378_(CompoundTag p_70037_1_) {
        this.setPulling(p_70037_1_.m_128471_("Pulling"));
    }

    @Override
    protected void m_7380_(CompoundTag p_213281_1_) {
        p_213281_1_.m_128379_("Pulling", this.isPulling());
    }

    public boolean isPulling() {
        return (Boolean)this.f_19804_.m_135370_(PULLING);
    }

    public void setPulling(boolean attached) {
        this.f_19804_.m_135381_(PULLING, (Object)attached);
    }

    @Override
    public void m_6075_() {
        if (!this.f_19853_.f_46443_ && this.lifeTime == 0) {
            this.setPulling(true);
        }
        if (this.bubbleAudioInterval > 0) {
            --this.bubbleAudioInterval;
        }
        if (!this.f_19853_.f_46443_ && this.isPulling()) {
            List list = this.f_19853_.m_6249_((Entity)this, this.m_20191_().m_82377_(0.0, this.waterBlocksAbove(), 0.0), Entity::m_6084_);
            int i = 0;
            while ((double)i < this.waterBlocksAbove()) {
                ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123773_, this.m_20208_(0.25), this.m_20186_() + (double)i + 0.8, this.m_20262_(0.25) - 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                ++i;
            }
            if (!list.isEmpty()) {
                for (Entity entity : list) {
                    if (!(entity.m_20186_() > this.m_20186_()) || entity instanceof LivingEntity && !this.canTrapEntity((LivingEntity)entity)) continue;
                    if (this.bubbleAudioInterval <= 0) {
                        this.m_5496_(SoundEvents.f_11777_, 1.25f, 1.0f);
                        this.bubbleAudioInterval = 40;
                    }
                    entity.m_5997_(0.0, -0.1, 0.0);
                    entity.f_19864_ = true;
                }
            }
        }
        super.m_6075_();
    }

    @Override
    public void tickDownAnimTimers() {
        super.tickDownAnimTimers();
        if (this.ensnareAnimationTick > 0) {
            --this.ensnareAnimationTick;
        }
    }

    public double waterBlocksAbove() {
        double waterBlocksAbove = 0.0;
        for (int i = 0; i < 256; ++i) {
            waterBlocksAbove = i;
            if (this.f_19853_.m_6425_(this.m_20183_().m_6630_(i)).m_205070_(FluidTags.f_13131_)) continue;
            return waterBlocksAbove;
        }
        return waterBlocksAbove;
    }

    @Override
    public void increaseLifeTime() {
        if (!this.f_19853_.f_46443_) {
            if (this.isTrappingMob) {
                ++this.trappedMobTime;
                if (this.isPulling() && this.ensnareAnimationTick <= 0) {
                    this.setPulling(false);
                    this.ensnareAnimationTick = this.ensnareAnimationLength;
                    this.f_19853_.m_7605_((Entity)this, (byte)3);
                }
            } else {
                ++this.lifeTime;
            }
            if (this.trappedMobTime == this.timeToDecay()) {
                this.decayAnimationTick = this.getDecayAnimationLength();
                this.f_19853_.m_7605_((Entity)this, (byte)2);
            }
            if (this.isPulling()) {
                if (this.lifeTime == 200) {
                    this.ensnareAnimationTick = this.ensnareAnimationLength;
                    this.f_19853_.m_7605_((Entity)this, (byte)3);
                }
                if (this.lifeTime == 200 + this.ensnareAnimationLength) {
                    this.decayAnimationTick = this.getDecayAnimationLength();
                    this.f_19853_.m_7605_((Entity)this, (byte)2);
                }
            } else if (this.trappedMobTime == 100) {
                this.decayAnimationTick = this.getDecayAnimationLength();
                this.f_19853_.m_7605_((Entity)this, (byte)2);
            }
            if (this.decayAnimationTick == 2) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    @Override
    public boolean canTrap() {
        return true;
    }

    @Override
    public void m_7822_(byte p_70103_1_) {
        if (p_70103_1_ == 3) {
            this.ensnareAnimationTick = this.ensnareAnimationLength;
        } else {
            super.m_7822_(p_70103_1_);
        }
    }
}

