/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.summonables;

import com.infamous.dungeons_mobs.entities.summonables.AbstractTrapEntity;
import com.infamous.dungeons_mobs.tags.EntityTags;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.level.Level;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class SimpleTrapEntity
extends AbstractTrapEntity {
    private static final EntityDataAccessor<Integer> TRAP_TYPE = SynchedEntityData.m_135353_(SimpleTrapEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public SimpleTrapEntity(EntityType<? extends SimpleTrapEntity> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Override
    protected void m_8097_() {
        this.f_19804_.m_135372_(TRAP_TYPE, (Object)0);
    }

    @Override
    protected void m_7378_(CompoundTag p_70037_1_) {
        this.setTrapType(p_70037_1_.m_128451_("TrapType"));
    }

    @Override
    protected void m_7380_(CompoundTag p_213281_1_) {
        p_213281_1_.m_128405_("TrapType", this.getTrapType());
    }

    public int getTrapType() {
        return Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(TRAP_TYPE)), (int)0, (int)1);
    }

    public void setTrapType(int attached) {
        this.f_19804_.m_135381_(TRAP_TYPE, (Object)attached);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.getTrapType() == 0) {
            if (this.spawnAnimationTick > 0) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("web_trap_spawn", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else if (this.decayAnimationTick > 0) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("vine_trap_decay", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("vine_trap_idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        } else if (this.getTrapType() == 1) {
            if (this.spawnAnimationTick > 0) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("vine_trap_spawn", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else if (this.decayAnimationTick > 0) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("vine_trap_decay", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("vine_trap_idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public int getSpawnAnimationLength() {
        return this.getTrapType() == 1 ? 8 : 7;
    }

    @Override
    public int getDecayAnimationLength() {
        return 25;
    }

    @Override
    public boolean canTrapEntity(LivingEntity entity) {
        if (this.getTrapType() == 0) {
            return super.canTrapEntity(entity) && entity.m_6336_() != MobType.f_21642_;
        }
        if (this.getTrapType() == 1) {
            return super.canTrapEntity(entity) && !entity.m_6095_().m_204039_(EntityTags.PLANT_MOBS);
        }
        return super.canTrapEntity(entity);
    }
}

