/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.summonables;

import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class SummonSpotEntity
extends Entity
implements IAnimatable {
    private static final EntityDataAccessor<Integer> SUMMON_TYPE = SynchedEntityData.m_135353_(SummonSpotEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int lifeTime = 0;
    public Entity summonedEntity = null;
    AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public int mobSpawnRotation;

    public SummonSpotEntity(Level worldIn) {
        super((EntityType)ModEntityTypes.SUMMON_SPOT.get(), worldIn);
    }

    public SummonSpotEntity(EntityType<?> p_i48580_1_, Level p_i48580_2_) {
        super(p_i48580_1_, p_i48580_2_);
    }

    public void m_6075_() {
        super.m_6075_();
        ++this.lifeTime;
        if (!this.f_19853_.f_46443_ && this.lifeTime == this.getSummonTime() && this.summonedEntity != null) {
            this.summonedEntity.m_20035_(this.m_20183_(), 0.0f, 0.0f);
            this.summonedEntity.m_5618_((float)this.f_19796_.m_188503_(360));
            ((ServerLevel)this.f_19853_).m_47205_(this.summonedEntity);
        }
        if (!this.f_19853_.f_46443_ && this.lifeTime >= this.getDespawnTime()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(SUMMON_TYPE, (Object)0);
    }

    protected void m_7378_(CompoundTag p_70037_1_) {
        this.setSummonType(p_70037_1_.m_128451_("SummonType"));
    }

    protected void m_7380_(CompoundTag p_213281_1_) {
        p_213281_1_.m_128405_("SummonType", this.getSummonType());
    }

    public int getSummonType() {
        return Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(SUMMON_TYPE)), (int)0, (int)3);
    }

    public void setSummonType(int attached) {
        this.f_19804_.m_135381_(SUMMON_TYPE, (Object)attached);
    }

    public int getDespawnTime() {
        if (this.getSummonType() == 0) {
            return 18;
        }
        if (this.getSummonType() == 1) {
            return 18;
        }
        if (this.getSummonType() == 2) {
            return 18;
        }
        if (this.getSummonType() == 3) {
            return 18;
        }
        return 2;
    }

    public int getSummonTime() {
        if (this.getSummonType() == 0) {
            return 10;
        }
        if (this.getSummonType() == 1) {
            return 10;
        }
        if (this.getSummonType() == 2) {
            return 10;
        }
        if (this.getSummonType() == 3) {
            return 10;
        }
        return 1;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 1.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.getSummonType() == 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("illusioner_summon_spot_summon", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.getSummonType() == 1) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("wildfire_summon_spot_summon", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.getSummonType() == 2) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("illusioner_summon_spot_summon", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.getSummonType() == 3) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("illusioner_summon_spot_summon", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

