/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.undead;

import com.infamous.dungeons_mobs.client.particle.ModParticleTypes;
import com.infamous.dungeons_mobs.entities.SpawnEquipmentHelper;
import com.infamous.dungeons_mobs.goals.switchcombat.SwitchCombatItemGoal;
import com.infamous.dungeons_mobs.goals.switchcombat.ThrowAndMeleeAttackGoal;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.EggItem;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SnowballItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class FrozenZombieEntity
extends Zombie
implements RangedAttackMob {
    public FrozenZombieEntity(Level worldIn) {
        super(worldIn);
    }

    public FrozenZombieEntity(EntityType<? extends FrozenZombieEntity> p_i48549_1_, Level p_i48549_2_) {
        super(p_i48549_1_, p_i48549_2_);
    }

    public static boolean canFrozenZombieSpawn(EntityType<FrozenZombieEntity> entityType, ServerLevelAccessor iWorld, MobSpawnType spawnReason, BlockPos blockPos, RandomSource rand) {
        return FrozenZombieEntity.m_219013_(entityType, (ServerLevelAccessor)iWorld, (MobSpawnType)spawnReason, (BlockPos)blockPos, (RandomSource)rand) && (spawnReason == MobSpawnType.SPAWNER || iWorld.m_45527_(blockPos));
    }

    protected void m_6878_() {
        this.f_21345_.m_25352_(2, (Goal)new FrozenZombieAttackGoal(this, 1.0, 20, 15.0f, false));
        this.f_21345_.m_25352_(3, (Goal)new SwitchCombatItemGoal((Mob)this, 6.0, 6.0));
        this.f_21345_.m_25352_(6, (Goal)new MoveThroughVillageGoal((PathfinderMob)this, 1.0, true, 4, () -> ((FrozenZombieEntity)this).m_34330_()));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{ZombifiedPiglin.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, 10, true, false, Turtle.f_30122_));
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.FROZEN_ZOMBIE_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return (SoundEvent)ModSoundEvents.FROZEN_ZOMBIE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.FROZEN_ZOMBIE_DEATH.get();
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Zombie.m_34328_();
    }

    public boolean m_7307_(Entity entityIn) {
        if (super.m_7307_(entityIn)) {
            return true;
        }
        if (entityIn instanceof LivingEntity && entityIn instanceof Zombie) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        return false;
    }

    protected void m_213945_(RandomSource random, DifficultyInstance difficultyInstance) {
        super.m_213945_(random, difficultyInstance);
        SpawnEquipmentHelper.equipOffhand(Items.f_42452_.m_7968_(), (Mob)this);
    }

    public void m_8107_() {
        if (this.f_19853_.f_46443_) {
            this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.SNOWFLAKE.get(), this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
        }
        super.m_8107_();
    }

    public boolean m_7327_(Entity targetEntity) {
        if (super.m_7327_(targetEntity)) {
            if (targetEntity instanceof LivingEntity) {
                int i = 0;
                if (this.f_19853_.m_46791_() == Difficulty.NORMAL) {
                    i = 4;
                } else if (this.f_19853_.m_46791_() == Difficulty.HARD) {
                    i = 8;
                }
                if (i > 0) {
                    ((LivingEntity)targetEntity).m_7292_(new MobEffectInstance(MobEffects.f_19597_, i * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    public void m_6504_(LivingEntity livingEntity, float v) {
        Snowball snowballentity = new Snowball(this.f_19853_, (LivingEntity)this);
        double adjustedEyeY = livingEntity.m_20188_() - (double)1.1f;
        double xDifference = livingEntity.m_20185_() - this.m_20185_();
        double yDifference = adjustedEyeY - snowballentity.m_20186_();
        double zDifference = livingEntity.m_20189_() - this.m_20189_();
        float adjustedHorizontalDistance = Mth.m_14116_((float)((float)(xDifference * xDifference + zDifference * zDifference))) * 0.2f;
        snowballentity.m_6686_(xDifference, yDifference + (double)adjustedHorizontalDistance, zDifference, 1.6f, 7.5f);
        this.m_5496_(SoundEvents.f_12479_, 1.0f, 0.4f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.f_19853_.m_7967_((Entity)snowballentity);
    }

    static class FrozenZombieAttackGoal
    extends ThrowAndMeleeAttackGoal {
        private final FrozenZombieEntity zombie;
        private int raiseArmTicks;

        FrozenZombieAttackGoal(FrozenZombieEntity zombieEntity, double speedAmplifier, int attackInterval, float maxDistance, boolean useLongMemory) {
            super(zombieEntity, speedAmplifier, attackInterval, maxDistance, useLongMemory);
            this.zombie = zombieEntity;
        }

        @Override
        public boolean hasThrowableItemInMainhand() {
            return this.zombie.m_21205_().m_41720_() instanceof SnowballItem | this.zombie.m_21205_().m_41720_() instanceof EggItem && this.zombie.m_5448_() != null && !this.zombie.m_5448_().m_21023_(MobEffects.f_19597_);
        }

        public void m_8056_() {
            super.m_8056_();
            this.raiseArmTicks = 0;
        }

        @Override
        public void m_8041_() {
            super.m_8041_();
            this.zombie.m_21561_(false);
        }

        @Override
        public void m_8037_() {
            super.m_8037_();
            ++this.raiseArmTicks;
            this.zombie.m_21561_(this.raiseArmTicks >= 5 && this.m_25565_() < this.m_25566_() / 2);
        }
    }
}

