/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.undead;

import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import com.infamous.dungeons_mobs.worldgen.EntitySpawnPlacements;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class MossySkeletonEntity
extends AbstractSkeleton {
    public MossySkeletonEntity(Level worldIn) {
        super((EntityType)ModEntityTypes.MOSSY_SKELETON.get(), worldIn);
    }

    public MossySkeletonEntity(EntityType<? extends MossySkeletonEntity> entityType, Level world) {
        super(entityType, world);
    }

    public static boolean canMossySkeletonSpawn(EntityType<MossySkeletonEntity> entityType, ServerLevelAccessor iWorld, MobSpawnType spawnReason, BlockPos blockPos, RandomSource rand) {
        return MossySkeletonEntity.m_219013_(entityType, (ServerLevelAccessor)iWorld, (MobSpawnType)spawnReason, (BlockPos)blockPos, (RandomSource)rand) && (spawnReason == MobSpawnType.SPAWNER || EntitySpawnPlacements.canSeeSkyLight(iWorld, blockPos));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return AbstractSkeleton.m_32166_();
    }

    public void m_8032_() {
        SoundEvent soundevent = this.m_7515_();
        if (soundevent != null) {
            this.m_5496_(soundevent, 0.25f, this.m_6100_());
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.MOSSY_SKELETON_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return (SoundEvent)ModSoundEvents.MOSSY_SKELETON_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.MOSSY_SKELETON_DEATH.get();
    }

    protected SoundEvent m_7878_() {
        return (SoundEvent)ModSoundEvents.MOSSY_SKELETON_STEP.get();
    }

    public void m_6504_(LivingEntity p_82196_1_, float p_82196_2_) {
        ItemStack itemstack = this.m_6298_(this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
        AbstractArrow abstractarrowentity = this.m_7932_(itemstack, p_82196_2_);
        if (this.m_21205_().m_41720_() instanceof BowItem) {
            abstractarrowentity = ((BowItem)this.m_21205_().m_41720_()).customArrow(abstractarrowentity);
        }
        double d0 = p_82196_1_.m_20185_() - this.m_20185_();
        double d1 = p_82196_1_.m_20227_(0.3333333333333333) - abstractarrowentity.m_20186_();
        double d2 = p_82196_1_.m_20189_() - this.m_20189_();
        double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
        abstractarrowentity.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.f_19853_.m_46791_().m_19028_() * 4));
        this.m_5496_((SoundEvent)ModSoundEvents.MOSSY_SKELETON_SHOOT.get(), 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.f_19853_.m_7967_((Entity)abstractarrowentity);
    }

    public boolean m_7327_(Entity targetEntity) {
        if (super.m_7327_(targetEntity)) {
            if (targetEntity instanceof LivingEntity) {
                int i = 0;
                if (this.f_19853_.m_46791_() == Difficulty.NORMAL) {
                    i = 4;
                } else if (this.f_19853_.m_46791_() == Difficulty.HARD) {
                    i = 8;
                }
                if (i > 0) {
                    ((LivingEntity)targetEntity).m_7292_(new MobEffectInstance(MobEffects.f_19614_, i * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    protected AbstractArrow m_7932_(ItemStack stack, float damageMultiplier) {
        AbstractArrow abstractArrowEntity = super.m_7932_(stack, damageMultiplier);
        int i = 0;
        if (this.f_19853_.m_46791_() == Difficulty.NORMAL) {
            i = 4;
        } else if (this.f_19853_.m_46791_() == Difficulty.HARD) {
            i = 8;
        }
        if (abstractArrowEntity instanceof Arrow && i > 0) {
            ((Arrow)abstractArrowEntity).m_36870_(new MobEffectInstance(MobEffects.f_19614_, i * 20));
        }
        return abstractArrowEntity;
    }
}

