/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.undead;

import com.infamous.dungeons_libraries.entities.SpawnArmoredMob;
import com.infamous.dungeons_libraries.items.gearconfig.ArmorSet;
import com.infamous.dungeons_mobs.entities.AnimatableMeleeAttackMob;
import com.infamous.dungeons_mobs.entities.SpawnEquipmentHelper;
import com.infamous.dungeons_mobs.goals.ApproachTargetGoal;
import com.infamous.dungeons_mobs.goals.BasicModdedAttackGoal;
import com.infamous.dungeons_mobs.goals.LookAtTargetGoal;
import com.infamous.dungeons_mobs.goals.UseShieldGoal;
import com.infamous.dungeons_mobs.interfaces.IShieldUser;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModItems;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class SkeletonVanguardEntity
extends Skeleton
implements IShieldUser,
IAnimatable,
SpawnArmoredMob,
AnimatableMeleeAttackMob {
    private static final UUID SPEED_MODIFIER_BLOCKING_UUID = UUID.fromString("e4c96392-42f5-4028-ac44-cad469c10d51");
    private static final AttributeModifier SPEED_MODIFIER_BLOCKING = new AttributeModifier(SPEED_MODIFIER_BLOCKING_UUID, "Blocking speed decrease", -0.05, AttributeModifier.Operation.ADDITION);
    AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private int shieldCooldownTime;
    public int attackAnimationTick;
    public int attackAnimationLength = 22;
    public int attackAnimationActionPoint = 10;

    public SkeletonVanguardEntity(Level worldIn) {
        super((EntityType)ModEntityTypes.SKELETON_VANGUARD.get(), worldIn);
    }

    public SkeletonVanguardEntity(EntityType<? extends SkeletonVanguardEntity> p_i48555_1_, Level p_i48555_2_) {
        super(p_i48555_1_, p_i48555_2_);
        this.shieldCooldownTime = 0;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new UseShieldGoal((PathfinderMob)this, 10.0, 60, 120, 10, 60, true));
        this.f_21345_.m_25352_(1, new BasicModdedAttackGoal<SkeletonVanguardEntity>(this, (SoundEvent)ModSoundEvents.SKELETON_VANGUARD_ATTACK.get(), 20));
        this.f_21345_.m_25352_(2, (Goal)new ApproachTargetGoal((PathfinderMob)this, 0.0, 1.0, true));
        this.f_21345_.m_25352_(3, (Goal)new LookAtTargetGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Wolf.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, 10, true, false, Turtle.f_30122_));
    }

    protected boolean m_21527_() {
        return false;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Skeleton.m_32166_().m_22268_(Attributes.f_22277_, 26.0).m_22268_(Attributes.f_22284_, 6.0).m_22268_(Attributes.f_22282_, 1.5).m_22268_(Attributes.f_22278_, 0.3);
    }

    protected void m_213945_(RandomSource random, DifficultyInstance difficultyInstance) {
        SpawnEquipmentHelper.equipArmorSet(ModItems.VANGUARD_ARMOR, (Mob)this);
        if (ModList.get().isLoaded("dungeons_gear")) {
            Item GLAIVE = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("dungeons_gear", "glaive"));
            ItemStack glaive = new ItemStack((ItemLike)GLAIVE);
            SpawnEquipmentHelper.equipMainhand(glaive, (Mob)this);
        } else {
            SpawnEquipmentHelper.equipMainhand(Items.f_42383_.m_7968_(), (Mob)this);
        }
        SpawnEquipmentHelper.equipOffhand(((Item)ModItems.VANGUARD_SHIELD.get()).m_7968_(), (Mob)this);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficultyInstance, MobSpawnType spawnReason, @Nullable SpawnGroupData livingEntityDataIn, @Nullable CompoundTag compoundNBT) {
        livingEntityDataIn = super.m_6518_(world, difficultyInstance, spawnReason, livingEntityDataIn, compoundNBT);
        return livingEntityDataIn;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.SKELETON_VANGUARD_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return (SoundEvent)ModSoundEvents.SKELETON_VANGUARD_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.SKELETON_VANGUARD_DEATH.get();
    }

    protected SoundEvent m_7878_() {
        return (SoundEvent)ModSoundEvents.SKELETON_VANGUARD_STEP.get();
    }

    public boolean m_21526_() {
        return true;
    }

    public void m_7822_(byte p_28844_) {
        if (p_28844_ == 4) {
            this.attackAnimationTick = this.attackAnimationLength;
        } else {
            super.m_7822_(p_28844_);
        }
    }

    public void m_6075_() {
        super.m_6075_();
        AttributeInstance modifiableattributeinstance = this.m_21051_(Attributes.f_22279_);
        if (this.m_21254_()) {
            if (!modifiableattributeinstance.m_22109_(SPEED_MODIFIER_BLOCKING)) {
                modifiableattributeinstance.m_22118_(SPEED_MODIFIER_BLOCKING);
            }
        } else {
            modifiableattributeinstance.m_22130_(SPEED_MODIFIER_BLOCKING);
        }
        this.tickDownAnimTimers();
    }

    @Override
    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    @Override
    public void setAttackAnimationTick(int attackAnimationTick) {
        this.attackAnimationTick = attackAnimationTick;
    }

    @Override
    public int getAttackAnimationLength() {
        return this.attackAnimationLength;
    }

    @Override
    public int getAttackAnimationActionPoint() {
        return this.attackAnimationActionPoint;
    }

    public void tickDownAnimTimers() {
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.attackAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("skeleton_vanguard_attack", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.m_21254_()) {
            if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("skeleton_vanguard_new_walk_blocking", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("skeleton_vanguard_new_blocking", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("skeleton_vanguard_new_walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("skeleton_vanguard_new_idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.shieldCooldownTime > 0) {
            --this.shieldCooldownTime;
        } else if (this.shieldCooldownTime < 0) {
            this.shieldCooldownTime = 0;
        }
    }

    protected void m_6677_(DamageSource damageSource) {
        if (this.shieldCooldownTime == 100) {
            this.m_5496_(SoundEvents.f_12347_, 1.0f, 0.8f + this.f_19853_.f_46441_.m_188501_() * 0.4f);
        } else if (this.m_21254_()) {
            this.m_5496_(SoundEvents.f_12346_, 1.0f, 0.8f + this.f_19853_.f_46441_.m_188501_() * 0.4f);
        } else {
            super.m_6677_(damageSource);
        }
    }

    public void m_6728_(LivingEntity livingEntity) {
        super.m_6728_(livingEntity);
        if (livingEntity.m_21205_().canDisableShield(this.f_20935_, (LivingEntity)this, livingEntity)) {
            this.disableShield(true);
        }
    }

    protected void m_7909_(float amount) {
        if (this.f_20935_.canPerformAction(ToolActions.SHIELD_BLOCK) && amount >= 3.0f) {
            int i = 1 + Mth.m_14143_((float)amount);
            InteractionHand hand = this.m_7655_();
            this.f_20935_.m_41622_(i, (LivingEntity)this, skeletonVanguardEntity -> skeletonVanguardEntity.m_21190_(hand));
            if (this.f_20935_.m_41619_()) {
                if (hand == InteractionHand.MAIN_HAND) {
                    this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                } else {
                    this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                }
                this.f_20935_ = ItemStack.f_41583_;
                this.m_5496_(SoundEvents.f_12347_, 1.0f, 0.8f + this.f_19853_.f_46441_.m_188501_() * 0.4f);
            }
        }
    }

    @Override
    public int getShieldCooldownTime() {
        return this.shieldCooldownTime;
    }

    @Override
    public void setShieldCooldownTime(int shieldCooldownTime) {
        this.shieldCooldownTime = shieldCooldownTime;
    }

    @Override
    public void disableShield(boolean guaranteeDisable) {
        float f = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)this) * 0.05f;
        if (guaranteeDisable) {
            f += 0.75f;
        }
        if (this.f_19796_.m_188501_() < f) {
            this.m_5496_(SoundEvents.f_12347_, 0.8f, 0.8f + this.f_19853_.f_46441_.m_188501_() * 0.4f);
            this.shieldCooldownTime = 100;
            this.m_5810_();
            this.f_19853_.m_7605_((Entity)this, (byte)30);
        }
    }

    @Override
    public boolean isShieldDisabled() {
        return this.shieldCooldownTime > 0;
    }

    public ArmorSet getArmorSet() {
        return ModItems.VANGUARD_ARMOR;
    }
}

