/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.undead;

import com.infamous.dungeons_mobs.entities.summonables.WraithFireEntity;
import com.infamous.dungeons_mobs.goals.ApproachTargetGoal;
import com.infamous.dungeons_mobs.goals.LookAtTargetGoal;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import com.infamous.dungeons_mobs.utils.PositionUtils;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class WraithEntity
extends Monster
implements IAnimatable {
    public int summonFireAttackAnimationTick;
    public int summonFireAttackAnimationLength = 40;
    public int summonFireAttackAnimationActionPoint = 20;
    public int teleportAnimationTick;
    public int teleportAnimationLength = 40;
    public int teleportAnimationActionPoint = 18;
    AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public WraithEntity(EntityType<? extends WraithEntity> type, Level world) {
        super(type, world);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(2, (Goal)new FleeSunGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TeleportGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new SummonFireAttackGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new ApproachTargetGoal((PathfinderMob)this, 8.0, 1.2, true));
        this.f_21345_.m_25352_(6, (Goal)new LookAtTargetGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, 10, true, false, Turtle.f_30122_).m_26146_(300));
    }

    public boolean isSpellcasting() {
        return this.summonFireAttackAnimationTick > 0;
    }

    public void m_7822_(byte p_28844_) {
        if (p_28844_ == 4) {
            this.teleportAnimationTick = this.teleportAnimationLength;
        } else if (p_28844_ == 11) {
            this.summonFireAttackAnimationTick = this.summonFireAttackAnimationLength;
        } else {
            super.m_7822_(p_28844_);
        }
    }

    public boolean m_7307_(Entity entityIn) {
        if (super.m_7307_(entityIn)) {
            return true;
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).m_6336_() == MobType.f_21641_) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        return false;
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    public void m_6075_() {
        super.m_6075_();
        this.tickDownAnimTimers();
        if (this.teleportAnimationTick > 0) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123745_, this.m_20208_(1.0), this.m_20186_(), this.m_20262_(1.0), this.f_19796_.m_188583_() * 0.01, 0.1, this.f_19796_.m_188583_() * 0.01);
        }
    }

    public void tickDownAnimTimers() {
        if (this.summonFireAttackAnimationTick > 0) {
            --this.summonFireAttackAnimationTick;
        }
        if (this.teleportAnimationTick > 0) {
            --this.teleportAnimationTick;
        }
    }

    public void m_8107_() {
        if (!this.f_19861_ && this.m_20184_().f_82480_ < 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.75, 1.0));
        }
        if (this.m_6084_()) {
            boolean flag;
            boolean bl = flag = this.isSunSensitive() && this.m_21527_();
            if (flag) {
                ItemStack itemstack = this.m_6844_(EquipmentSlot.HEAD);
                if (!itemstack.m_41619_()) {
                    if (itemstack.m_41763_()) {
                        itemstack.m_41721_(itemstack.m_41773_() + this.f_19796_.m_188503_(2));
                        if (itemstack.m_41773_() >= itemstack.m_41776_()) {
                            this.m_21166_(EquipmentSlot.HEAD);
                            this.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
                        }
                    }
                    flag = false;
                }
                if (flag) {
                    this.m_20254_(8);
                }
            }
        }
        super.m_8107_();
    }

    public boolean isSunSensitive() {
        return true;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22276_, 20.0);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.WRAITH_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.WRAITH_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.WRAITH_DEATH.get();
    }

    protected SoundEvent getStepSound() {
        return (SoundEvent)ModSoundEvents.WRAITH_FLY.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(this.getStepSound(), 0.5f, 1.0f);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.summonFireAttackAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("wraith_attack", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.teleportAnimationTick > 10) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("wraith_teleport", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("wraith_fly", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("wraith_idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    private boolean teleport(double pX, double pY, double pZ) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(pX, pY, pZ);
        while (blockpos$mutableblockpos.m_123342_() > this.f_19853_.m_141937_() && !this.f_19853_.m_8055_((BlockPos)blockpos$mutableblockpos).m_60767_().m_76334_()) {
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = this.f_19853_.m_8055_((BlockPos)blockpos$mutableblockpos);
        boolean flag = blockstate.m_60767_().m_76334_();
        boolean flag1 = blockstate.m_60819_().m_205070_(FluidTags.f_13131_);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)pX, (double)pY, (double)pZ);
            if (event.isCanceled()) {
                return false;
            }
            Vec3 vec3 = this.m_20182_();
            boolean randomTeleport = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (randomTeleport) {
                this.f_19853_.m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)this));
                if (!this.m_20067_()) {
                    this.f_19853_.m_6263_((Player)null, this.f_19854_, this.f_19855_, this.f_19856_, (SoundEvent)ModSoundEvents.WRAITH_TELEPORT.get(), this.m_5720_(), 1.0f, 1.0f);
                    this.m_5496_((SoundEvent)ModSoundEvents.WRAITH_TELEPORT.get(), 1.0f, 1.0f);
                }
            }
            return randomTeleport;
        }
        return false;
    }

    class TeleportGoal
    extends Goal {
        public static final int TELEPORT_AWAY_RANGE = 20;
        public static final int TELEPORT_TO_RANGE = 10;
        public static final int TARGET_TOO_FAR = 16;
        public static final int TARGET_TOO_CLOSE = 4;
        public WraithEntity mob;
        @Nullable
        public LivingEntity target;

        public TeleportGoal(WraithEntity mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.target != null && (this.mob.m_20270_((Entity)this.target) <= 4.0f || this.mob.m_20270_((Entity)this.target) >= 16.0f) && this.mob.m_142582_((Entity)this.target) && this.animationsUseable();
        }

        public boolean m_8045_() {
            return this.target != null && !this.animationsUseable();
        }

        public void m_8056_() {
            this.mob.m_5496_((SoundEvent)ModSoundEvents.WRAITH_IDLE.get(), 1.0f, this.mob.m_6100_());
            this.mob.teleportAnimationTick = this.mob.teleportAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)4);
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            if (this.target != null) {
                this.mob.m_21563_().m_24946_(this.target.m_20185_(), this.target.m_20188_(), this.target.m_20189_());
            }
            if (this.target != null && this.mob.teleportAnimationTick == this.mob.teleportAnimationActionPoint) {
                if (this.mob.m_20270_((Entity)this.target) >= 16.0f) {
                    this.tryTeleport(10, this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
                } else {
                    this.tryTeleport(20, this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
                }
            }
        }

        private void tryTeleport(int teleportToRange, double targetX, double targetY, double targetZ) {
            for (int i = 0; i < 10 && !this.mob.teleport(targetX - (double)teleportToRange + (double)this.mob.f_19796_.m_188503_(teleportToRange * 2), targetY, targetZ - (double)teleportToRange + (double)this.mob.f_19796_.m_188503_(teleportToRange * 2)); ++i) {
            }
        }

        public boolean animationsUseable() {
            return this.mob.teleportAnimationTick <= 0;
        }
    }

    class SummonFireAttackGoal
    extends Goal {
        public WraithEntity mob;
        @Nullable
        public LivingEntity target;
        public int nextUseTime = 0;

        public SummonFireAttackGoal(WraithEntity mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.target != null && this.mob.f_19797_ >= this.nextUseTime && this.mob.m_20270_((Entity)this.target) <= 14.0f && this.mob.m_142582_((Entity)this.target) && this.animationsUseable();
        }

        public boolean m_8045_() {
            return this.target != null && !this.animationsUseable();
        }

        public void m_8056_() {
            this.mob.m_5496_((SoundEvent)ModSoundEvents.WRAITH_ATTACK.get(), 1.0f, this.mob.m_6100_());
            this.mob.summonFireAttackAnimationTick = this.mob.summonFireAttackAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)11);
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            this.mob.m_21573_().m_26573_();
            if (this.target != null) {
                this.mob.m_21563_().m_24946_(this.target.m_20185_(), this.target.m_20188_(), this.target.m_20189_());
            }
            if (this.target != null && this.mob.summonFireAttackAnimationTick == this.mob.summonFireAttackAnimationActionPoint) {
                WraithFireEntity wraithFire = (WraithFireEntity)((EntityType)ModEntityTypes.WRAITH_FIRE.get()).m_20615_(this.mob.f_19853_);
                wraithFire.owner = this.mob;
                wraithFire.m_20219_(this.target.m_20182_());
                this.mob.f_19853_.m_7967_((Entity)wraithFire);
                PositionUtils.moveToCorrectHeight(wraithFire);
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.nextUseTime = this.mob.f_19797_ + 60 + this.mob.f_19796_.m_188503_(60);
        }

        public boolean animationsUseable() {
            return this.mob.summonFireAttackAnimationTick <= 0;
        }
    }
}

