/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.goals;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class AvoidBaseEntityGoal<T extends Entity>
extends Goal {
    private final PathfinderMob hostCreature;
    private final double farSpeed;
    private final double nearSpeed;
    private T avoidTarget;
    private final float avoidDistance;
    private Path path;
    private final PathNavigation navigation;
    private final Class<T> classToAvoid;
    private static final Predicate<Entity> ALIVE = p_213685_0_ -> p_213685_0_.m_6084_();

    public AvoidBaseEntityGoal(PathfinderMob entityIn, Class<T> avoidClass, float distance, double farSpeedIn, double nearSpeedIn) {
        this.hostCreature = entityIn;
        this.classToAvoid = avoidClass;
        this.avoidDistance = distance;
        this.farSpeed = farSpeedIn;
        this.nearSpeed = nearSpeedIn;
        this.navigation = entityIn.m_21573_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        this.avoidTarget = this.getNearestEntity(this.classToAvoid, (LivingEntity)this.hostCreature, this.hostCreature.m_20185_(), this.hostCreature.m_20186_(), this.hostCreature.m_20189_(), this.hostCreature.m_20191_().m_82377_((double)this.avoidDistance, 3.0, (double)this.avoidDistance));
        if (this.avoidTarget == null) {
            return false;
        }
        Vec3 vector3d = DefaultRandomPos.m_148407_((PathfinderMob)this.hostCreature, (int)16, (int)7, (Vec3)this.avoidTarget.m_20182_());
        if (vector3d == null) {
            return false;
        }
        if (this.avoidTarget.m_20275_(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_) < this.avoidTarget.m_20280_((Entity)this.hostCreature)) {
            return false;
        }
        this.path = this.navigation.m_26524_(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_, 0);
        return this.path != null;
    }

    public boolean m_8045_() {
        return !this.navigation.m_26571_();
    }

    public void m_8056_() {
        this.navigation.m_26536_(this.path, this.farSpeed);
    }

    public void m_8041_() {
        this.avoidTarget = null;
    }

    public void m_8037_() {
        if (this.hostCreature.m_20280_(this.avoidTarget) < 49.0) {
            this.hostCreature.m_21573_().m_26517_(this.nearSpeed);
        } else {
            this.hostCreature.m_21573_().m_26517_(this.farSpeed);
        }
    }

    @Nullable
    private <T extends Entity> T getNearestEntity(Class<? extends T> entityClass, LivingEntity livingEntity, double xPos, double yPos, double zPos, AABB axisAlignedBB) {
        return this.getClosestEntity(livingEntity.f_19853_.m_6443_(entityClass, axisAlignedBB, ALIVE), livingEntity, xPos, yPos, zPos);
    }

    @Nullable
    private <T extends Entity> T getClosestEntity(List<? extends T> nearbyEntities, LivingEntity livingEntity, double xPos, double yPos, double zPos) {
        double closestDistanceSq = -1.0;
        Entity closestEntity = null;
        for (Entity nearbyEntity : nearbyEntities) {
            if (!this.canDetect(livingEntity, nearbyEntity)) continue;
            double distanceSq = nearbyEntity.m_20275_(xPos, yPos, zPos);
            if (closestDistanceSq != -1.0 && !(distanceSq < closestDistanceSq)) continue;
            closestDistanceSq = distanceSq;
            closestEntity = nearbyEntity;
        }
        return (T)closestEntity;
    }

    private boolean canDetect(@Nullable LivingEntity detector, Entity target) {
        if (detector == target) {
            return false;
        }
        if (target.m_5833_()) {
            return false;
        }
        if (!target.m_6084_()) {
            return false;
        }
        if (detector != null) {
            if (detector.m_7307_(target)) {
                return false;
            }
            return !(detector instanceof Mob) || ((Mob)detector).m_21574_().m_148306_(target);
        }
        return true;
    }
}

