/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.goals;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class MobHurtByTargetGoal
extends TargetGoal {
    private static final TargetingConditions HURT_BY_TARGETING = TargetingConditions.m_148352_().m_26893_();
    private boolean entityCallsForHelp;
    private int revengeTimerOld;
    private final Class<?>[] excludedReinforcementTypes;
    private Class<?>[] reinforcementTypes;

    public MobHurtByTargetGoal(Mob creatureIn, Class<?> ... excludeReinforcementTypes) {
        super(creatureIn, true);
        this.excludedReinforcementTypes = excludeReinforcementTypes;
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean m_8036_() {
        int i = this.f_26135_.m_21213_();
        LivingEntity livingentity = this.f_26135_.m_21188_();
        if (i != this.revengeTimerOld && livingentity != null) {
            if (livingentity.m_6095_() == EntityType.f_20532_ && this.f_26135_.f_19853_.m_46469_().m_46207_(GameRules.f_46127_)) {
                return false;
            }
            for (Class<?> oclass : this.excludedReinforcementTypes) {
                if (!oclass.isAssignableFrom(livingentity.getClass())) continue;
                return false;
            }
            return this.m_26150_(livingentity, HURT_BY_TARGETING);
        }
        return false;
    }

    public MobHurtByTargetGoal setCallsForHelp(Class<?> ... reinforcementTypes) {
        this.entityCallsForHelp = true;
        this.reinforcementTypes = reinforcementTypes;
        return this;
    }

    public void m_8056_() {
        this.f_26135_.m_6710_(this.f_26135_.m_21188_());
        this.f_26137_ = this.f_26135_.m_5448_();
        this.revengeTimerOld = this.f_26135_.m_21213_();
        this.f_26138_ = 300;
        if (this.entityCallsForHelp) {
            this.alertOthers();
        }
        super.m_8056_();
    }

    protected void alertOthers() {
        double d0 = this.m_7623_();
        AABB axisalignedbb = AABB.m_82333_((Vec3)this.f_26135_.m_20182_()).m_82377_(d0, 10.0, d0);
        List list = this.f_26135_.f_19853_.m_45976_(this.f_26135_.getClass(), axisalignedbb);
        Iterator iterator = list.iterator();
        while (true) {
            Mob mobentity;
            LivingEntity lastHurtByMob = this.f_26135_.m_21188_();
            while (true) {
                if (!iterator.hasNext()) {
                    return;
                }
                mobentity = (Mob)iterator.next();
                if (this.f_26135_ == mobentity || mobentity.m_5448_() != null || this.f_26135_ instanceof TamableAnimal && ((TamableAnimal)this.f_26135_).m_21826_() != ((TamableAnimal)mobentity).m_21826_() || lastHurtByMob == null || mobentity.m_7307_((Entity)lastHurtByMob)) continue;
                if (this.reinforcementTypes == null) break;
                boolean flag = false;
                for (Class<?> oclass : this.reinforcementTypes) {
                    if (mobentity.getClass() != oclass) continue;
                    flag = true;
                    break;
                }
                if (!flag) break;
            }
            this.setAttackTarget(mobentity, lastHurtByMob);
        }
    }

    protected void setAttackTarget(Mob mobIn, LivingEntity targetIn) {
        mobIn.m_6710_(targetIn);
    }
}

