/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.mixin;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Drowned.class})
public abstract class DrownedEntityMixin
extends Zombie {
    public DrownedEntityMixin(EntityType<? extends Zombie> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(at={@At(value="RETURN")}, method={"canReplaceCurrentItem"}, cancellable=true)
    private void checkForAnyTrident(ItemStack replacement, ItemStack current, CallbackInfoReturnable<Boolean> cir) {
        if (current.m_41720_() == Items.f_42715_) {
            cir.setReturnValue((Object)false);
        } else if (current.m_41720_() instanceof TridentItem) {
            if (replacement.m_41720_() instanceof TridentItem) {
                cir.setReturnValue((Object)(replacement.m_41773_() < current.m_41773_() ? 1 : 0));
            } else {
                cir.setReturnValue((Object)false);
            }
        } else {
            cir.setReturnValue((Object)(replacement.m_41720_() instanceof TridentItem || super.m_7808_(replacement, current) ? 1 : 0));
        }
    }

    @ModifyVariable(at=@At(value="STORE"), method={"performRangedAttack"})
    private ThrownTrident createTrident(ThrownTrident original) {
        InteractionHand tridentHoldingHand = ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof TridentItem);
        ItemStack tridentStack = this.m_21120_(tridentHoldingHand);
        return new ThrownTrident(this.f_19853_, (LivingEntity)this, tridentStack);
    }
}

