/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.mixin;

import com.infamous.dungeons_mobs.config.DungeonsMobsConfig;
import com.infamous.dungeons_mobs.goals.RangedWebAttackGoal;
import com.infamous.dungeons_mobs.interfaces.ITrapsTarget;
import com.infamous.dungeons_mobs.interfaces.IWebShooter;
import com.infamous.dungeons_mobs.mixin.GoalSelectorAccessor;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import java.util.List;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Spider.class})
public abstract class SpiderEntityMixin
extends Monster
implements IWebShooter {
    private static final EntityDataAccessor<Boolean> WEBSHOOTING = SynchedEntityData.m_135353_(Spider.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private RangedWebAttackGoal<?> rangedWebAttackGoal;
    private LeapAtTargetGoal leapAtTargetGoal;
    private MeleeAttackGoal meleeAttackGoal;
    public int targetTrappedCounter = 0;

    protected SpiderEntityMixin(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
    }

    @Inject(at={@At(value="TAIL")}, method={"registerGoals"})
    private void registerGoals(CallbackInfo callbackInfo) {
        ((GoalSelectorAccessor)this.f_21345_).getAvailableGoals().stream().filter(pg -> pg.m_26012_() == 4 && pg.m_26015_() instanceof MeleeAttackGoal).findFirst().ifPresent(pg -> {
            this.meleeAttackGoal = (MeleeAttackGoal)pg.m_26015_();
        });
        ((GoalSelectorAccessor)this.f_21345_).getAvailableGoals().stream().filter(pg -> pg.m_26012_() == 3 && pg.m_26015_() instanceof LeapAtTargetGoal).findFirst().ifPresent(pg -> {
            this.leapAtTargetGoal = (LeapAtTargetGoal)pg.m_26015_();
        });
        this.rangedWebAttackGoal = new RangedWebAttackGoal<SpiderEntityMixin>(this, 1.0, 60, 20.0f);
    }

    @Inject(at={@At(value="RETURN")}, method={"defineSynchedData"})
    private void registerData(CallbackInfo callbackInfo) {
        this.f_19804_.m_135372_(WEBSHOOTING, (Object)false);
    }

    protected void m_8024_() {
        super.m_8024_();
        if (((Boolean)DungeonsMobsConfig.COMMON.ENABLE_RANGED_SPIDERS.get()).booleanValue() && this.m_6095_() != EntityType.f_20554_) {
            this.reassessAttackGoals();
        }
    }

    private void reassessAttackGoals() {
        LivingEntity target = this.m_5448_();
        if (this.meleeAttackGoal != null && this.rangedWebAttackGoal != null && target != null) {
            if (!this.isTargetTrapped()) {
                this.f_21345_.m_25363_((Goal)this.meleeAttackGoal);
                if (this.leapAtTargetGoal != null) {
                    this.f_21345_.m_25363_((Goal)this.leapAtTargetGoal);
                }
                this.f_21345_.m_25352_(4, this.rangedWebAttackGoal);
            } else {
                this.f_21345_.m_25363_(this.rangedWebAttackGoal);
                if (this.leapAtTargetGoal != null) {
                    this.f_21345_.m_25352_(3, (Goal)this.leapAtTargetGoal);
                }
                this.f_21345_.m_25352_(4, (Goal)this.meleeAttackGoal);
            }
        }
    }

    public void m_6075_() {
        super.m_6075_();
        if (this.targetTrappedCounter > 0) {
            --this.targetTrappedCounter;
        }
    }

    @Override
    public void setTargetTrapped(boolean trapped, boolean notifyOthers) {
        TargetingConditions spiderTargeting = TargetingConditions.m_148352_().m_26883_(10.0).m_26893_();
        if (notifyOthers) {
            List spiders = this.f_19853_.m_45971_(Spider.class, spiderTargeting, (LivingEntity)this, this.m_20191_().m_82400_(10.0));
            for (Spider spider : spiders) {
                if (!(spider instanceof ITrapsTarget) || this.m_5448_() == null || spider.m_5448_() == null || spider.m_5448_() != this.m_5448_()) continue;
                ((ITrapsTarget)spider).setTargetTrapped(trapped, false);
            }
        }
        this.targetTrappedCounter = trapped ? 20 : 0;
    }

    @Override
    public boolean isTargetTrapped() {
        return this.targetTrappedCounter > 0;
    }

    @Override
    public void setWebShooting(boolean webShooting) {
        this.m_5496_((SoundEvent)ModSoundEvents.SPIDER_PREPARE_SHOOT.get(), this.m_6121_(), this.m_6100_());
        this.f_19804_.m_135381_(WEBSHOOTING, (Object)webShooting);
    }

    @Override
    public boolean isWebShooting() {
        return (Boolean)this.f_19804_.m_135370_(WEBSHOOTING);
    }
}

