/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.mixin;

import com.infamous.dungeons_mobs.compat.DungeonsGearCompat;
import com.infamous.dungeons_mobs.entities.SpawnEquipmentHelper;
import com.infamous.dungeons_mobs.mixin.ArrowAccessor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WitherSkeleton.class})
public abstract class WitherSkeletonEntityMixin
extends AbstractSkeleton {
    protected WitherSkeletonEntityMixin(EntityType<? extends AbstractSkeleton> p_i48555_1_, Level p_i48555_2_) {
        super(p_i48555_1_, p_i48555_2_);
    }

    @Inject(at={@At(value="RETURN")}, method={"getArrow"})
    private void getWitherArrow(ItemStack ammoStack, float p_213624_2_, CallbackInfoReturnable<AbstractArrow> cir) {
        AbstractArrow arrow = (AbstractArrow)cir.getReturnValue();
        arrow.m_20095_();
        if (arrow instanceof Arrow && ((ArrowAccessor)arrow).getEffects().isEmpty()) {
            int difficultyFactor = 0;
            if (this.f_19853_.m_46791_() == Difficulty.NORMAL) {
                difficultyFactor = 5;
            } else if (this.f_19853_.m_46791_() == Difficulty.HARD) {
                difficultyFactor = 10;
            }
            if (difficultyFactor > 0) {
                ((Arrow)arrow).m_36870_(new MobEffectInstance(MobEffects.f_19615_, difficultyFactor * 20));
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"populateDefaultEquipmentSlots"})
    private void setEquipmentOnInitialSpawn(RandomSource randomSource, DifficultyInstance difficultyInstance, CallbackInfo ci) {
        SpawnEquipmentHelper.equipMainhand(this.createSpawnWeapon(), (Mob)this);
    }

    private ItemStack createSpawnWeapon() {
        ItemStack bowStack = new ItemStack((ItemLike)Items.f_42411_);
        ItemStack swordStack = new ItemStack((ItemLike)Items.f_42425_);
        if (DungeonsGearCompat.isLoaded()) {
            bowStack = new ItemStack((ItemLike)DungeonsGearCompat.getRedSnake().get());
            swordStack = new ItemStack((ItemLike)DungeonsGearCompat.getStoneSword().get());
        }
        return (double)this.f_19796_.m_188501_() < 0.5 ? bowStack : swordStack;
    }
}

