/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.mobenchants;

import baguchan.enchantwithmob.mobenchant.MobEnchant;
import com.infamous.dungeons_libraries.utils.AreaOfEffectHelper;
import com.infamous.dungeons_mobs.DungeonsMobs;
import com.infamous.dungeons_mobs.capabilities.properties.MobProps;
import com.infamous.dungeons_mobs.capabilities.properties.MobPropsHelper;
import com.infamous.dungeons_mobs.mobenchants.NewMobEnchantUtils;
import com.infamous.dungeons_mobs.mod.ModMobEnchants;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BurningMobEnchant
extends MobEnchant {
    public BurningMobEnchant(MobEnchant.Properties properties) {
        super(properties);
    }

    @SubscribeEvent
    public static void OnLivingUpdate(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        NewMobEnchantUtils.executeIfPresentWithLevel(entity, (MobEnchant)ModMobEnchants.BURNING.get(), level -> {
            MobProps comboCap = MobPropsHelper.getMobPropsCapability((Entity)entity);
            if (comboCap == null) {
                return;
            }
            int burnNearbyTimer = comboCap.getBurnNearbyTimer();
            if (burnNearbyTimer <= 0) {
                DungeonsMobs.PROXY.spawnParticles((Entity)entity, ParticleTypes.f_123744_);
                AreaOfEffectHelper.applyToNearbyEntities((LivingEntity)entity, (float)1.5f, (Predicate)AreaOfEffectHelper.getCanApplyToEnemyPredicate((LivingEntity)entity), nearbyEntity -> {
                    nearbyEntity.m_6469_(DamageSource.f_19307_, 0.5f * (float)level.intValue());
                    DungeonsMobs.PROXY.spawnParticles((Entity)nearbyEntity, ParticleTypes.f_123744_);
                });
                comboCap.setBurnNearbyTimer(20);
            } else {
                comboCap.setBurnNearbyTimer(burnNearbyTimer - 1);
            }
        });
    }
}

