/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.mobenchants;

import baguchan.enchantwithmob.mobenchant.MobEnchant;
import com.infamous.dungeons_libraries.utils.AreaOfEffectHelper;
import com.infamous.dungeons_mobs.DungeonsMobs;
import com.infamous.dungeons_mobs.capabilities.properties.MobProps;
import com.infamous.dungeons_mobs.capabilities.properties.MobPropsHelper;
import com.infamous.dungeons_mobs.mobenchants.NewMobEnchantUtils;
import com.infamous.dungeons_mobs.mod.ModMobEnchants;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ChillingMobEnchant
extends MobEnchant {
    public ChillingMobEnchant(MobEnchant.Properties properties) {
        super(properties);
    }

    @SubscribeEvent
    public static void OnLivingUpdate(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        NewMobEnchantUtils.executeIfPresentWithLevel(entity, (MobEnchant)ModMobEnchants.CHILLING.get(), level -> {
            MobProps comboCap = MobPropsHelper.getMobPropsCapability((Entity)entity);
            if (comboCap == null) {
                return;
            }
            int freezeNearbyTimer = comboCap.getFreezeNearbyTimer();
            if (freezeNearbyTimer <= 0) {
                DungeonsMobs.PROXY.spawnParticles((Entity)entity, ParticleTypes.f_123754_);
                AreaOfEffectHelper.applyToNearbyEntities((LivingEntity)entity, (float)1.5f, (Predicate)AreaOfEffectHelper.getCanApplyToEnemyPredicate((LivingEntity)entity), nearbyEntity -> {
                    ChillingMobEnchant.freezeEnemy(1, nearbyEntity, level);
                    DungeonsMobs.PROXY.spawnParticles((Entity)nearbyEntity, ParticleTypes.f_123754_);
                });
                comboCap.setFreezeNearbyTimer(40);
            } else {
                comboCap.setFreezeNearbyTimer(freezeNearbyTimer - 1);
            }
        });
    }

    private static void freezeEnemy(int amplifier, LivingEntity nearbyEntity, int durationInSeconds) {
        MobEffectInstance slowness = new MobEffectInstance(MobEffects.f_19597_, durationInSeconds * 20, amplifier);
        MobEffectInstance fatigue = new MobEffectInstance(MobEffects.f_19599_, durationInSeconds * 20, Math.max(0, amplifier * 2 - 1));
        nearbyEntity.m_7292_(slowness);
        nearbyEntity.m_7292_(fatigue);
        DungeonsMobs.PROXY.spawnParticles((Entity)nearbyEntity, ParticleTypes.f_123754_);
    }
}

