/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.network.message;

import com.infamous.dungeons_mobs.capabilities.animatedprops.AnimatedProps;
import com.infamous.dungeons_mobs.capabilities.animatedprops.AnimatedPropsHelper;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class AnimatedPropsMessage {
    private final int entityId;
    private final AnimatedProps cap;

    public AnimatedPropsMessage(int entityId, AnimatedProps cap) {
        this.entityId = entityId;
        this.cap = cap;
    }

    public static AnimatedPropsMessage decode(FriendlyByteBuf buffer) {
        int entityId = buffer.readInt();
        AnimatedProps cap = new AnimatedProps();
        cap.setAttackAnimationTick(buffer.readInt());
        cap.setAttackAnimationLength(buffer.readInt());
        cap.setAttackAnimationActionPoint(buffer.readInt());
        return new AnimatedPropsMessage(entityId, cap);
    }

    public static boolean onPacketReceived(AnimatedPropsMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                Entity entity = Minecraft.m_91087_().f_91074_.f_19853_.m_6815_(message.entityId);
                if (entity instanceof Mob) {
                    AnimatedProps cap = AnimatedPropsHelper.getAnimatedPropsCapability((Mob)entity);
                    cap.setAttackAnimationTick(message.cap.getAttackAnimationTick());
                    cap.setAttackAnimationLength(message.cap.getAttackAnimationLength());
                    cap.setAttackAnimationActionPoint(message.cap.getAttackAnimationActionPoint());
                }
            });
        }
        return true;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeInt(this.cap.getAttackAnimationTick());
        buffer.writeInt(this.cap.getAttackAnimationLength());
        buffer.writeInt(this.cap.getAttackAnimationActionPoint());
    }
}

