/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.worldgen;

import com.infamous.dungeons_mobs.mod.ModStructureModifiers;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.common.world.ModifiableStructureInfo;
import net.minecraftforge.common.world.StructureModifier;
import net.minecraftforge.common.world.StructureSettingsBuilder;
import net.minecraftforge.registries.ForgeRegistries;

public class DungeonsMobsStructureModifiers {

    public record RemoveSpawnsStructureModifier(HolderSet<Structure> structures, HolderSet<EntityType<?>> entityTypes) implements StructureModifier
    {
        public void modify(Holder<Structure> structure, StructureModifier.Phase phase, ModifiableStructureInfo.StructureInfo.Builder builder) {
            if (phase == StructureModifier.Phase.REMOVE && this.structures.m_203333_(structure)) {
                StructureSettingsBuilder structureSettings = builder.getStructureSettings();
                for (MobCategory mobCategory : MobCategory.values()) {
                    StructureSettingsBuilder.StructureSpawnOverrideBuilder spawnOverrides = structureSettings.getSpawnOverrides(mobCategory);
                    if (spawnOverrides == null) continue;
                    List spawns = spawnOverrides.getSpawns();
                    spawns.removeIf(spawnerData -> this.entityTypes.m_203333_((Holder)ForgeRegistries.ENTITY_TYPES.getHolder((Object)spawnerData.f_48404_).get()));
                }
            }
        }

        public Codec<? extends StructureModifier> codec() {
            return (Codec)ModStructureModifiers.REMOVE_SPAWNS_STRUCTURE_MODIFIER_TYPE.get();
        }
    }

    public record AddSpawnsStructureModifier(HolderSet<Structure> structures, List<MobSpawnSettings.SpawnerData> spawners) implements StructureModifier
    {
        public void modify(Holder<Structure> structure, StructureModifier.Phase phase, ModifiableStructureInfo.StructureInfo.Builder builder) {
            if (phase == StructureModifier.Phase.ADD && this.structures.m_203333_(structure)) {
                StructureSettingsBuilder structureSettings = builder.getStructureSettings();
                for (MobSpawnSettings.SpawnerData spawner : this.spawners) {
                    EntityType type = spawner.f_48404_;
                    structureSettings.getOrAddSpawnOverrides(type.m_20674_()).addSpawn(spawner);
                }
            }
        }

        public Codec<? extends StructureModifier> codec() {
            return (Codec)ModStructureModifiers.ADD_SPAWNS_STRUCTURE_MODIFIER_TYPE.get();
        }
    }
}

