/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.commands.client;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.keksuccino.fancymenu.commands.client.ClientExecutor;
import de.keksuccino.fancymenu.commands.client.CommandUtils;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.guicreator.CustomGuiLoader;
import de.keksuccino.fancymenu.menu.guiconstruction.GuiConstructor;
import de.keksuccino.konkrete.localization.Locals;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public class OpenGuiScreenCommand {
    public static void register(CommandDispatcher<CommandSourceStack> d) {
        d.register((LiteralArgumentBuilder)Commands.m_82127_((String)"openguiscreen").then((ArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"menu_identifier", (ArgumentType)StringArgumentType.string()).executes(stack -> OpenGuiScreenCommand.openGui((CommandSourceStack)stack.getSource(), StringArgumentType.getString((CommandContext)stack, (String)"menu_identifier")))).suggests((context, provider) -> CommandUtils.getStringSuggestions(provider, "<menu_identifier>"))));
    }

    private static int openGui(CommandSourceStack stack, String menuIdentifierOrCustomGuiName) {
        try {
            if (menuIdentifierOrCustomGuiName.equalsIgnoreCase(CreateWorldScreen.class.getName())) {
                CreateWorldScreen.m_232896_((Minecraft)Minecraft.m_91087_(), (Screen)Minecraft.m_91087_().f_91080_);
                return 1;
            }
            if (CustomGuiLoader.guiExists(menuIdentifierOrCustomGuiName)) {
                ClientExecutor.execute(() -> Minecraft.m_91087_().m_91152_((Screen)CustomGuiLoader.getGui(menuIdentifierOrCustomGuiName, Minecraft.m_91087_().f_91080_, null)));
            } else {
                Screen s = GuiConstructor.tryToConstruct(MenuCustomization.getValidMenuIdentifierFor(menuIdentifierOrCustomGuiName));
                if (s != null) {
                    ClientExecutor.execute(() -> Minecraft.m_91087_().m_91152_(s));
                } else {
                    stack.m_81352_((Component)Component.m_237113_((String)Locals.localize((String)"fancymenu.commands.openguiscreen.cannotopen", (String[])new String[0])));
                }
            }
        }
        catch (Exception e) {
            stack.m_81352_((Component)Component.m_237113_((String)Locals.localize((String)"fancymenu.commands.openguiscreen.error", (String[])new String[0])));
            e.printStackTrace();
        }
        return 1;
    }
}

