/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.explosiveenhancement;

import dev.xylonity.explosiveenhancement.ExplosiveEnhancement;
import dev.xylonity.explosiveenhancement.config.ExplosiveValues;
import dev.xylonity.explosiveenhancement.particle.ExplosiveParticles;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.Level;

public class ExplosiveHandler {
    public static void spawnParticles(Level world, double x, double y, double z, float power, boolean isUnderWater, boolean didDestroyBlocks, boolean isImportant) {
        if (ExplosiveValues.debugLogs) {
            ExplosiveEnhancement.LOGGER.info("ExplosiveConfig has been called!");
        }
        power = isUnderWater ? (ExplosiveValues.dynamicUnderwater ? power : 4.0f) : (ExplosiveValues.dynamicSize ? power : 4.0f);
        y = ExplosiveValues.attemptBetterSmallExplosions && power == 1.0f ? y + ExplosiveValues.smallExplosionYOffset : y;
        isImportant = isImportant || ExplosiveValues.alwaysShow;
        float blastwavePower = power * 1.75f;
        float fireballPower = power * 1.25f;
        float smokePower = power * 0.4f;
        if (isUnderWater) {
            if (ExplosiveValues.showUnderwaterBlastWave) {
                world.m_6493_((ParticleOptions)ExplosiveParticles.UNDERWATERBLASTWAVE.get(), isImportant, x, y + 0.5, z, (double)blastwavePower, 0.0, 0.0);
            }
            if (ExplosiveValues.showShockwave) {
                world.m_6493_((ParticleOptions)ExplosiveParticles.SHOCKWAVE.get(), isImportant, x, y + 0.5, z, (double)fireballPower, isImportant ? 1.0 : 0.0, 0.0);
            } else if (ExplosiveValues.showUnderwaterSparks) {
                world.m_6493_((ParticleOptions)ExplosiveParticles.BLANK_SHOCKWAVE.get(), isImportant, x, y + 0.5, z, (double)fireballPower, isImportant ? 1.0 : 0.0, 0.0);
            }
            for (int total = ExplosiveValues.bubbleAmount; total >= 1; --total) {
                world.m_6493_((ParticleOptions)ExplosiveParticles.BUBBLE.get(), isImportant, x, y, z, (double)ExplosiveHandler.nextBetween(1, 7) * 0.3 * (double)ExplosiveHandler.nextBetween(-1, 1), (double)ExplosiveHandler.nextBetween(1, 10) * 0.1, (double)ExplosiveHandler.nextBetween(1, 7) * 0.3 * (double)ExplosiveHandler.nextBetween(-1, 1));
            }
            if (ExplosiveValues.showDefaultExplosionUnderwater) {
                ExplosiveHandler.showDefaultParticles(world, x, y, z, power, didDestroyBlocks, isImportant);
            }
        } else {
            if (ExplosiveValues.debugLogs) {
                ExplosiveEnhancement.LOGGER.info("Particle is being shown!");
            }
            if (ExplosiveValues.showBlastWave) {
                world.m_6493_((ParticleOptions)ExplosiveParticles.BLASTWAVE.get(), isImportant, x, y, z, (double)blastwavePower, 0.0, 0.0);
            }
            if (ExplosiveValues.showFireball) {
                world.m_6493_((ParticleOptions)ExplosiveParticles.FIREBALL.get(), isImportant, x, y + 0.5, z, (double)fireballPower, isImportant ? 1.0 : 0.0, 0.0);
            } else if (ExplosiveValues.showSparks) {
                world.m_6493_((ParticleOptions)ExplosiveParticles.BLANK_FIREBALL.get(), isImportant, x, y + 0.5, z, (double)fireballPower, isImportant ? 1.0 : 0.0, 0.0);
            }
            if (ExplosiveValues.showMushroomCloud) {
                world.m_6493_((ParticleOptions)ExplosiveParticles.SMOKE.get(), isImportant, x, y, z, (double)power, (double)power * 0.25, 0.0);
                world.m_6493_((ParticleOptions)ExplosiveParticles.SMOKE.get(), isImportant, x, y, z, (double)power, (double)smokePower, 0.0);
                world.m_6493_((ParticleOptions)ExplosiveParticles.SMOKE.get(), isImportant, x, y, z, 0.15, (double)smokePower, (double)power);
                world.m_6493_((ParticleOptions)ExplosiveParticles.SMOKE.get(), isImportant, x, y, z, -0.15, (double)smokePower, (double)power);
                world.m_6493_((ParticleOptions)ExplosiveParticles.SMOKE.get(), isImportant, x, y, z, (double)power, (double)smokePower, 0.15);
                world.m_6493_((ParticleOptions)ExplosiveParticles.SMOKE.get(), isImportant, x, y, z, (double)power, (double)smokePower, -0.15);
            }
            if (ExplosiveValues.showDefaultExplosion) {
                ExplosiveHandler.showDefaultParticles(world, x, y, z, power, didDestroyBlocks, isImportant);
            }
        }
        if (ExplosiveValues.debugLogs) {
            ExplosiveEnhancement.LOGGER.info("Particle finished!");
        }
    }

    private static void showDefaultParticles(Level world, double x, double y, double z, float power, boolean didDestroyBlocks, boolean isImportant) {
        if (!(power < 2.0f) && didDestroyBlocks) {
            world.m_6493_((ParticleOptions)ParticleTypes.f_123812_, isImportant, x, y, z, 1.0, 0.0, 0.0);
        } else {
            world.m_6493_((ParticleOptions)ParticleTypes.f_123813_, isImportant, x, y, z, 1.0, 0.0, 0.0);
        }
    }

    private static int nextBetween(int min, int max) {
        Random random = new Random();
        return random.nextInt(min, max);
    }
}

